/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.business;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static final Map<String, String> serviceMap = new HashMap<String, String>(16);

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"tdc-talp-business", (Object[])new Object[0]), serviceName));
        }
        try {
            Class<?> clz = Class.forName(className);
            return clz.newInstance();
        }
        catch (Exception exp) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"tdc-talp-business", (Object[])new Object[0]), serviceName), exp);
        }
    }

    static {
        serviceMap.put("ExternalService", "kd.tdc.talp.business.application.external.ExternalService");
        serviceMap.put("EntryExitPoolApplicationService", "kd.tdc.talp.business.application.service.EntryExitPoolApplicationService");
        serviceMap.put("RecommendApplicationService", "kd.tdc.talp.business.application.service.RecommendApplicationService");
        serviceMap.put("WorkbenchApplicationService", "kd.tdc.talp.business.application.service.WorkbenchApplicationService");
        serviceMap.put("EntryExitPoolDomainService", "kd.tdc.talp.business.domain.entryexitpool.service.EntryExitPoolDomainService");
        serviceMap.put("RecommendDomainService", "kd.tdc.talp.business.domain.recommend.service.RecommendDomainService");
        serviceMap.put("FormBasicService", "kd.tdc.talp.business.servicehelper.FormBasicService");
        serviceMap.put("EntryExitPoolQueryHelper", "kd.tdc.talp.business.servicehelper.EntryExitPoolQueryHelper");
        serviceMap.put("RecommendQueryHelper", "kd.tdc.talp.business.servicehelper.RecommendQueryHelper");
        serviceMap.put("PendingRecommendService", "kd.tdc.talp.formplugin.formservice.PendingRecommendService");
        serviceMap.put("TalentRecommendService", "kd.tdc.talp.formplugin.formservice.TalentRecommendService");
        serviceMap.put("TerminationBillService", "kd.tdc.talp.formplugin.formservice.TerminationBillService");
        serviceMap.put("AppWorkbenchService", "kd.tdc.talp.formplugin.formservice.AppWorkbenchService");
    }
}

