/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.business.application.service;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.business.ServiceFactory;
import kd.tdc.talp.business.domain.entryexitpool.service.EntryExitPoolDomainService;
import kd.tdc.talp.common.enums.entryexitpool.EntryExitPoolStatusEnum;
import kd.tdc.talp.common.enums.entryexitpool.JumpEntryExitPoolEnum;
import kd.tdc.tdcs.bussiness.application.TalentPoolApplicationService;

public class EntryExitPoolApplicationService {
    private static final Log LOG = LogFactory.getLog(EntryExitPoolApplicationService.class);
    private static final EntryExitPoolDomainService ENTRY_EXIT_POOL_SERVICE = ServiceFactory.getService(EntryExitPoolDomainService.class);
    private static final TalentPoolApplicationService TALENT_POOL_SERVICE = (TalentPoolApplicationService)kd.tdc.tdcs.bussiness.ServiceFactory.getServiceNoNeedRegister(TalentPoolApplicationService.class);

    private DynamicObject[] queryAuditCompletedBill(QFilter[] qFilters) {
        return ENTRY_EXIT_POOL_SERVICE.loadDynamicObjectArray(qFilters);
    }

    public void updateEntryExitPoolBills(DynamicObject[] beUpdateBills) {
        ENTRY_EXIT_POOL_SERVICE.updateEntryExitPoolBills(beUpdateBills);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void effectiveEntryExitPool() {
        Date currDate = new Date();
        Date truncateCurrDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        Object[] entryExitLPoolBill = this.queryAuditCompletedBill();
        if (HRArrayUtils.isNotEmpty((Object[])entryExitLPoolBill)) {
            DynamicObjectCollection beUpdateEntryPoolBillColl = new DynamicObjectCollection();
            DynamicObjectCollection beUpdateExitPoolBillColl = new DynamicObjectCollection();
            Arrays.stream(entryExitLPoolBill).forEach(item -> {
                Date outOfPoolDate;
                String businessStatus = item.getString("businessstatus");
                if (HRStringUtils.equals((String)businessStatus, (String)EntryExitPoolStatusEnum.INTO_POOL.getStatus())) {
                    if (item.getDate("intopooldate").compareTo(truncateCurrDate) <= 0) {
                        item.set("businessstatus", (Object)EntryExitPoolStatusEnum.IN_POOL.getStatus());
                        item.set("modifytime", (Object)currDate);
                        item.set("modifier", (Object)currUserId);
                        beUpdateEntryPoolBillColl.add(item);
                    }
                } else if (HRStringUtils.equals((String)businessStatus, (String)EntryExitPoolStatusEnum.OUT_TO_POOL.getStatus()) && !Objects.isNull(outOfPoolDate = item.getDate("outofpooldate")) && outOfPoolDate.compareTo(truncateCurrDate) <= 0) {
                    item.set("businessstatus", (Object)EntryExitPoolStatusEnum.OUT_POOL.getStatus());
                    item.set("modifier", (Object)currUserId);
                    item.set("modifytime", (Object)currDate);
                    beUpdateExitPoolBillColl.add(item);
                }
            });
            try (TXHandle exitTxHandle = TX.required();){
                if (!CollectionUtils.isEmpty((Collection)beUpdateExitPoolBillColl)) {
                    this.updateEntryExitPoolBills((DynamicObject[])beUpdateExitPoolBillColl.toArray((Object[])new DynamicObject[0]));
                    TALENT_POOL_SERVICE.updateReserveTalentColl((DynamicObject[])beUpdateExitPoolBillColl.toArray((Object[])new DynamicObject[0]));
                    Map<Long, List<DynamicObject>> poolSubtractNumMap = beUpdateExitPoolBillColl.stream().collect(Collectors.groupingBy(bill -> bill.getLong("talentpool_id")));
                    TALENT_POOL_SERVICE.batchSubtractInPoolNum(poolSubtractNumMap);
                }
            }
            try (TXHandle entryTxHandle = TX.required();){
                if (!CollectionUtils.isEmpty((Collection)beUpdateEntryPoolBillColl)) {
                    this.updateEntryExitPoolBills((DynamicObject[])beUpdateEntryPoolBillColl.toArray((Object[])new DynamicObject[0]));
                    TALENT_POOL_SERVICE.generateReserveTalentColl((DynamicObject[])beUpdateEntryPoolBillColl.toArray((Object[])new DynamicObject[0]));
                    Map<Long, List<DynamicObject>> canAddSizeMap = beUpdateEntryPoolBillColl.stream().collect(Collectors.groupingBy(bill -> bill.getLong("talentpool_id")));
                    TALENT_POOL_SERVICE.batchAddInPoolNum(canAddSizeMap);
                }
            }
        }
    }

    private DynamicObject[] queryAuditCompletedBill() {
        return this.queryAuditCompletedBill(new QFilter[]{new QFilter("businessstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{EntryExitPoolStatusEnum.INTO_POOL.getStatus(), EntryExitPoolStatusEnum.OUT_TO_POOL.getStatus()})), new QFilter("billstatus", "=", (Object)"C")});
    }

    public BillShowParameter buildFormShowParameter(String operateKey) {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setStatus(OperationStatus.ADDNEW);
        bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        JumpEntryExitPoolEnum enumByOperationKey = JumpEntryExitPoolEnum.getEnumByOperationKey((String)operateKey);
        if (Objects.isNull(enumByOperationKey)) {
            return null;
        }
        bsp.setFormId(enumByOperationKey.getFormId());
        return bsp;
    }

    public void leaveStopEntryExitBill(Long employee) {
        ENTRY_EXIT_POOL_SERVICE.leaveStopEntryExitBill(employee);
    }
}

