/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.business.application.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tdc.talp.business.ServiceFactory;
import kd.tdc.talp.business.domain.recommend.entityservice.RecommendEntityService;
import kd.tdc.talp.business.domain.recommend.service.RecommendDomainService;
import kd.tdc.talp.common.constants.recommend.RecommendConstants;
import kd.tdc.talp.common.enums.recommend.HandleStatusEnum;
import kd.tdc.tdcs.bussiness.application.TalentFileApplicationService;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;
import kd.tdc.tdcs.bussiness.application.external.MessageService;

public class RecommendApplicationService
implements RecommendConstants {
    private static final Log LOG = LogFactory.getLog(RecommendApplicationService.class);
    private static final TalentFileApplicationService FILE_APPLICATION_SERVICE = (TalentFileApplicationService)kd.tdc.tdcs.bussiness.ServiceFactory.getService(TalentFileApplicationService.class);
    private static final HrpiService HRPI_SERVICE = (HrpiService)kd.tdc.tdcs.bussiness.ServiceFactory.getService(HrpiService.class);
    private static final RecommendDomainService RECOMMEND_DOMAIN_SERVICE = ServiceFactory.getService(RecommendDomainService.class);
    private static final MessageService MESSAGE_SERVICE = (MessageService)kd.tdc.tdcs.bussiness.ServiceFactory.getServiceNoNeedRegister(MessageService.class);

    public void save(DynamicObject[] dynamicObjects) {
        RECOMMEND_DOMAIN_SERVICE.save(dynamicObjects);
    }

    public void updateHandleStatus(Set<Long> recommendIds, HandleStatusEnum handleStatusEnum) {
        DynamicObjectCollection collection = RECOMMEND_DOMAIN_SERVICE.updateHandleStatus(recommendIds, handleStatusEnum);
        collection.forEach(bill -> {
            long id = bill.getLong("id");
            DynamicObject recommendEmp = bill.getDynamicObject("recommendemp");
            if (!Objects.isNull(recommendEmp)) {
                long recommendEmpId = recommendEmp.getLong("id");
                MESSAGE_SERVICE.sendTemplateMessageNoBtn(Long.valueOf(id), Long.valueOf(recommendEmpId), "talp_talentrecommend", "talp_recommendintopool");
            }
        });
    }

    public void leaveIgnoreRecommend(Long employee) {
        RECOMMEND_DOMAIN_SERVICE.leaveIgnoreRecommend(employee);
    }

    public FormShowParameter getTalentRecommendForm(Map<String, Object> param) {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId("talp_talentrecommend");
        bsp.setStatus(OperationStatus.ADDNEW);
        bsp.setCustomParams(param);
        bsp.getOpenStyle().setShowType(ShowType.Modal);
        return bsp;
    }

    public Map<String, Object> saveTalentRecommend(Map<String, Object> paramMap) {
        List data;
        RecommendEntityService entityService = new RecommendEntityService();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (CollectionUtils.isEmpty(paramMap) || ObjectUtils.isEmpty((Object)paramMap.get("data"))) {
            return entityService.buildResult(result, "0", "400", ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u9519\u8bef", (String)"RecommendApplicationService_5", (String)"tdc-talp-business", (Object[])new Object[0]), null);
        }
        Long org = (Long)paramMap.get("org");
        if (org == null || org == 0L) {
            return entityService.buildResult(result, "0", "400", ResManager.loadKDString((String)"\u201c\u4eba\u624d\u7ba1\u7406\u7ec4\u7ec7\u201d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RecommendApplicationService_7", (String)"tdc-talp-business", (Object[])new Object[0]), null);
        }
        Long recommendsource = (Long)paramMap.get("recommendsource");
        if (recommendsource == null || recommendsource == 0L) {
            return entityService.buildResult(result, "0", "400", ResManager.loadKDString((String)"\u201c\u63a8\u8350\u6765\u6e90\u201d\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"RecommendApplicationService_6", (String)"tdc-talp-business", (Object[])new Object[0]), null);
        }
        try {
            data = (List)paramMap.get("data");
        }
        catch (Exception e) {
            LOG.error("RecommendApplicationService.saveTalentRecommend execute error", (Throwable)e);
            return entityService.buildResult(result, "0", "400", ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u9519\u8bef", (String)"RecommendApplicationService_5", (String)"tdc-talp-business", (Object[])new Object[0]), null);
        }
        if (data.size() < 1) {
            return entityService.buildResult(result, "0", "400", ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u9519\u8bef", (String)"RecommendApplicationService_5", (String)"tdc-talp-business", (Object[])new Object[0]), null);
        }
        ArrayList<Map<String, Object>> errorData = new ArrayList<Map<String, Object>>(data.size());
        ArrayList<Map<String, Object>> tempSuccessData = new ArrayList<Map<String, Object>>(data.size());
        List employeeIds = data.stream().filter(map -> !ObjectUtils.isEmpty(map.get("employee"))).map(map -> (Long)map.get("employee")).collect(Collectors.toList());
        Map talentFileMap = FILE_APPLICATION_SERVICE.queryTalentFileByEmpIds(org, employeeIds);
        if (talentFileMap == null) {
            return entityService.buildResult(result, "0", "500", ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u751f\u6548\u7684\u4eba\u624d\u6863\u6848\u3002", (String)"RecommendApplicationService_11", (String)"tdc-talp-business", (Object[])new Object[0]), null);
        }
        try {
            entityService.validate(data, org, errorData, tempSuccessData, talentFileMap);
        }
        catch (Exception e) {
            return entityService.buildResult(result, "0", "500", e.getMessage(), null);
        }
        if (errorData.size() == 0 && tempSuccessData.size() == 0) {
            return entityService.buildResult(result, "0", "400", ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u9519\u8bef", (String)"RecommendApplicationService_5", (String)"tdc-talp-business", (Object[])new Object[0]), null);
        }
        if (tempSuccessData.size() > 0) {
            try {
                Map primaryEmpInfoMap = HRPI_SERVICE.queryPrimaryEmpInfoByEmpIds(employeeIds);
                RECOMMEND_DOMAIN_SERVICE.recommendIntoPool(tempSuccessData, org, primaryEmpInfoMap, talentFileMap, recommendsource);
            }
            catch (Exception e) {
                LOG.error("RecommendApplicationService.saveData execute error", (Throwable)e);
                return entityService.buildResult(result, "0", "500", ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4fdd\u5b58\u5931\u8d25\u3002", (String)"RecommendApplicationService_10", (String)"tdc-talp-business", (Object[])new Object[0]), null);
            }
            if (tempSuccessData.size() == data.size()) {
                entityService.buildResult(result, "1", "200", null, null);
            } else {
                entityService.buildResult(result, "2", "500", null, errorData);
            }
        } else {
            entityService.buildResult(result, "2", "500", null, errorData);
        }
        return result;
    }

    public void poolPermChange(List<Long> poolIds) {
        RECOMMEND_DOMAIN_SERVICE.poolPermChange(poolIds);
    }
}

