/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.business.domain.recommend.entityservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.tdc.talp.business.servicehelper.RecommendQueryHelper;
import kd.tdc.talp.common.constants.recommend.RecommendConstants;
import kd.tdc.talp.common.enums.recommend.HandleStatusEnum;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;

public class RecommendEntityService
implements RecommendConstants {
    private static final HrpiService HRPI_SERVICE = (HrpiService)ServiceFactory.getService(HrpiService.class);
    private static final String ERROR_MSG = "errorMsg";

    public void validate(List<Map<String, Object>> data, Long org, List<Map<String, Object>> errorData, List<Map<String, Object>> tempSuccessData, Map<Long, Map<String, Long>> talentFileMap) {
        this.checkMustInput(data, errorData, talentFileMap, tempSuccessData, org);
        this.checkFieldsUnique(errorData, tempSuccessData);
        this.checkBusinessRequire(errorData, tempSuccessData);
    }

    private void checkMustInput(List<Map<String, Object>> data, List<Map<String, Object>> errorData, Map<Long, Map<String, Long>> talentFileMap, List<Map<String, Object>> tempSuccessData, Long org) {
        for (Map<String, Object> map : data) {
            StringBuilder sb = new StringBuilder();
            Long employee = (Long)map.get("employee");
            Long recommendIntoPool = (Long)map.get("recommendintopool");
            if (ObjectUtils.isEmpty((Object)employee)) {
                sb.append(ResManager.loadKDString((String)"\u4f01\u4e1a\u4eba", (String)"RecommendApplicationService_1", (String)"tdc-talp-business", (Object[])new Object[0]));
            }
            if (ObjectUtils.isEmpty((Object)recommendIntoPool)) {
                if (sb.length() > 0) {
                    sb.append("\u3001").append(ResManager.loadKDString((String)"\u63a8\u8350\u5165\u6c60", (String)"RecommendApplicationService_2", (String)"tdc-talp-business", (Object[])new Object[0]));
                } else {
                    sb.append(ResManager.loadKDString((String)"\u63a8\u8350\u5165\u6c60", (String)"RecommendApplicationService_2", (String)"tdc-talp-business", (Object[])new Object[0]));
                }
            }
            if (sb.length() > 0) {
                map.put(ERROR_MSG, ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"RecommendApplicationService_3", (String)"tdc-talp-business", (Object[])new Object[]{sb.toString()}));
                errorData.add(map);
                continue;
            }
            Map<String, Long> talentFile = talentFileMap.get(employee);
            if (CollectionUtils.isEmpty(talentFile) || talentFile.get("id") == null || talentFile.get("id") == 0L) {
                map.put(ERROR_MSG, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u4e0d\u5b58\u5728\u751f\u6548\u7684\u4eba\u624d\u6863\u6848\u3002", (String)"RecommendApplicationService_0", (String)"tdc-talp-business", (Object[])new Object[0]));
                errorData.add(map);
                continue;
            }
            Long l = org = org == null || org == 0L ? talentFile.get("org") : org;
            if (org == null || org == 0L) {
                map.put(ERROR_MSG, ResManager.loadKDString((String)"\u62df\u5165\u6c60\u5458\u5de5\u7684\u201c\u4eba\u624d\u7ba1\u7406\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RecommendApplicationService_9", (String)"tdc-talp-business", (Object[])new Object[0]));
                errorData.add(map);
                continue;
            }
            tempSuccessData.add(map);
        }
    }

    public void checkFieldsUnique(List<Map<String, Object>> errorData, List<Map<String, Object>> tempSuccessData) {
        ArrayList<Map<String, Object>> noRepeatList = new ArrayList<Map<String, Object>>(tempSuccessData.size());
        ArrayList<Map<String, Object>> repeatList = new ArrayList<Map<String, Object>>(tempSuccessData.size());
        ArrayList<Map<String, Object>> noCheckList = new ArrayList<Map<String, Object>>(tempSuccessData.size());
        HashMap<String, List<Map<String, Object>>> group = new HashMap<String, List<Map<String, Object>>>(tempSuccessData.size());
        this.checkRepeatedInMemory(group, tempSuccessData, noRepeatList, repeatList, noCheckList);
        this.checkInDB(noRepeatList, repeatList);
        this.returnResult(errorData, tempSuccessData, repeatList, noCheckList);
    }

    private void returnResult(List<Map<String, Object>> errorData, List<Map<String, Object>> tempSuccessData, List<Map<String, Object>> repeatList, List<Map<String, Object>> noCheckList) {
        Iterator<Map<String, Object>> iterator = tempSuccessData.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> next = iterator.next();
            for (Map<String, Object> map : repeatList) {
                String key2;
                String key1 = this.buildKey((Long)map.get("employee"), (Long)map.get("recommendintopool"), (Long)map.get("recommendemp"));
                if (!StringUtils.equals((CharSequence)key1, (CharSequence)(key2 = this.buildKey((Long)next.get("employee"), (Long)next.get("recommendintopool"), (Long)next.get("recommendemp"))))) continue;
                next.put(ERROR_MSG, map.get(ERROR_MSG));
                errorData.add(next);
                iterator.remove();
            }
        }
        tempSuccessData.addAll(noCheckList);
    }

    private void checkInDB(List<Map<String, Object>> noRepeateList, List<Map<String, Object>> repeateList) {
        if (CollectionUtils.isEmpty(noRepeateList)) {
            return;
        }
        this.checkByRule(noRepeateList, repeateList);
    }

    private void checkByRule(List<Map<String, Object>> noRepeateList, List<Map<String, Object>> repeateList) {
        HashMap<String, Map<String, Object>> param = new HashMap<String, Map<String, Object>>(noRepeateList.size());
        for (Map<String, Object> map : noRepeateList) {
            String key = this.buildKey((Long)map.get("employee"), (Long)map.get("recommendintopool"), (Long)map.get("recommendemp"));
            HashMap<String, Object> value = new HashMap<String, Object>(3);
            value.put("employee", map.get("employee"));
            value.put("recommendintopool", map.get("recommendintopool"));
            value.put("recommendemp", map.get("recommendemp"));
            param.put(key, value);
        }
        ThreeTuple<Map<String, Map<String, Object>>, Map<Long, Long>, Map<Long, Long>> threeTuple = RecommendQueryHelper.buildSubmitRecommendInfo(param);
        Map item1 = (Map)threeTuple.item1;
        Map item2 = (Map)threeTuple.item2;
        Map item3 = (Map)threeTuple.item3;
        Iterator<Map<String, Object>> iterator = noRepeateList.iterator();
        while (iterator.hasNext()) {
            long id;
            Map<String, Object> map = iterator.next();
            String key = this.buildKey((Long)map.get("employee"), (Long)map.get("recommendintopool"), (Long)map.get("recommendemp"));
            Map recommendBill = (Map)item1.get(key);
            if (CollectionUtils.isEmpty((Map)recommendBill)) continue;
            String handleStatus = (String)recommendBill.get("handlestatus");
            if (HandleStatusEnum.BE_HANDLE.getStatus().equals(handleStatus)) {
                String errorMsg = ResManager.loadKDString((String)"\u60a8\u5df2\u63a8\u8350\u8fc7\u8be5\u5458\u5de5\u5230\u8be5\u4eba\u624d\u50a8\u5907\u6c60\uff0c\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4", (String)"RecommendApplicationService_13", (String)"tdc-talp-business", (Object[])new Object[0]);
                map.put(ERROR_MSG, errorMsg);
                repeateList.add(map);
                iterator.remove();
                continue;
            }
            if (!HandleStatusEnum.INITIATED_INTO_POOL.getStatus().equals(handleStatus) || Objects.isNull(item2.get(id = ((Long)recommendBill.get("id")).longValue())) && Objects.isNull(item3.get(id))) continue;
            String errorMsg = ResManager.loadKDString((String)"\u60a8\u5df2\u63a8\u8350\u8fc7\u8be5\u5458\u5de5\u5230\u8be5\u4eba\u624d\u50a8\u5907\u6c60\uff0c\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4", (String)"RecommendApplicationService_13", (String)"tdc-talp-business", (Object[])new Object[0]);
            map.put(ERROR_MSG, errorMsg);
            repeateList.add(map);
            iterator.remove();
        }
    }

    private void checkRepeatedInMemory(Map<String, List<Map<String, Object>>> group, List<Map<String, Object>> tempSuccessData, List<Map<String, Object>> noRepeateList, List<Map<String, Object>> repeateList, List<Map<String, Object>> noCheckList) {
        Iterator<Map<String, Object>> iterator = tempSuccessData.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> map = iterator.next();
            Long employee = (Long)map.get("employee");
            Long recommendIntoPool = (Long)map.get("recommendintopool");
            Long recommendEmp = (Long)map.get("recommendemp");
            if (recommendEmp == null || recommendEmp == 0L) {
                noCheckList.add(map);
                iterator.remove();
                continue;
            }
            String key = this.buildKey(employee, recommendIntoPool, recommendEmp);
            List<Map<String, Object>> groupValue = group.get(key);
            if (Objects.isNull(groupValue)) {
                groupValue = new ArrayList<Map<String, Object>>();
                group.put(key, groupValue);
            }
            groupValue.add(map);
        }
        for (Map.Entry<String, List<Map<String, Object>>> entry : group.entrySet()) {
            List<Map<String, Object>> value = entry.getValue();
            if (value.size() == 1) {
                noRepeateList.add(value.get(0));
            }
            if (value.size() <= 1) continue;
            Map<String, Object> map = value.get(0);
            map.put(ERROR_MSG, ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"RecommendApplicationService_12", (String)"tdc-talp-business", (Object[])new Object[0]));
            repeateList.add(map);
        }
    }

    private void checkBusinessRequire(List<Map<String, Object>> errorData, List<Map<String, Object>> tempSuccessData) {
        if (tempSuccessData == null || tempSuccessData.size() < 1) {
            return;
        }
        this.checkEmpOnJobStatus(errorData, tempSuccessData);
    }

    private void checkEmpOnJobStatus(List<Map<String, Object>> errorData, List<Map<String, Object>> tempSuccessData) {
        List employeeList = tempSuccessData.stream().map(e -> e.get("employee")).collect(Collectors.toList());
        Map checkEmployeeStatus = HRPI_SERVICE.checkEmployeeStatus(employeeList);
        Iterator<Map<String, Object>> iterator = tempSuccessData.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> map = iterator.next();
            Long employee = (Long)map.get("employee");
            Boolean isInCompany = checkEmployeeStatus.getOrDefault(employee, Boolean.FALSE);
            if (isInCompany.booleanValue()) continue;
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5f53\u524d\u4e3a\u975e\u5728\u804c\u72b6\u6001\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"RecommendApplicationService_14", (String)"tdc-talp-business", (Object[])new Object[0]);
            map.put(ERROR_MSG, errorMsg);
            errorData.add(map);
            iterator.remove();
        }
    }

    private String buildKey(Long employee, Long recommendIntoPool, Long recommendEmp) {
        return employee + "+" + recommendIntoPool + "+" + recommendEmp;
    }

    public Map<String, Object> buildResult(Map<String, Object> result, String status, String code, String errorMsg, List<Map<String, Object>> errorData) {
        result.put("status", status);
        result.put("code", code);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            result.put(ERROR_MSG, errorMsg);
        }
        if (errorData != null) {
            result.put("data", errorData);
        }
        return result;
    }
}

