/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.business.domain.recommend.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.tdc.talp.business.servicehelper.RecommendQueryHelper;
import kd.tdc.talp.common.constants.recommend.RecommendConstants;
import kd.tdc.talp.common.enums.recommend.HandleStatusEnum;
import kd.tdc.talp.common.enums.recommend.RecommendStatusEnum;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;

public class RecommendDomainService
implements RecommendConstants {
    private final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("talp_recommendbasebill");

    public DynamicObjectCollection updateHandleStatus(Set<Long> recommendIds, HandleStatusEnum handleStatusEnum) {
        DynamicObject[] dynamicObjects = this.queryBuIds("id,handler,handlestatus,handletime,recommendemp", recommendIds);
        long currUserId = RequestContext.get().getCurrUserId();
        Date currDate = new Date();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        for (DynamicObject item : dynamicObjects) {
            if (!HandleStatusEnum.BE_HANDLE.getStatus().equals(item.getString("handlestatus"))) continue;
            item.set("handlestatus", (Object)handleStatusEnum.getStatus());
            item.set("handletime", (Object)currDate);
            item.set("handler", (Object)currUserId);
            collection.add((Object)item);
        }
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            this.HELPER.updateDatas((DynamicObject[])collection.toArray((Object[])new DynamicObject[0]));
        }
        return collection;
    }

    private DynamicObject[] queryBuIds(String selectFields, Collection<Long> recommendIds) {
        return this.HELPER.query(selectFields, new QFilter[]{new QFilter("id", "in", recommendIds)});
    }

    public void leaveIgnoreRecommend(Long employee) {
        QFilter empFilter = new QFilter("employee", "=", (Object)employee);
        QFilter recommendStatusFilter = new QFilter("recommendstatus", "=", (Object)RecommendStatusEnum.RECOMMENDED.getStatus());
        QFilter handleStatusFilter = new QFilter("handlestatus", "=", (Object)HandleStatusEnum.BE_HANDLE.getStatus());
        QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)"B");
        Object[] dys = this.HELPER.query("handlestatus", new QFilter[]{empFilter, recommendStatusFilter, handleStatusFilter, billStatusFilter});
        if (HRArrayUtils.isNotEmpty((Object[])dys)) {
            Arrays.stream(dys).forEach(dy -> dy.set("handlestatus", (Object)HandleStatusEnum.IGNORED.getStatus()));
            this.HELPER.save((DynamicObject[])dys);
        }
    }

    public void save(DynamicObject[] dynamicObjects) {
        this.HELPER.save(dynamicObjects);
    }

    public void recommendIntoPool(List<Map<String, Object>> tempSuccessData, Long org, Map<Long, Map<String, Long>> primaryEmpInfoMap, Map<Long, Map<String, Long>> talentFileMap, Long recommendsource) {
        List<DynamicObject> saveData = this.buildSaveData(org, talentFileMap, primaryEmpInfoMap, tempSuccessData, recommendsource);
        List billNos = CodeRuleServiceHelper.getNumbers((String)"talp_talentrecommend", saveData);
        for (int i = 0; i < saveData.size(); ++i) {
            saveData.get(i).set("billno", billNos.get(i));
        }
        this.save(saveData.toArray(new DynamicObject[0]));
    }

    public List<DynamicObject> buildSaveData(Long org, Map<Long, Map<String, Long>> talentFileMap, Map<Long, Map<String, Long>> primaryEmpInfoMap, List<Map<String, Object>> tempSuccessData, Long recommendSource) {
        HashSet poolIds = Sets.newHashSetWithExpectedSize((int)tempSuccessData.size());
        for (Map<String, Object> map : tempSuccessData) {
            poolIds.add((Long)map.get("recommendintopool"));
        }
        DynamicObject[] poolDys = TalentPoolQueryHelper.queryTalentPoolInfoByIds((String)"id,createorg", (List)Lists.newArrayList((Iterable)poolIds));
        Map<Long, Long> idMapping = Arrays.stream(poolDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("createorg"), (v1, v2) -> v1));
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(tempSuccessData.size());
        for (Map<String, Object> map : tempSuccessData) {
            Map<String, Long> infoMap;
            DynamicObject dy2 = RecommendQueryHelper.generateEmptyDy();
            dy2.set("org", (Object)org);
            Long employee = (Long)map.get("employee");
            Map<String, Long> talentFile = talentFileMap.get(employee);
            if (talentFile == null) continue;
            dy2.set("talentfile", (Object)talentFile.get("id"));
            dy2.set("recommendemp", map.get("recommendemp"));
            dy2.set("employee", (Object)employee);
            if (!CollectionUtils.isEmpty(primaryEmpInfoMap) && !CollectionUtils.isEmpty(infoMap = primaryEmpInfoMap.get(employee))) {
                dy2.set("adminorg", (Object)infoMap.get("adminorg"));
                dy2.set("position", (Object)infoMap.get("position"));
                dy2.set("stdposition", (Object)infoMap.get("stdposition"));
                dy2.set("job", (Object)infoMap.get("job"));
                dy2.set("person", (Object)infoMap.get("person"));
            }
            Long value = (Long)map.get("recommendintopool");
            dy2.set("recommendintopool", (Object)value);
            dy2.set("receivingorg", (Object)idMapping.getOrDefault(value, 0L));
            dy2.set("recommendsource", (Object)recommendSource);
            dy2.set("recommendreason", map.get("recommendreason"));
            dy2.set("recommenddate", (Object)new Date());
            dy2.set("recommendstatus", (Object)RecommendStatusEnum.RECOMMENDED.getStatus());
            dy2.set("handlestatus", (Object)HandleStatusEnum.BE_HANDLE.getStatus());
            dy2.set("billstatus", (Object)"C");
            dy2.set("auditstatus", (Object)"C");
            saveData.add(dy2);
        }
        return saveData;
    }

    public void poolPermChange(List<Long> poolIds) {
        DynamicObject[] poolDys = TalentPoolQueryHelper.queryTalentPoolInfoByIds((String)"id,createorg", (List)Lists.newArrayList(poolIds));
        Map<Long, Long> poolIdOrgMapping = Arrays.stream(poolDys).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getLong("createorg"), (v1, v2) -> v1));
        Object[] recommendBills = this.HELPER.query("id,receivingorg,recommendintopool", new QFilter[]{new QFilter("recommendintopool", "in", poolIds), new QFilter("handlestatus", "=", (Object)HandleStatusEnum.BE_HANDLE.getStatus())});
        if (HRArrayUtils.isNotEmpty((Object[])recommendBills)) {
            for (Object recommendBill : recommendBills) {
                long poolCreateOrg = poolIdOrgMapping.getOrDefault(recommendBill.getLong("recommendintopool.id"), 0L);
                if (poolCreateOrg <= 0L) continue;
                recommendBill.set("receivingorg", (Object)poolCreateOrg);
            }
            this.HELPER.updateDatas((DynamicObject[])recommendBills);
        }
    }
}

