/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.business.servicehelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tdc.talp.common.enums.entryexitpool.EntryExitPoolStatusEnum;
import kd.tdc.tdcs.enums.talentpool.ApplyTypeEnum;

public class EntryExitPoolQueryHelper {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("talp_entryexitpoolbase");

    public static DynamicObject[] queryByIds(String selectFields, List<Long> ids) {
        return HELPER.queryOriginalArray(selectFields, new QFilter[]{new QFilter("id", "in", ids)});
    }

    public static DynamicObject[] loadDys(String applyType, Object[] pkArray) {
        if (ApplyTypeEnum.IN_POOL_PAGE.getStatus().equals(applyType)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("talp_entrypoolbill");
            return serviceHelper.loadDynamicObjectArray(pkArray);
        }
        if (ApplyTypeEnum.OUT_POOL_PAGE.getStatus().equals(applyType)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("talp_exitpoolbill");
            return serviceHelper.loadDynamicObjectArray(pkArray);
        }
        return null;
    }

    public static Map<String, Object> countEntryExitPoolNumber(List<Long> poolIds) {
        DynamicObject[] bills = HELPER.queryOriginalArray("businessstatus", new QFilter[]{new QFilter("talentpool", "in", poolIds)});
        Map<String, List<DynamicObject>> collect = Arrays.stream(bills).collect(Collectors.groupingBy(item -> item.getString("businessstatus")));
        HashMap resultMap = Maps.newHashMap();
        List<DynamicObject> intoPoolBill = collect.get(EntryExitPoolStatusEnum.INTO_POOL.getStatus());
        List<DynamicObject> outToPoolBill = collect.get(EntryExitPoolStatusEnum.OUT_TO_POOL.getStatus());
        resultMap.put("intoPoolBill", CollectionUtils.isEmpty(intoPoolBill) ? 0 : intoPoolBill.size());
        resultMap.put("outToPoolBill", CollectionUtils.isEmpty(outToPoolBill) ? 0 : outToPoolBill.size());
        return resultMap;
    }

    public static DynamicObject queryOriginalOneByIds(String selectField, Object focusRowPkId) {
        return HELPER.queryOriginalOne(selectField, focusRowPkId);
    }

    public static boolean isExistsEntryPoolBill(long pkId, Long talentPoolId, Long employeeId) {
        return HELPER.isExists(new QFilter[]{new QFilter("employee", "=", (Object)employeeId), new QFilter("talentpool", "=", (Object)talentPoolId), new QFilter("id", "!=", (Object)pkId), new QFilter("businessstatus", "=", (Object)EntryExitPoolStatusEnum.INTO_POOL.getStatus())});
    }

    public static boolean isExistsExitPoolBill(long pkId, Long talentPoolId, Long employeeId) {
        return HELPER.isExists(new QFilter[]{new QFilter("employee", "=", (Object)employeeId), new QFilter("talentpool", "=", (Object)talentPoolId), new QFilter("id", "!=", (Object)pkId), new QFilter("businessstatus", "=", (Object)EntryExitPoolStatusEnum.OUT_TO_POOL.getStatus())});
    }

    public static DynamicObject[] queryBeIntoPoolBillByRecommendIds(String selectFields, Set<Long> inPoolRecommendIds) {
        return HELPER.queryOriginalArray(selectFields, new QFilter[]{new QFilter("entryentity.recommendid", "in", inPoolRecommendIds), new QFilter("businessstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{EntryExitPoolStatusEnum.BE_SUBMIT_INTO_POOL.getStatus(), EntryExitPoolStatusEnum.INTO_POOL.getStatus()}))});
    }

    public static boolean hasNewEntryPoolPerm() {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"3=0WAUGB+EOW", (String)"talp_entrypoolbill", (String)"47156aff000000ac");
    }
}

