/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.business.servicehelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.tdc.talp.business.servicehelper.EntryExitPoolQueryHelper;
import kd.tdc.talp.common.enums.recommend.HandleStatusEnum;
import kd.tdc.talp.common.enums.recommend.RecommendStatusEnum;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;
import org.apache.commons.lang3.StringUtils;

public class RecommendQueryHelper {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("talp_recommendbasebill");

    public static DynamicObject[] queryOriginalBeRecommendedByIds(String selectFields, List<Long> ids) {
        return HELPER.queryOriginalArray(selectFields, new QFilter[]{new QFilter("id", "in", ids)});
    }

    public static int countPendingRecommends(List<Long> poolIds) {
        QFilter recommendedQFilter = new QFilter("recommendstatus", "=", (Object)RecommendStatusEnum.RECOMMENDED.getStatus());
        QFilter beHandleQFilter = new QFilter("handlestatus", "=", (Object)HandleStatusEnum.BE_HANDLE.getStatus());
        return HELPER.count("talp_recommendbasebill", new QFilter[]{new QFilter("recommendintopool", "in", poolIds), recommendedQFilter, beHandleQFilter});
    }

    public static ThreeTuple<Map<String, Map<String, Object>>, Map<Long, Long>, Map<Long, Long>> buildSubmitRecommendInfo(Map<String, Map<String, Object>> data) {
        HashMap item1 = Maps.newHashMap();
        HashMap item2 = Maps.newHashMap();
        HashMap item3 = Maps.newHashMap();
        if (CollectionUtils.isEmpty(data)) {
            return new ThreeTuple((Object)item1, (Object)item2, (Object)item3);
        }
        ArrayList empIds = Lists.newArrayListWithCapacity((int)data.size());
        ArrayList poolIds = Lists.newArrayListWithCapacity((int)data.size());
        ArrayList recommendEmpIds = Lists.newArrayListWithCapacity((int)data.size());
        Collection<Map<String, Object>> values = data.values();
        values.forEach(recommendInfo -> {
            empIds.add((Long)recommendInfo.get("employee"));
            poolIds.add((Long)recommendInfo.get("recommendintopool"));
            Object recommendEmpId = recommendInfo.get("recommendemp");
            if (!Objects.isNull(recommendEmpId)) {
                recommendEmpIds.add((Long)recommendEmpId);
            }
        });
        ArrayList filters = Lists.newArrayList();
        filters.add(new QFilter("employee", "in", (Object)empIds));
        filters.add(new QFilter("recommendintopool", "in", (Object)poolIds));
        if (!CollectionUtils.isEmpty((Collection)recommendEmpIds)) {
            filters.add(new QFilter("recommendemp", "in", (Object)recommendEmpIds));
        }
        filters.add(new QFilter("recommendstatus", "=", (Object)RecommendStatusEnum.RECOMMENDED.getStatus()));
        Object[] recommendBills = HELPER.queryOriginalArray("id,handlestatus,employee,recommendintopool,recommendemp,recommenddate", filters.toArray(new QFilter[0]));
        if (HRArrayUtils.isEmpty((Object[])recommendBills)) {
            return new ThreeTuple((Object)item1, (Object)item2, (Object)item3);
        }
        HashSet inPoolRecommendIds = Sets.newHashSet();
        for (Object recommendBill : recommendBills) {
            Map<String, Object> objectMap;
            long recommendEmpId = recommendBill.getLong("recommendemp");
            String mapKey = recommendBill.getLong("employee") + "+" + recommendBill.getLong("recommendintopool");
            if (recommendEmpId != 0L) {
                mapKey = mapKey + "+" + recommendEmpId;
            }
            if (CollectionUtils.isEmpty(objectMap = data.get(mapKey))) continue;
            Map recommendInfoMap = (Map)item1.get(mapKey);
            HashMap map = Maps.newHashMap();
            long recommendId = recommendBill.getLong("id");
            map.put("id", recommendId);
            map.put("handlestatus", recommendBill.getString("handlestatus"));
            map.put("recommenddate", recommendBill.getDate("recommenddate"));
            if (CollectionUtils.isEmpty((Map)recommendInfoMap)) {
                item1.put(mapKey, map);
                if (!HandleStatusEnum.INITIATED_INTO_POOL.getStatus().equals(recommendBill.getString("handlestatus"))) continue;
                inPoolRecommendIds.add(recommendId);
                continue;
            }
            Date recommendDate = (Date)recommendInfoMap.get("recommenddate");
            if (recommendDate.compareTo(recommendBill.getDate("recommenddate")) >= 0) continue;
            inPoolRecommendIds.remove((Long)recommendInfoMap.get("id"));
            item1.put(mapKey, map);
            if (!HandleStatusEnum.INITIATED_INTO_POOL.getStatus().equals(recommendBill.getString("handlestatus"))) continue;
            inPoolRecommendIds.add(recommendId);
        }
        DynamicObject[] beIntoPoolBills = EntryExitPoolQueryHelper.queryBeIntoPoolBillByRecommendIds("id,businessstatus,entryentity.recommendid", inPoolRecommendIds);
        Map<Long, Long> beIntoPoolBillMap = Arrays.stream(beIntoPoolBills).collect(Collectors.toMap(item -> item.getLong("entryentity.recommendid"), item -> item.getLong("id"), (v1, v2) -> v1));
        DynamicObject[] inPoolReserveTalent = TalentPoolQueryHelper.queryInPoolReserveTalentByRecommendIds((String)"id,inpoolstatus,entryentity.recommendid", (Set)inPoolRecommendIds);
        Map<Long, Long> inPoolReserveTalentMap = Arrays.stream(inPoolReserveTalent).collect(Collectors.toMap(item -> item.getLong("entryentity.recommendid"), item -> item.getLong("id"), (v1, v2) -> v1));
        return new ThreeTuple((Object)item1, beIntoPoolBillMap, inPoolReserveTalentMap);
    }

    public static Map<Long, Map<String, Object>> queryRecommendInfoByIds(String selectField, List<Long> recommendIds) {
        DynamicObject[] dys = HELPER.queryOriginalArray(selectField, new QFilter[]{new QFilter("id", "in", recommendIds)});
        HashMap recommendInfo = Maps.newHashMapWithExpectedSize((int)dys.length);
        String[] split = StringUtils.split((String)selectField, (String)",");
        for (DynamicObject dy : dys) {
            HashMap dyMap = Maps.newHashMapWithExpectedSize((int)split.length);
            for (String fieldName : split) {
                dyMap.put(fieldName, dy.get(fieldName));
            }
            recommendInfo.put(dy.getLong("id"), dyMap);
        }
        return recommendInfo;
    }

    public static boolean hasNewRecommendPerm() {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"3=0WAUGB+EOW", (String)"talp_talentrecommend", (String)"47156aff000000ac");
    }

    public static DynamicObject[] queryReceivingOrgIsZero() {
        return HELPER.query("id,receivingorg,recommendintopool", new QFilter[]{new QFilter("receivingorg", "=", (Object)0L)});
    }

    public static DynamicObject generateEmptyDy() {
        return HELPER.generateEmptyDynamicObject();
    }
}

