/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.opplugin.validator.entryexitpool;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.talp.business.servicehelper.EntryExitPoolQueryHelper;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;
import kd.tdc.tdcs.enums.talentpool.ApplyTypeEnum;

public class SubmitOpValidator
extends HRDataBaseValidator {
    private static final HrpiService HRPI_SERVICE = (HrpiService)ServiceFactory.getServiceNoNeedRegister(HrpiService.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dy = dataEntity.getDataEntity();
            Object empId = dy.get("employee_id");
            Map checkEmployeeStatus = HRPI_SERVICE.checkEmployeeStatus((List)Lists.newArrayList((Object[])new Object[]{empId}));
            Boolean isInCompany = checkEmployeeStatus.getOrDefault(empId, Boolean.FALSE);
            if (!isInCompany.booleanValue()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5f53\u524d\u4e3a\u975e\u5728\u804c\u72b6\u6001\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"SubmitOpValidator_06", (String)"tdc-talp-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                continue;
            }
            long talentPoolId = dy.getLong("talentpool_id");
            long employeeId = dy.getLong("employee_id");
            String applyType = dy.getString("applytype");
            if (ApplyTypeEnum.IN_POOL_PAGE.getStatus().equals(applyType)) {
                boolean isExistsEntryPoolBill = EntryExitPoolQueryHelper.isExistsEntryPoolBill((long)dy.getLong("id"), (Long)talentPoolId, (Long)employeeId);
                if (isExistsEntryPoolBill) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5165\u6c60\u6d41\u7a0b\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77\u3002", (String)"SubmitOpValidator_01", (String)"tdc-talp-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                    continue;
                }
                boolean isExistsInPoolReserveTalent = TalentPoolQueryHelper.isExistsInPoolReserveTalent((long)talentPoolId, (long)employeeId);
                if (isExistsInPoolReserveTalent) {
                    String perName = dy.getString("person.name");
                    String talentPoolName = dy.getString("talentpool.name");
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"{0}\u5df2\u5728{1}\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77", (String)"SubmitOpValidator_02", (String)"tdc-talp-opplugin", (Object[])new Object[]{perName, talentPoolName}), ErrorLevel.FatalError);
                    continue;
                }
                boolean poolIsFull = TalentPoolQueryHelper.poolIsFull((long)dy.getLong("talentpool_id"));
                if (!poolIsFull) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u50a8\u5907\u6c60\u4eba\u6570\u9650\u5236\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5165\u6c60\u7533\u8bf7\u3002", (String)"SubmitOpValidator_03", (String)"tdc-talp-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                continue;
            }
            long reserveTalent = dy.getLong("reservetalent.id");
            boolean isExistsExitPoolBill = EntryExitPoolQueryHelper.isExistsExitPoolBill((long)dy.getLong("id"), (Long)talentPoolId, (Long)employeeId);
            if (isExistsExitPoolBill) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u62df\u51fa\u6c60\u5458\u5de5\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4eba\u624d\u51fa\u6c60\u7533\u8bf7\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u5c1d\u8bd5\u3002", (String)"SubmitOpValidator_04", (String)"tdc-talp-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                continue;
            }
            boolean reserveTalentIsOutPool = TalentPoolQueryHelper.reserveTalentIsOutPool((long)reserveTalent);
            if (!reserveTalentIsOutPool) continue;
            String perName = dy.getString("person.name");
            String talentPoolName = dy.getString("talentpool.name");
            this.addMessage(dataEntity, ResManager.loadKDString((String)"{0}\u5728{1}\u662f\u5df2\u51fa\u6c60\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77\u3002", (String)"SubmitOpValidator_05", (String)"tdc-talp-opplugin", (Object[])new Object[]{perName, talentPoolName}), ErrorLevel.FatalError);
        }
    }
}

