/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.opplugin.validator.recommend;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.talp.business.servicehelper.RecommendQueryHelper;
import kd.tdc.talp.common.enums.recommend.HandleStatusEnum;

public class PendingRecommendValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List pkIds = Arrays.stream(dataEntities).map(item -> item.getDataEntity().getLong("id")).collect(Collectors.toList());
        DynamicObject[] bills = RecommendQueryHelper.queryOriginalBeRecommendedByIds((String)"id,handlestatus", pkIds);
        Map<Long, String> handleStatusMapping = Arrays.stream(bills).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getString("handlestatus"), (v1, v2) -> v1));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            String status = handleStatusMapping.get(dy.getLong("id"));
            String handleStatus = dy.getString("handlestatus");
            if (HandleStatusEnum.BE_HANDLE.getStatus().equals(status) && HRStringUtils.equals((String)status, (String)handleStatus)) continue;
            if ("new_entry".equals(operateKey) || "batch_entry".equals(operateKey)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u5904\u7406\u72b6\u6001\u53d1\u751f\u53d8\u66f4\uff0c\u6216\u5df2\u5728\u76ee\u6807\u50a8\u5907\u6c60\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PendingRecommendValidator_0", (String)"tdc-talp-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
            if (!"ignore".equals(operateKey) && !"batch_ignore".equals(operateKey)) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u5904\u7406\u72b6\u6001\u53d1\u751f\u53d8\u66f4\uff0c\u6216\u5df2\u88ab\u5ffd\u7565\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PendingRecommendValidator_1", (String)"tdc-talp-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
    }
}

