/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.opplugin.validator.recommend;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.talp.business.servicehelper.RecommendQueryHelper;
import kd.tdc.talp.common.enums.recommend.HandleStatusEnum;
import kd.tdc.talp.common.enums.recommend.RecommendStatusEnum;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;

public class SubmitRecommendValidator
extends HRDataBaseValidator {
    private static final HrpiService HRPI_SERVICE = (HrpiService)ServiceFactory.getServiceNoNeedRegister(HrpiService.class);

    public void validate() {
        super.validate();
        List pkIds = Arrays.stream(this.dataEntities).map(item -> item.getDataEntity().getLong("id")).collect(Collectors.toList());
        DynamicObject[] bills = RecommendQueryHelper.queryOriginalBeRecommendedByIds((String)"id,recommendstatus", pkIds);
        Map<Long, String> idStatusMapping = Arrays.stream(bills).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getString("recommendstatus"), (v1, v2) -> v1));
        List empIds = Arrays.stream(this.dataEntities).map(item -> item.getDataEntity().get("employee_id")).collect(Collectors.toList());
        Map checkEmployeeStatus = HRPI_SERVICE.checkEmployeeStatus((List)Lists.newArrayList(empIds));
        ArrayList otherCheckData = Lists.newArrayList();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            long id = dy.getLong("id");
            String status = idStatusMapping.get(id);
            if (!Objects.isNull(status) && !RecommendStatusEnum.BE_RECOMMEND.getStatus().equals(status)) continue;
            Object empId = dy.get("employee_id");
            if (Objects.isNull(empId) || Long.parseLong(empId.toString()) == 0L) {
                String errMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u62df\u5165\u6c60\u5458\u5de5\u201d\u3002", (String)"SubmitRecommendValidator_01", (String)"tdc-talp-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errMsg, ErrorLevel.Error);
                continue;
            }
            Boolean isInCompany = checkEmployeeStatus.getOrDefault(empId, Boolean.FALSE);
            if (!isInCompany.booleanValue()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5f53\u524d\u4e3a\u975e\u5728\u804c\u72b6\u6001\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"SubmitRecommendValidator_02", (String)"tdc-talp-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                continue;
            }
            DynamicObject empDy = dy.getDynamicObject("employee");
            DynamicObject recommendIntoPoolDy = dy.getDynamicObject("recommendintopool");
            if (Objects.isNull(empDy) || Objects.isNull(recommendIntoPoolDy)) continue;
            otherCheckData.add(dataEntity);
        }
        HashMap dateMap = Maps.newHashMap();
        Map<String, List<ExtendedDataEntity>> groupByOnlyKey = otherCheckData.stream().collect(Collectors.groupingBy(item -> {
            DynamicObject dy = item.getDataEntity();
            String currStatus = dy.getString("recommendstatus");
            if (RecommendStatusEnum.BE_RECOMMEND.getStatus().equals(currStatus)) {
                return this.buildOnlyKey(dateMap, dy);
            }
            return "";
        }));
        String repeatErrMsg = ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"SubmitRecommendValidator_03", (String)"tdc-talp-opplugin", (Object[])new Object[0]);
        groupByOnlyKey.forEach((onlyKey, dyList) -> {
            if (HRStringUtils.isNotEmpty((String)onlyKey) && dyList.size() > 1) {
                dyList.forEach(item -> this.addMessage((ExtendedDataEntity)item, repeatErrMsg, ErrorLevel.FatalError));
            }
        });
        if (!CollectionUtils.isEmpty((Map)dateMap)) {
            ThreeTuple threeTuple = RecommendQueryHelper.buildSubmitRecommendInfo((Map)dateMap);
            Map item1 = (Map)threeTuple.item1;
            Map item2 = (Map)threeTuple.item2;
            Map item3 = (Map)threeTuple.item3;
            for (ExtendedDataEntity dataEntity : otherCheckData) {
                long id;
                Map recommendInfo;
                DynamicObject dy = dataEntity.getDataEntity();
                String mapKey = this.buildOnlyKey(dateMap, dy);
                if (HRStringUtils.isEmpty((String)mapKey) || CollectionUtils.isEmpty((Map)(recommendInfo = (Map)item1.get(mapKey)))) continue;
                String handleStatus = (String)recommendInfo.get("handlestatus");
                if (HandleStatusEnum.BE_HANDLE.getStatus().equals(handleStatus)) {
                    String errMsg = ResManager.loadKDString((String)"\u60a8\u5df2\u63a8\u8350\u8fc7\u8be5\u5458\u5de5\u5230\u8be5\u4eba\u624d\u50a8\u5907\u6c60\uff0c\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002", (String)"SubmitRecommendValidator_04", (String)"tdc-talp-opplugin", (Object[])new Object[0]);
                    this.addMessage(dataEntity, errMsg, ErrorLevel.FatalError);
                    continue;
                }
                if (!HandleStatusEnum.INITIATED_INTO_POOL.getStatus().equals(handleStatus) || Objects.isNull(item2.get(id = ((Long)recommendInfo.get("id")).longValue())) && Objects.isNull(item3.get(id))) continue;
                String errMsg = ResManager.loadKDString((String)"\u60a8\u5df2\u63a8\u8350\u8fc7\u8be5\u5458\u5de5\u5230\u8be5\u4eba\u624d\u50a8\u5907\u6c60\uff0c\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002", (String)"SubmitRecommendValidator_04", (String)"tdc-talp-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errMsg, ErrorLevel.FatalError);
            }
        }
    }

    private String buildOnlyKey(Map<String, Map<String, Object>> dateMap, DynamicObject dy) {
        DynamicObject empDy = dy.getDynamicObject("employee");
        DynamicObject recommendIntoPoolDy = dy.getDynamicObject("recommendintopool");
        if (Objects.isNull(empDy) || Objects.isNull(recommendIntoPoolDy)) {
            return "";
        }
        long empId = empDy.getLong("id");
        long poolId = recommendIntoPoolDy.getLong("id");
        DynamicObject recommendEmpDy = dy.getDynamicObject("recommendemp");
        long recommendEmpId = Objects.isNull(recommendEmpDy) ? 0L : (Long)recommendEmpDy.getPkValue();
        String mapKey = empId + "+" + poolId + "+" + recommendEmpId;
        HashMap maps = Maps.newHashMap();
        maps.put("employee", empId);
        maps.put("recommendintopool", poolId);
        maps.put("recommendemp", recommendEmpId);
        if (Objects.isNull(dateMap.get(mapKey))) {
            dateMap.put(mapKey, maps);
        }
        return mapKey;
    }
}

