/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.opplugin.web.entryexitpool;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.talp.business.application.service.EntryExitPoolApplicationService;
import kd.tdc.talp.common.constants.entryexitpool.EntryExitPoolConstant;
import kd.tdc.talp.common.enums.entryexitpool.EntryExitPoolStatusEnum;
import kd.tdc.talp.opplugin.validator.entryexitpool.EntryExitPoolCommonValidator;
import kd.tdc.talp.opplugin.validator.entryexitpool.SubmitOpValidator;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.TalentPoolApplicationService;
import kd.tdc.tdcs.enums.talentpool.ApplyTypeEnum;

public class AuditCompletedOp
extends HRDataBaseOp
implements EntryExitPoolConstant {
    private static final TalentPoolApplicationService TALENT_POOL_BOUND_SERVICE = (TalentPoolApplicationService)ServiceFactory.getServiceNoNeedRegister(TalentPoolApplicationService.class);
    private static final EntryExitPoolApplicationService ENTRY_EXIT_POOL_APPLICATION_SERVICE = (EntryExitPoolApplicationService)kd.tdc.talp.business.ServiceFactory.getService(EntryExitPoolApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        Collections.addAll(fieldKeys, "businessstatus", "intopooldate", "org", "outofpooldate", "outofpooltype", "outofpoolreason", "applytype", "person", "employee", "talentpool", "talentfile", "reservetalent", "billstatus", "org", "adminorg", "position", "stdposition", "job", "intopooltype", "intopoolreason", "billno", "targetcompetency", "currmatchdegree", "supervisor", "entryentity", "entryentity.recommendid", "entryentity.recommendsource", "entryentity.recommendintopool", "entryentity.recommendemp", "entryentity.recommenddate", "entryentity.recommendreason");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new EntryExitPoolCommonValidator());
        args.addValidator((AbstractValidator)new SubmitOpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        Date currDate = new Date();
        Arrays.stream(dataEntities).forEach(bill -> {
            if ("C".equals(bill.getString("billstatus"))) {
                Date outOfPoolDate;
                Date intoPoolDate;
                String applyType = bill.getString("applytype");
                if (ApplyTypeEnum.IN_POOL_PAGE.getStatus().equals(applyType) && (intoPoolDate = bill.getDate("intopooldate")).compareTo(currDate) <= 0) {
                    bill.set("businessstatus", (Object)EntryExitPoolStatusEnum.IN_POOL.getStatus());
                }
                if (ApplyTypeEnum.OUT_POOL_PAGE.getStatus().equals(applyType) && (outOfPoolDate = bill.getDate("outofpooldate")).compareTo(currDate) <= 0) {
                    bill.set("businessstatus", (Object)EntryExitPoolStatusEnum.OUT_POOL.getStatus());
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        Arrays.stream(dataEntities).forEach(bill -> {
            String businessStatus = bill.getString("businessstatus");
            if (EntryExitPoolStatusEnum.IN_POOL.getStatus().equals(businessStatus)) {
                TALENT_POOL_BOUND_SERVICE.checkAndAddInPoolNum(bill.getLong("talentpool_id"));
                TALENT_POOL_BOUND_SERVICE.generateReserveTalentColl(new DynamicObject[]{bill});
            }
            if (EntryExitPoolStatusEnum.OUT_POOL.getStatus().equals(businessStatus)) {
                TALENT_POOL_BOUND_SERVICE.checkAndSubtractInPoolNum(bill.getLong("talentpool_id"));
                TALENT_POOL_BOUND_SERVICE.updateReserveTalentColl(new DynamicObject[]{bill});
            }
        });
        ENTRY_EXIT_POOL_APPLICATION_SERVICE.updateEntryExitPoolBills(dataEntities);
    }
}

