/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.opplugin.web.entryexitpool;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.talp.business.application.service.EntryExitPoolApplicationService;
import kd.tdc.talp.business.application.service.RecommendApplicationService;
import kd.tdc.talp.common.constants.entryexitpool.EntryExitPoolConstant;
import kd.tdc.talp.common.enums.entryexitpool.EntryExitPoolStatusEnum;
import kd.tdc.talp.common.enums.recommend.HandleStatusEnum;
import kd.tdc.talp.opplugin.validator.entryexitpool.EntryExitPoolCommonValidator;
import kd.tdc.talp.opplugin.validator.entryexitpool.SubmitOpValidator;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.TalentPoolApplicationService;
import kd.tdc.tdcs.enums.talentpool.ApplyTypeEnum;

public class SubmitEffectOp
extends HRDataBaseOp
implements EntryExitPoolConstant {
    private static final TalentPoolApplicationService TALENT_POOL_BOUND_SERVICE = (TalentPoolApplicationService)ServiceFactory.getServiceNoNeedRegister(TalentPoolApplicationService.class);
    private static final EntryExitPoolApplicationService ENTRY_EXIT_POOL_APPLICATION_SERVICE = (EntryExitPoolApplicationService)kd.tdc.talp.business.ServiceFactory.getService(EntryExitPoolApplicationService.class);
    private static final RecommendApplicationService RECOMMEND_APPLICATION_SERVICE = (RecommendApplicationService)kd.tdc.talp.business.ServiceFactory.getService(RecommendApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        Collections.addAll(fieldKeys, "businessstatus", "intopooldate", "org", "outofpooldate", "outofpooltype", "outofpoolreason", "applytype", "person", "employee", "talentpool", "talentfile", "reservetalent", "billstatus", "org", "adminorg", "position", "stdposition", "job", "intopooltype", "intopoolreason", "billno", "targetcompetency", "currmatchdegree", "supervisor", "entryentity", "entryentity.recommendid", "entryentity.recommendsource", "entryentity.recommendintopool", "entryentity.recommendemp", "entryentity.recommenddate", "entryentity.recommendreason");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new EntryExitPoolCommonValidator());
        args.addValidator((AbstractValidator)new SubmitOpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        long currUserId = RequestContext.get().getCurrUserId();
        Date currDate = new Date();
        Arrays.stream(dataEntities).forEach(bill -> {
            bill.set("submitter", (Object)currUserId);
            bill.set("submittime", (Object)currDate);
            String applyType = bill.getString("applytype");
            bill.set("billstatus", (Object)"C");
            if (ApplyTypeEnum.IN_POOL_PAGE.getStatus().equals(applyType)) {
                Date intoPoolDate = bill.getDate("intopooldate");
                if (intoPoolDate.compareTo(currDate) <= 0) {
                    bill.set("businessstatus", (Object)EntryExitPoolStatusEnum.IN_POOL.getStatus());
                } else {
                    bill.set("businessstatus", (Object)EntryExitPoolStatusEnum.INTO_POOL.getStatus());
                }
            }
            if (ApplyTypeEnum.OUT_POOL_PAGE.getStatus().equals(applyType)) {
                Date outOfPoolDate = bill.getDate("outofpooldate");
                if (outOfPoolDate.compareTo(currDate) <= 0) {
                    bill.set("businessstatus", (Object)EntryExitPoolStatusEnum.OUT_POOL.getStatus());
                } else {
                    bill.set("businessstatus", (Object)EntryExitPoolStatusEnum.OUT_TO_POOL.getStatus());
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        HashSet recommendIds = Sets.newHashSet();
        Arrays.stream(dataEntities).forEach(bill -> {
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
                entryEntity.forEach(item -> recommendIds.add(item.getLong("recommendid")));
            }
            String businessStatus = bill.getString("businessstatus");
            if (EntryExitPoolStatusEnum.IN_POOL.getStatus().equals(businessStatus)) {
                TALENT_POOL_BOUND_SERVICE.checkAndAddInPoolNum(bill.getLong("talentpool_id"));
                TALENT_POOL_BOUND_SERVICE.generateReserveTalentColl(new DynamicObject[]{bill});
            }
            if (EntryExitPoolStatusEnum.OUT_POOL.getStatus().equals(businessStatus)) {
                TALENT_POOL_BOUND_SERVICE.checkAndSubtractInPoolNum(bill.getLong("talentpool_id"));
                TALENT_POOL_BOUND_SERVICE.updateReserveTalentColl(new DynamicObject[]{bill});
            }
        });
        if (!CollectionUtils.isEmpty((Collection)recommendIds)) {
            RECOMMEND_APPLICATION_SERVICE.updateHandleStatus((Set)recommendIds, HandleStatusEnum.INITIATED_INTO_POOL);
        }
    }
}

