/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.opplugin.web.entryexitpool;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.talp.business.ServiceFactory;
import kd.tdc.talp.business.application.service.RecommendApplicationService;
import kd.tdc.talp.common.enums.entryexitpool.EntryExitPoolStatusEnum;
import kd.tdc.talp.common.enums.recommend.HandleStatusEnum;
import kd.tdc.talp.opplugin.validator.entryexitpool.EntryExitPoolCommonValidator;
import kd.tdc.talp.opplugin.validator.entryexitpool.SubmitOpValidator;
import kd.tdc.tdcs.enums.talentpool.ApplyTypeEnum;

public class SubmitOp
extends HRDataBaseOp {
    private static final RecommendApplicationService RECOMMEND_APPLICATION_SERVICE = (RecommendApplicationService)ServiceFactory.getService(RecommendApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        Collections.addAll(fieldKeys, "businessstatus", "intopooldate", "org", "outofpooldate", "applytype", "person", "employee", "talentpool", "talentfile", "reservetalent", "submitter", "submittime");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new EntryExitPoolCommonValidator());
        args.addValidator((AbstractValidator)new SubmitOpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        long currUserId = RequestContext.get().getCurrUserId();
        Date currDate = new Date();
        Arrays.stream(dataEntities).forEach(bill -> {
            bill.set("submitter", (Object)currUserId);
            bill.set("submittime", (Object)currDate);
            String applyType = bill.getString("applytype");
            if (ApplyTypeEnum.IN_POOL_PAGE.getStatus().equals(applyType)) {
                bill.set("businessstatus", (Object)EntryExitPoolStatusEnum.INTO_POOL.getStatus());
            }
            if (ApplyTypeEnum.OUT_POOL_PAGE.getStatus().equals(applyType)) {
                bill.set("businessstatus", (Object)EntryExitPoolStatusEnum.OUT_TO_POOL.getStatus());
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        HashSet recommendIds = Sets.newHashSet();
        Arrays.stream(dataEntities).forEach(bill -> {
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
                entryEntity.forEach(item -> recommendIds.add(item.getLong("recommendid")));
            }
        });
        if (!CollectionUtils.isEmpty((Collection)recommendIds)) {
            RECOMMEND_APPLICATION_SERVICE.updateHandleStatus((Set)recommendIds, HandleStatusEnum.INITIATED_INTO_POOL);
        }
    }
}

