/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.opplugin.web.entryexitpool;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.talp.business.ServiceFactory;
import kd.tdc.talp.business.application.service.EntryExitPoolApplicationService;
import kd.tdc.talp.common.enums.entryexitpool.EntryExitPoolStatusEnum;
import kd.tdc.talp.opplugin.validator.entryexitpool.EntryExitPoolCommonValidator;
import kd.tdc.talp.opplugin.validator.entryexitpool.TerminateOpValidator;

public class TerminationOp
extends HRDataBaseOp {
    private static final EntryExitPoolApplicationService ENTRY_EXIT_POOL_SERVICE = (EntryExitPoolApplicationService)ServiceFactory.getService(EntryExitPoolApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        Collections.addAll(fieldKeys, "businessstatus", "intopooldate", "org", "outofpooldate", "applytype", "person", "employee", "terminationidea", "terminater", "terminatedate", "billstatus", "talentpool", "talentfile");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new EntryExitPoolCommonValidator());
        args.addValidator((AbstractValidator)new TerminateOpValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        OperateOption option = this.getOption();
        String isOpCancel = option.getVariableValue("isopcancel", null);
        String operationKey = args.getOperationKey();
        if ("terminate".equals(operationKey) && HRStringUtils.equals((String)isOpCancel, (String)"1")) {
            args.setCancel(true);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        String terminationReason = this.getOption().getVariableValue("terminationidea", " ");
        String isOpTerminate = this.getOption().getVariableValue("terminate", "false");
        long currUserId = RequestContext.get().getCurrUserId();
        Date currDate = new Date();
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("businessstatus", (Object)EntryExitPoolStatusEnum.TERMINATED.getStatus());
            dataEntity.set("terminater", (Object)currUserId);
            dataEntity.set("terminatedate", (Object)currDate);
            if ("true".equals(isOpTerminate)) {
                dataEntity.set("billstatus", (Object)"F");
                dataEntity.set("terminationidea", (Object)terminationReason);
                continue;
            }
            dataEntity.set("billstatus", (Object)"E");
            dataEntity.set("terminationidea", (Object)ResManager.loadKDString((String)"\u5ba1\u6279\u4e0d\u540c\u610f\u5e76\u7ec8\u6b62\u3002", (String)"TerminationOp_0", (String)"tdc-talp-opplugin", (Object[])new Object[0]));
        }
        ENTRY_EXIT_POOL_SERVICE.updateEntryExitPoolBills(dataEntities);
    }
}

