/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.opplugin.web.entryexitpool;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.talp.common.enums.entryexitpool.EntryExitPoolStatusEnum;
import kd.tdc.talp.opplugin.validator.entryexitpool.EntryExitPoolCommonValidator;
import kd.tdc.tdcs.enums.talentpool.ApplyTypeEnum;

public class UnSubmitOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        Collections.addAll(fieldKeys, "businessstatus", "intopooldate", "org", "outofpooldate", "applytype", "person", "employee", "talentpool", "talentfile", "reservetalent");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new EntryExitPoolCommonValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        Arrays.stream(dataEntities).forEach(bill -> {
            String applyType = bill.getString("applytype");
            if (ApplyTypeEnum.IN_POOL_PAGE.getStatus().equals(applyType)) {
                bill.set("businessstatus", (Object)EntryExitPoolStatusEnum.BE_SUBMIT_INTO_POOL.getStatus());
            }
            if (ApplyTypeEnum.OUT_POOL_PAGE.getStatus().equals(applyType)) {
                bill.set("businessstatus", (Object)EntryExitPoolStatusEnum.BE_SUBMIT_OUT_TO_POOL.getStatus());
            }
        });
    }
}

