/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.opplugin.web.recommend;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.talp.common.enums.recommend.HandleStatusEnum;
import kd.tdc.talp.opplugin.validator.recommend.PendingRecommendValidator;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.MessageService;

public class PendingRecommendOp
extends HRDataBaseOp {
    private static final MessageService MESSAGE_SERVICE = (MessageService)ServiceFactory.getServiceNoNeedRegister(MessageService.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        Collections.addAll(fieldKeys, "handlestatus", "talentfile", "recommendemp", "handler", "handletime", "recommendintopool");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new PendingRecommendValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        OperateOption option = this.getOption();
        String isOpCancel = option.getVariableValue("isopcancel", null);
        String operationKey = args.getOperationKey();
        if (("batch_ignore".equals(operationKey) || "batch_entry".equals(operationKey)) && HRStringUtils.equals((String)isOpCancel, (String)"1")) {
            args.setCancel(true);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        long currUserId = RequestContext.get().getCurrUserId();
        Date currDate = new Date();
        if ("ignore".equals(operationKey) || "batch_ignore".equals(operationKey)) {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("handlestatus", (Object)HandleStatusEnum.IGNORED.getStatus());
                dataEntity.set("handler", (Object)currUserId);
                dataEntity.set("handletime", (Object)currDate);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        String operationKey = args.getOperationKey();
        if ("ignore".equals(operationKey) || "batch_ignore".equals(operationKey)) {
            DynamicObject[] dataEntities;
            for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
                long id = dataEntity.getLong("id");
                DynamicObject recommendEmp = dataEntity.getDynamicObject("recommendemp");
                if (Objects.isNull(recommendEmp)) continue;
                long recommendEmpId = recommendEmp.getLong("id");
                MESSAGE_SERVICE.sendTemplateMessageNoBtn(Long.valueOf(id), Long.valueOf(recommendEmpId), "talp_talentrecommend", "talp_ignorerecommend");
            }
        }
    }
}

