/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.formservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.orm.util.CollectionUtils;

public class AppWorkbenchService {
    public static void customLegendStyle(PieChart pieChart, Map<String, Integer> dataMap) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Integer> entry : dataMap.entrySet()) {
            String name = entry.getKey();
            Integer value = entry.getValue();
            stringBuilder.append(String.format("{name:'%s',value:%d},", name, value));
        }
        String dataStr = "";
        if (stringBuilder.length() > 0) {
            dataStr = stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        pieChart.setShowLegend(false);
        pieChart.setLegendVertical(false);
        pieChart.setLegendPropValue("type", (Object)"scroll");
        pieChart.setLegendPropValue("align", (Object)"left");
        pieChart.setLegendPropValue("icon", (Object)"circle");
        pieChart.setLegendAlign(XAlign.right, YAlign.bottom);
        HashMap legendTextStyle = Maps.newHashMap();
        HashMap legendRichMap = Maps.newHashMap();
        HashMap numRichMap = Maps.newHashMap();
        numRichMap.put("fontSize", 12);
        numRichMap.put("fontWeight", 500);
        numRichMap.put("color", "#212121");
        numRichMap.put("fontFamily", "PingFangSC-Medium");
        legendRichMap.put("numrich", numRichMap);
        HashMap textRichMap = Maps.newHashMap();
        textRichMap.put("color", "#666666");
        textRichMap.put("fontWeight", 400);
        textRichMap.put("fontFamily", "PingFangSC-Regular");
        legendRichMap.put("textrich", textRichMap);
        legendTextStyle.put("rich", legendRichMap);
        pieChart.setLegendPropValue("textStyle", (Object)legendTextStyle);
        pieChart.setLegendPropValue("formatter", (Object)("function (name) { if (!name) return '';var data = [" + dataStr + "];let tarValue;      for (let i = 0; i < data.length; i++) {        if (data[i].name === name) {          tarValue = data[i].value;        }      }if (name.length > 7) {        name = name.slice(0, 7) + '...';      }return  '{textrich|'+name+'}'  +'{numrich|'+ ' : '+tarValue+'}';}"));
    }

    public static void customTooltip(PieChart pieChart) {
        HashMap<String, String> toolTipMap = new HashMap<String, String>();
        toolTipMap.put("formatter", "function (params, ticket, callback) {      return (        params.seriesName +        '<br/>' +        params.name +        ' : ' +        params.value +        ' (' +        Number(params.percent).toFixed(1) +        '%)'      );    }");
        toolTipMap.put("trigger", "item");
        pieChart.addProperty("tooltip", toolTipMap);
        pieChart.addFuncPath((List)Lists.newArrayList((Object[])new Object[]{"tooltip", "formatter"}));
        pieChart.addFuncPath((List)Lists.newArrayList((Object[])new Object[]{"legend", "formatter"}));
        pieChart.setShowTooltip(true);
    }

    public static void buildPieChartSeries(PieChart pieChart, Map<String, Integer> dataMap, String seriesName) {
        pieChart.setShowTitle(true);
        HashMap titleStyle = Maps.newHashMap();
        titleStyle.put("fontSize", 12);
        titleStyle.put("color", "#212121");
        titleStyle.put("fontWeight", "400");
        titleStyle.put("fontFamily", "Microsoft YaHei");
        pieChart.setTitlePropValue("textStyle", (Object)titleStyle);
        pieChart.setTitlePropValue("text", (Object)seriesName);
        pieChart.setTitlePropValue("left", (Object)"49%");
        pieChart.setTitlePropValue("top", (Object)"middle");
        pieChart.setTitlePropValue("textAlign", (Object)"center");
        PieSeries series = pieChart.createSeries(seriesName);
        dataMap.forEach((arg_0, arg_1) -> ((PieSeries)series).addData(arg_0, arg_1));
        series.setRadius("50%", "70%");
        Label label = new Label();
        label.setShow(true);
        label.setFormatter("{b}\uff1a{d}%");
        series.setLabel(label);
        if (CollectionUtils.isEmpty(dataMap)) {
            HashMap<String, Object> seriesItemStyle = new HashMap<String, Object>(2);
            seriesItemStyle.put("color", "#D9D9D9");
            seriesItemStyle.put("borderRadius", 0);
            seriesItemStyle.put("borderColor", "#D9D9D9");
            series.setPropValue("itemStyle", seriesItemStyle);
        } else {
            series.setPropValue("itemStyle", null);
        }
    }
}

