/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.formservice;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.business.servicehelper.BatchConfirmBasicService;
import kd.tdc.talp.common.enums.recommend.HandleStatusEnum;
import kd.tdc.talp.common.enums.recommend.RecommendStatusEnum;

public class PendingRecommendService
extends BatchConfirmBasicService {
    public void doOperationClosedCallBack(Object returnData, String opKey, AbstractFormPlugin formPlugin) {
        Map result = (Map)returnData;
        if (!CollectionUtils.isEmpty((Map)result) && ((Boolean)result.get("iscofirm")).booleanValue()) {
            IListView listView = (IListView)formPlugin.getView();
            String failPkIdString = listView.getPageCache().get("failpkid");
            if (!HRStringUtils.isEmpty((String)failPkIdString)) {
                List failPkIds = (List)SerializationUtils.deSerializeFromBase64((String)failPkIdString);
                List failRows = failPkIds.stream().map(ListSelectedRow::new).collect(Collectors.toList());
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                selectedRows.removeAll(failRows);
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("isopcancel", "0");
            listView.invokeOperation(opKey, option);
        }
    }

    protected boolean handleValidateResultForAllSuccess(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"batch_ignore")) {
            formPlugin.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u8981\u5ffd\u7565\u6240\u9009\u63a8\u8350\u4eba\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PendingRecommendService_29", (String)"tdc-talp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)formPlugin));
            return true;
        }
        return super.handleValidateResultForAllSuccess(operationResult, operate, formPlugin);
    }

    public void showValidateErrorMessage(OperationResult operationResult, FormOperate operate) {
        IListView listView = (IListView)operate.getView();
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        if (CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            return;
        }
        String firstErrorMsg = this.getErrorMsg((IOperateInfo)allErrorOrValidateInfo.get(0));
        boolean isExistsDifferentError = allErrorOrValidateInfo.stream().map(arg_0 -> ((PendingRecommendService)this).getErrorMsg(arg_0)).anyMatch(errorMsg -> !errorMsg.equals(firstErrorMsg));
        if (isExistsDifferentError) {
            listView.showOperationResult(operationResult, operate.getOperateName().getLocaleValue());
        } else {
            listView.showErrorNotification(firstErrorMsg);
        }
    }

    protected List<HRExportHeadObject> createExcelHeadData(FormOperate operate) {
        String opKey = operate.getOperateKey();
        return this.createExcelHeadData(opKey);
    }

    protected List<Map<String, Object>> createExcelExportData(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        List pkIds = listView.getSelectedRows().stream().map(selectedRow -> Long.valueOf(selectedRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(((IListView)formPlugin.getView()).getBillFormId());
        QFilter qFilter = new QFilter("id", "in", pkIds);
        DynamicObject[] dys = serviceHelper.queryOriginalArray("id,person.name,person.number,org.name,handlestatus,billno,handletime,talentfile.adminorg.name,talentfile.position.name,talentfile.stdposition.name,talentfile.job.name,recommendstatus,recommenddate,recommendemp.name,recommendemp.number,recommendintopool.name,recommendsource.name,handler.name,handler.number", qFilter.toArray());
        return this.createExcelExportData(operationResult, dys);
    }

    public List<Map<String, Object>> createExcelExportData(OperationResult operationResult, DynamicObject[] dys) {
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        Map<Long, String> errorInfo = allErrorOrValidateInfo.stream().collect(Collectors.toMap(opInfo -> Long.valueOf(opInfo.getPkValue().toString()), IOperateInfo::getMessage, (v1, v2) -> v1 + System.lineSeparator() + v2));
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject dy : dys) {
            HashMap<String, String> excelRowData = new HashMap<String, String>(16);
            long billId = dy.getLong("id");
            String errorMessage = errorInfo.get(billId);
            excelRowData.put("isoperable", HRStringUtils.isEmpty((String)errorMessage) ? ResManager.loadKDString((String)"\u662f", (String)"PendingRecommendService_19", (String)"tdc-talp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"PendingRecommendService_20", (String)"tdc-talp-formplugin", (Object[])new Object[0]));
            excelRowData.put("cannotoperatereason", errorMessage);
            excelRowData.put("name", dy.getString("person.name"));
            excelRowData.put("number", dy.getString("person.number"));
            excelRowData.put("billno", dy.getString("billno"));
            excelRowData.put("recommendemp.name", dy.getString("recommendemp.name"));
            excelRowData.put("recommendemp.number", dy.getString("recommendemp.number"));
            excelRowData.put("adminorg", dy.getString("talentfile.adminorg.name"));
            excelRowData.put("position", dy.getString("talentfile.position.name"));
            excelRowData.put("stdposition", dy.getString("talentfile.stdposition.name"));
            excelRowData.put("job", dy.getString("talentfile.job.name"));
            excelRowData.put("org", dy.getString("org.name"));
            HandleStatusEnum handleStatusEnum = HandleStatusEnum.getEnumByStatus((String)dy.getString("handlestatus"));
            String handleStatus = Objects.isNull(handleStatusEnum) ? "" : handleStatusEnum.getDesc();
            excelRowData.put("handlestatus", handleStatus);
            excelRowData.put("recommendintopool", dy.getString("recommendintopool.name"));
            excelRowData.put("recommendsource", dy.getString("recommendsource.name"));
            RecommendStatusEnum recommendStatusEnum = RecommendStatusEnum.getEnumByStatus((String)dy.getString("recommendstatus"));
            String recommendStatus = Objects.isNull(recommendStatusEnum) ? " " : recommendStatusEnum.getDesc();
            excelRowData.put("recommendstatus", recommendStatus);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date recommendDate = dy.getDate("recommenddate");
            excelRowData.put("recommenddate", Objects.isNull(recommendDate) ? "" : sdf.format(recommendDate));
            excelRowData.put("handler.name", dy.getString("handler.name"));
            excelRowData.put("handler.number", dy.getString("handler.number"));
            Date handleTime = dy.getDate("handletime");
            excelRowData.put("handletime", Objects.isNull(handleTime) ? "" : sdf.format(handleTime));
            exportData.add(excelRowData);
        }
        return exportData;
    }

    public List<HRExportHeadObject> createExcelHeadData(String opKey) {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>(16);
        if (opKey.equals("batch_entry")) {
            headDataList.add(new HRExportHeadObject("isoperable", ResManager.loadKDString((String)"\u662f\u5426\u53ef\u5165\u6c60", (String)"PendingRecommendService_17", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
            headDataList.add(new HRExportHeadObject("cannotoperatereason", ResManager.loadKDString((String)"\u4e0d\u53ef\u5165\u6c60\u7684\u539f\u56e0", (String)"PendingRecommendService_18", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        }
        if (opKey.equals("batch_ignore")) {
            headDataList.add(new HRExportHeadObject("isoperable", ResManager.loadKDString((String)"\u662f\u5426\u53ef\u5ffd\u7565", (String)"PendingRecommendService_23", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
            headDataList.add(new HRExportHeadObject("cannotoperatereason", ResManager.loadKDString((String)"\u4e0d\u53ef\u5ffd\u7565\u7684\u539f\u56e0", (String)"PendingRecommendService_24", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        }
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"PendingRecommendService_6", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"PendingRecommendService_7", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"PendingRecommendService_26", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("org", ResManager.loadKDString((String)"\u4eba\u624d\u7ba1\u7406\u7ec4\u7ec7", (String)"PendingRecommendService_8", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("adminorg", ResManager.loadKDString((String)"\u90e8\u95e8", (String)"PendingRecommendService_9", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("position", ResManager.loadKDString((String)"\u5f53\u524d\u5c97\u4f4d", (String)"PendingRecommendService_10", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("stdposition", ResManager.loadKDString((String)"\u5f53\u524d\u6807\u51c6\u5c97\u4f4d", (String)"TalentRecommendService_25", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("job", ResManager.loadKDString((String)"\u5f53\u524d\u804c\u4f4d", (String)"TalentRecommendService_26", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("handlestatus", ResManager.loadKDString((String)"\u5904\u7406\u72b6\u6001", (String)"PendingRecommendService_25", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("recommendintopool", ResManager.loadKDString((String)"\u63a8\u8350\u5165\u6c60", (String)"PendingRecommendService_11", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("recommendsource", ResManager.loadKDString((String)"\u63a8\u8350\u6765\u6e90", (String)"PendingRecommendService_12", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("recommendemp.name", ResManager.loadKDString((String)"\u63a8\u8350\u4eba\u59d3\u540d", (String)"PendingRecommendService_14", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("recommendemp.number", ResManager.loadKDString((String)"\u63a8\u8350\u4eba\u5de5\u53f7", (String)"PendingRecommendService_15", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("recommenddate", ResManager.loadKDString((String)"\u63a8\u8350\u65e5\u671f", (String)"PendingRecommendService_16", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("handler.name", ResManager.loadKDString((String)"\u5904\u7406\u4eba", (String)"PendingRecommendService_27", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("handler.number", ResManager.loadKDString((String)"\u5904\u7406\u4eba\u5de5\u53f7", (String)"PendingRecommendService_28", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("handletime", ResManager.loadKDString((String)"\u5904\u7406\u65f6\u95f4", (String)"PendingRecommendService_30", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        return headDataList;
    }
}

