/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.formservice;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.business.servicehelper.BatchConfirmBasicService;
import kd.tdc.talp.common.enums.recommend.RecommendStatusEnum;
import kd.tdc.tdcs.bussiness.formservice.batchconfirm.ConfirmPageUtil;

public class TalentRecommendService
extends BatchConfirmBasicService {
    protected boolean handleValidateResultForSomeFail(OperationResult operationResult, FormOperate operate, int allRowsSize, int failSize, AbstractFormPlugin formPlugin) {
        String opName = operate.getOperateName().getLocaleValue();
        String allNumLbl = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u6570\u636e\uff0c\u5176\u4e2d\uff1a", (String)"TalentRecommendService_0", (String)"tdc-talp-formplugin", (Object[])new Object[]{allRowsSize});
        String fitNumLbl = "" + (allRowsSize - failSize);
        String fitLbl = ResManager.loadKDString((String)"\u6761\u7b26\u5408\u6761\u4ef6\uff0c\u53ef\u64cd\u4f5c{0}", (String)"TalentRecommendService_1", (String)"tdc-talp-formplugin", (Object[])new Object[]{opName});
        String noFitNumLbl = "" + failSize;
        String noFitLbl = ResManager.loadKDString((String)"\u6761\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u5c06\u4e3a\u4f60\u8df3\u8fc7", (String)"TalentRecommendService_2", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        String excelName = ResManager.loadKDString((String)"{0}\u786e\u8ba4", (String)"TalentRecommendService_3", (String)"tdc-talp-formplugin", (Object[])new Object[]{opName});
        String finalLbl = ResManager.loadKDString((String)"{0}\u9009\u4e2d\u7684\u6570\u636e\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u5417\uff1f", (String)"TalentRecommendService_4", (String)"tdc-talp-formplugin", (Object[])new Object[]{opName});
        List<HRExportHeadObject> headDataList = this.createExcelHeadData(operate);
        List<Map<String, Object>> exportDataList = this.createExcelExportData(operationResult, operate, formPlugin);
        FormShowParameter confirmPage = ConfirmPageUtil.getBatchConfirmPage((String)allNumLbl, (String)fitNumLbl, (String)fitLbl, (String)noFitNumLbl, (String)noFitLbl, (String)finalLbl, (String)excelName, exportDataList, headDataList);
        confirmPage.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, operate.getOperateKey()));
        confirmPage.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"TalentRecommendService_5", (String)"tdc-talp-formplugin", (Object[])new Object[0]));
        formPlugin.getView().showForm(confirmPage);
        return true;
    }

    protected List<HRExportHeadObject> createExcelHeadData(FormOperate operate) {
        String opKey = operate.getOperateKey();
        return this.createExcelHeadData(opKey);
    }

    protected List<Map<String, Object>> createExcelExportData(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        List pkIds = listView.getSelectedRows().stream().map(selectedRow -> Long.valueOf(selectedRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(((IListView)formPlugin.getView()).getBillFormId());
        QFilter qFilter = new QFilter("id", "in", pkIds);
        DynamicObject[] dys = serviceHelper.query("id , person , billno , talentfile , recommendemp , recommendintopool , recommendsource , recommendstatus , recommenddate , org", qFilter.toArray());
        return this.createExcelExportData(operationResult, dys);
    }

    protected boolean handleValidateResultForAllSuccess(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"submit")) {
            formPlugin.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u8981\u5b8c\u6210\u5df2\u9009\u4eba\u624d\u7684\u63a8\u8350\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TalentRecommendService_27", (String)"tdc-talp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)formPlugin));
            return true;
        }
        return false;
    }

    public List<Map<String, Object>> createExcelExportData(OperationResult operationResult, DynamicObject[] dys) {
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        Map<Long, String> errorInfo = allErrorOrValidateInfo.stream().collect(Collectors.toMap(opInfo -> Long.valueOf(opInfo.getPkValue().toString()), IOperateInfo::getMessage, (v1, v2) -> v1 + System.lineSeparator() + v2));
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject talentRec : dys) {
            DynamicObject recommendEmpDy;
            HashMap<String, String> excelRowData = new HashMap<String, String>(16);
            long billId = talentRec.getLong("id");
            String errorMessage = errorInfo.get(billId);
            excelRowData.put("cannotoperatereason", errorMessage);
            excelRowData.put("isoperable", HRStringUtils.isEmpty((String)errorMessage) ? ResManager.loadKDString((String)"\u662f", (String)"TalentRecommendService_19", (String)"tdc-talp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"TalentRecommendService_20", (String)"tdc-talp-formplugin", (Object[])new Object[0]));
            DynamicObject person = talentRec.getDynamicObject("person");
            excelRowData.put("name", HRDyObjectPropUtil.getString((DynamicObject)person, (String)"name"));
            excelRowData.put("number", HRDyObjectPropUtil.getString((DynamicObject)person, (String)"number"));
            DynamicObject talentFileDy = talentRec.getDynamicObject("talentfile");
            if (!HRObjectUtils.isEmpty((Object)talentFileDy)) {
                excelRowData.put("adminorg", talentFileDy.getString("adminorg.name"));
                excelRowData.put("position", talentFileDy.getString("position.name"));
                excelRowData.put("stdposition", talentFileDy.getString("stdposition.name"));
                excelRowData.put("job", talentFileDy.getString("job.name"));
            }
            if (HRObjectUtils.isEmpty((Object)(recommendEmpDy = talentRec.getDynamicObject("recommendemp")))) {
                excelRowData.put("recommendemp.name", "");
                excelRowData.put("recommendemp.number", "");
            } else {
                excelRowData.put("recommendemp.name", recommendEmpDy.getString("name"));
                excelRowData.put("recommendemp.number", recommendEmpDy.getString("number"));
            }
            String createOrg = HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("org"));
            excelRowData.put("org", createOrg);
            String billNo = talentRec.getString("billno");
            excelRowData.put("billno", billNo);
            String recommendIntoPool = HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("recommendintopool"));
            excelRowData.put("recommendintopool", recommendIntoPool);
            String recommendSource = HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("recommendsource"));
            excelRowData.put("recommendsource", recommendSource);
            RecommendStatusEnum recommendStatusEnum = RecommendStatusEnum.getEnumByStatus((String)talentRec.getString("recommendstatus"));
            String recommendStatus = Objects.isNull(recommendStatusEnum) ? " " : recommendStatusEnum.getDesc();
            excelRowData.put("recommendstatus", recommendStatus);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date recommendDate = talentRec.getDate("recommenddate");
            if (recommendDate != null) {
                String formatDate = sdf.format(recommendDate);
                excelRowData.put("recommenddate", formatDate);
            }
            exportData.add(excelRowData);
        }
        return exportData;
    }

    public List<HRExportHeadObject> createExcelHeadData(String opKey) {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>(16);
        if (opKey.equals("delete")) {
            headDataList.add(new HRExportHeadObject("isoperable", ResManager.loadKDString((String)"\u662f\u5426\u53ef\u5220\u9664", (String)"TalentRecommendService_17", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
            headDataList.add(new HRExportHeadObject("cannotoperatereason", ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u7684\u539f\u56e0", (String)"TalentRecommendService_18", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        }
        if (opKey.equals("submit")) {
            headDataList.add(new HRExportHeadObject("isoperable", ResManager.loadKDString((String)"\u662f\u5426\u53ef\u63d0\u4ea4", (String)"TalentRecommendService_23", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
            headDataList.add(new HRExportHeadObject("cannotoperatereason", ResManager.loadKDString((String)"\u4e0d\u53ef\u63d0\u4ea4\u7684\u539f\u56e0", (String)"TalentRecommendService_24", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        }
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"TalentRecommendService_6", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"TalentRecommendService_7", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("org", ResManager.loadKDString((String)"\u4eba\u624d\u7ba1\u7406\u7ec4\u7ec7", (String)"TalentRecommendService_8", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"TalentRecommendService_28", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("adminorg", ResManager.loadKDString((String)"\u90e8\u95e8", (String)"TalentRecommendService_9", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("position", ResManager.loadKDString((String)"\u5f53\u524d\u5c97\u4f4d", (String)"TalentRecommendService_10", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("stdposition", ResManager.loadKDString((String)"\u5f53\u524d\u6807\u51c6\u5c97\u4f4d", (String)"TalentRecommendService_25", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("job", ResManager.loadKDString((String)"\u5f53\u524d\u804c\u4f4d", (String)"TalentRecommendService_26", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("recommendintopool", ResManager.loadKDString((String)"\u63a8\u8350\u5165\u6c60", (String)"TalentRecommendService_11", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("recommendsource", ResManager.loadKDString((String)"\u63a8\u8350\u6765\u6e90", (String)"TalentRecommendService_12", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("recommendstatus", ResManager.loadKDString((String)"\u63a8\u8350\u72b6\u6001", (String)"TalentRecommendService_13", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("recommendemp.name", ResManager.loadKDString((String)"\u63a8\u8350\u4eba\u59d3\u540d", (String)"TalentRecommendService_14", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("recommendemp.number", ResManager.loadKDString((String)"\u63a8\u8350\u4eba\u5de5\u53f7", (String)"TalentRecommendService_15", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("recommenddate", ResManager.loadKDString((String)"\u63a8\u8350\u65e5\u671f", (String)"TalentRecommendService_16", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        return headDataList;
    }
}

