/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.formservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.business.servicehelper.BatchConfirmBasicService;
import kd.tdc.talp.business.servicehelper.EntryExitPoolQueryHelper;
import kd.tdc.talp.common.enums.entryexitpool.EntryExitPoolStatusEnum;
import kd.tdc.tdcs.bussiness.formservice.batchconfirm.ConfirmPageUtil;
import kd.tdc.tdcs.enums.talentpool.ApplyTypeEnum;

public class TerminationBillService
extends BatchConfirmBasicService {
    protected boolean handleValidateResultForSomeFail(OperationResult operationResult, FormOperate operate, int allRowsSize, int failSize, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        String allNumLbl = ResManager.loadKDString((String)"\u5df2\u9009\u62e9{0}\u4e2a\u5355\u636e\u7ec8\u6b62\u6d41\u7a0b\uff0c\u5176\u4e2d\uff1a", (String)"TerminationBillService_0", (String)"tdc-talp-formplugin", (Object[])new Object[]{allRowsSize});
        String fitNumLbl = "" + (allRowsSize - failSize);
        String fitLbl = ResManager.loadKDString((String)"\u5355\u6ee1\u8db3\u7ec8\u6b62\u6761\u4ef6\uff0c\u5c06\u7ec8\u6b62\u6d41\u7a0b", (String)"TerminationBillService_1", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        String noFitNumLbl = "" + failSize;
        String noFitLbl = ResManager.loadKDString((String)"\u5355\u4e0d\u6ee1\u8db3\u7ec8\u6b62\u6761\u4ef6\uff0c\u5c06\u81ea\u52a8\u4e3a\u60a8\u6392\u9664", (String)"TerminationBillService_2", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        String excelName = ResManager.loadKDString((String)"\u7ec8\u6b62\u6d41\u7a0b\u786e\u8ba4", (String)"TerminationBillService_3", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        String reasonName = ResManager.loadKDString((String)"\u7ec8\u6b62\u539f\u56e0", (String)"TerminationBillService_4", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        String finalLbl = ResManager.loadKDString((String)"\u7ec8\u6b62\u6d41\u7a0b\u540e\uff0c\u6240\u9009\u62e9\u7684\u6d41\u7a0b\u5c06\u5168\u90e8\u7ec8\u6b62\uff0c\u4e14\u4e0d\u53ef\u64a4\u9500\u3002\u8bf7\u586b\u5199\u4ee5\u4e0b\u4fe1\u606f\uff0c\u4ee5\u786e\u8ba4\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"TerminationBillService_5", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        List<HRExportHeadObject> headDataList = this.createExcelHeadData(operate);
        List<Map<String, Object>> exportDataList = this.createExcelExportData(operationResult, operate, formPlugin);
        FormShowParameter confirmPage = ConfirmPageUtil.getSigReasonConfirmPage((String)allNumLbl, (String)fitNumLbl, (String)fitLbl, (String)noFitNumLbl, (String)noFitLbl, (String)excelName, exportDataList, headDataList, (String)reasonName, (String)finalLbl);
        confirmPage.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "terminate"));
        confirmPage.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"TerminationBillService_6", (String)"tdc-talp-formplugin", (Object[])new Object[0]));
        listView.showForm(confirmPage);
        return true;
    }

    public void callValidatorBeforeDoOperation(BeforeDoOperationEventArgs args, AbstractBillPlugIn formPlugin) {
        FormOperate operate = (FormOperate)args.getSource();
        String isOpCancel = operate.getOption().getVariableValue("isopcancel", null);
        if (HRStringUtils.isEmpty((String)isOpCancel)) {
            IFormView formView = formPlugin.getView();
            args.setCancel(true);
            OperateOption operateOption = operate.getOption();
            String operateKey = operate.getOperateKey();
            formView.getPageCache().put(operateKey + "_optionVariable", SerializationUtils.toJsonString((Object)operateOption.getVariables()));
            operateOption.setVariableValue("isopcancel", "1");
            String fromId = formView.getFormShowParameter().getFormId();
            Object pkValue = formPlugin.getView().getModel().getDataEntity().getPkValue();
            OperationResult preOpResult = OperationServiceHelper.executeOperate((String)operateKey, (String)fromId, (Object[])new Object[]{pkValue}, (OperateOption)operateOption);
            List failPkId = preOpResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).distinct().collect(Collectors.toList());
            if (failPkId.size() == 0) {
                this.handleValidateResultForAllSuccess(operateKey, formPlugin);
            } else {
                List allErrorOrValidateInfo = preOpResult.getAllErrorOrValidateInfo();
                if (CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                    return;
                }
                String firstErrorMsg = this.getErrorMsg((IOperateInfo)allErrorOrValidateInfo.get(0));
                boolean isExistsDifferentError = allErrorOrValidateInfo.stream().map(arg_0 -> ((TerminationBillService)this).getErrorMsg(arg_0)).anyMatch(errorMsg -> !HRStringUtils.equals((String)errorMsg, (String)firstErrorMsg));
                if (isExistsDifferentError) {
                    formView.showOperationResult(preOpResult, operate.getOperateName().getLocaleValue());
                } else {
                    formView.showErrorNotification(firstErrorMsg);
                }
            }
        }
    }

    protected boolean handleValidateResultForAllSuccess(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        FormShowParameter fsp = this.buildFsp();
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, operate.getOperateKey()));
        formPlugin.getView().showForm(fsp);
        return true;
    }

    public void handleValidateResultForAllSuccess(String operateKey, AbstractBillPlugIn formPlugin) {
        FormShowParameter fsp = this.buildFsp();
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, operateKey));
        formPlugin.getView().showForm(fsp);
    }

    private FormShowParameter buildFsp() {
        String details = ResManager.loadKDString((String)"\u7ec8\u6b62\u539f\u56e0", (String)"TerminationBillService_4", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        String finalLbl = ResManager.loadKDString((String)"\u7ec8\u6b62\u6d41\u7a0b\u540e\uff0c\u6240\u9009\u62e9\u7684\u6d41\u7a0b\u5c06\u5168\u90e8\u7ec8\u6b62\uff0c\u4e14\u4e0d\u53ef\u64a4\u9500\u3002\u8bf7\u586b\u5199\u4ee5\u4e0b\u4fe1\u606f\uff0c\u4ee5\u786e\u8ba4\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"TerminationBillService_5", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        FormShowParameter fsp = ConfirmPageUtil.getAllReasonSigConfirmPage((String)details, (String)finalLbl);
        fsp.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"TerminationBillService_6", (String)"tdc-talp-formplugin", (Object[])new Object[0]));
        return fsp;
    }

    public void doOperationClosedCallBack(Object returnData, String opKey, AbstractFormPlugin formPlugin) {
        Map result = (Map)returnData;
        if (!CollectionUtils.isEmpty((Map)result) && ((Boolean)result.get("iscofirm")).booleanValue()) {
            List<DynamicObject> outPoolDys;
            IListView listView = (IListView)formPlugin.getView();
            String failPkIdString = listView.getPageCache().get("failpkid");
            if (!HRStringUtils.isEmpty((String)failPkIdString)) {
                List failPkIds = (List)SerializationUtils.deSerializeFromBase64((String)failPkIdString);
                List failRows = failPkIds.stream().map(ListSelectedRow::new).collect(Collectors.toList());
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                selectedRows.removeAll(failRows);
            }
            OperateOption option = OperateOption.create();
            String reason = (String)result.get("details");
            option.setVariableValue("terminationidea", Objects.isNull(reason) ? " " : reason);
            option.setVariableValue("terminate", "true");
            option.setVariableValue("isopcancel", "0");
            Object[] primaryKeyValues = listView.getSelectedRows().getPrimaryKeyValues();
            DynamicObject[] dys = EntryExitPoolQueryHelper.queryByIds((String)"id,applyType", Arrays.stream(primaryKeyValues).map(value -> Long.parseLong(String.valueOf(value))).collect(Collectors.toList()));
            Map<String, List<DynamicObject>> groupDy = Arrays.stream(dys).collect(Collectors.groupingBy(item -> item.getString("applytype")));
            List<DynamicObject> inPoolDys = groupDy.get(ApplyTypeEnum.IN_POOL_PAGE.getStatus());
            if (HRCollUtil.isNotEmpty(inPoolDys)) {
                DynamicObject[] bills = EntryExitPoolQueryHelper.loadDys((String)ApplyTypeEnum.IN_POOL_PAGE.getStatus(), (Object[])inPoolDys.stream().map(dy -> dy.getLong("id")).toArray());
                OperationServiceHelper.executeOperate((String)opKey, (String)"talp_entrypoolbill", (DynamicObject[])bills, (OperateOption)option);
            }
            if (HRCollUtil.isNotEmpty(outPoolDys = groupDy.get(ApplyTypeEnum.OUT_POOL_PAGE.getStatus()))) {
                DynamicObject[] bills = EntryExitPoolQueryHelper.loadDys((String)ApplyTypeEnum.OUT_POOL_PAGE.getStatus(), (Object[])outPoolDys.stream().map(dy -> dy.getLong("id")).toArray());
                OperationServiceHelper.executeOperate((String)opKey, (String)"talp_exitpoolbill", (DynamicObject[])bills, (OperateOption)option);
            }
            listView.refresh();
        }
    }

    public void doOperationClosedCallBack(Object returnData, String opKey, AbstractBillPlugIn formPlugin) {
        Map result = (Map)returnData;
        if (!CollectionUtils.isEmpty((Map)result) && ((Boolean)result.get("iscofirm")).booleanValue()) {
            String reason;
            IFormView formView = formPlugin.getView();
            OperateOption option = OperateOption.create();
            this.setClosedCallBackOperateOption(returnData, option);
            String optionVariableCache = formView.getPageCache().get(opKey + "_optionVariable");
            if (HRStringUtils.isNotEmpty((String)optionVariableCache)) {
                Map optionVariables = (Map)SerializationUtils.fromJsonString((String)optionVariableCache, Map.class);
                optionVariables.remove("ishasright");
                optionVariables.forEach((arg_0, arg_1) -> ((OperateOption)option).setVariableValue(arg_0, arg_1));
            }
            option.setVariableValue("terminationidea", Objects.isNull(reason = (String)result.get("details")) ? " " : reason);
            option.setVariableValue("terminate", "true");
            option.setVariableValue("isopcancel", "0");
            formView.invokeOperation(opKey, option);
        }
    }

    protected List<HRExportHeadObject> createExcelHeadData(FormOperate operate) {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>(16);
        headDataList.add(new HRExportHeadObject("isoperable", ResManager.loadKDString((String)"\u662f\u5426\u6210\u529f\u7ec8\u6b62", (String)"TerminationBillService_7", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("cannotoperatereason", ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"TerminationBillService_8", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"TerminationBillService_9", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"TerminationBillService_10", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"TerminationBillService_11", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("org", ResManager.loadKDString((String)"\u4eba\u624d\u7ba1\u7406\u7ec4\u7ec7", (String)"TerminationBillService_12", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("adminorg", ResManager.loadKDString((String)"\u90e8\u95e8", (String)"TerminationBillService_13", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("position", ResManager.loadKDString((String)"\u5f53\u524d\u5c97\u4f4d", (String)"TerminationBillService_14", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("stdposition", ResManager.loadKDString((String)"\u5f53\u524d\u6807\u51c6\u5c97\u4f4d", (String)"TerminationBillService_15", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("job", ResManager.loadKDString((String)"\u5f53\u524d\u804c\u4f4d", (String)"TerminationBillService_16", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("applytype", ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u7c7b\u578b", (String)"TerminationBillService_17", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("businessstatus", ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001", (String)"TerminationBillService_18", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("billstatus", ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"TerminationBillService_19", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("talentpool", ResManager.loadKDString((String)"\u50a8\u5907\u6c60\u540d\u79f0", (String)"TerminationBillService_20", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("currmatchdegree", ResManager.loadKDString((String)"\u5f53\u524d\u5c97\u4f4d\u80dc\u4efb\u529b", (String)"TerminationBillService_21", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("targetcompetency", ResManager.loadKDString((String)"\u50a8\u5907\u76ee\u6807\u80dc\u4efb\u529b", (String)"TerminationBillService_22", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("intopooltype", ResManager.loadKDString((String)"\u5165\u6c60\u7c7b\u578b", (String)"TerminationBillService_23", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("intopooldate", ResManager.loadKDString((String)"\u5165\u6c60\u65e5\u671f", (String)"TerminationBillService_24", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("outofpooltype", ResManager.loadKDString((String)"\u51fa\u6c60\u7c7b\u578b", (String)"TerminationBillService_25", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("outofpooldate", ResManager.loadKDString((String)"\u51fa\u6c60\u65e5\u671f", (String)"TerminationBillService_26", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("submitter.name", ResManager.loadKDString((String)"\u63d0\u4ea4\u4eba\u59d3\u540d", (String)"TerminationBillService_27", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("submitter.number", ResManager.loadKDString((String)"\u63d0\u4ea4\u4eba\u5de5\u53f7", (String)"TerminationBillService_28", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("submittime", ResManager.loadKDString((String)"\u63d0\u4ea4\u65f6\u95f4", (String)"TerminationBillService_29", (String)"tdc-talp-formplugin", (Object[])new Object[0])));
        return headDataList;
    }

    protected List<Map<String, Object>> createExcelExportData(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        List pkIds = listView.getSelectedRows().stream().map(selectedRow -> Long.valueOf(selectedRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(((IListView)formPlugin.getView()).getBillFormId());
        QFilter qFilter = new QFilter("id", "in", pkIds);
        DynamicObject[] dys = serviceHelper.query("id,person,billno,org,adminorg,position,stdposition,job,applytype,billstatus,businessstatus,talentpool,currmatchdegree,targetcompetency,intopooltype,intopooldate,outofpooltype,outofpooldate,submitter,submittime", qFilter.toArray());
        return this.createExcelExportData(operationResult, dys);
    }

    public List<Map<String, Object>> createExcelExportData(OperationResult operationResult, DynamicObject[] dys) {
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        Map<Long, String> errorInfo = allErrorOrValidateInfo.stream().collect(Collectors.toMap(opInfo -> Long.valueOf(opInfo.getPkValue().toString()), IOperateInfo::getMessage, (v1, v2) -> v1 + System.lineSeparator() + v2));
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject talentRec : dys) {
            HashMap<String, String> excelRowData = new HashMap<String, String>(16);
            long billId = talentRec.getLong("id");
            String errorMessage = errorInfo.get(billId);
            excelRowData.put("isoperable", HRStringUtils.isEmpty((String)errorMessage) ? ResManager.loadKDString((String)"\u662f", (String)"TerminationBillService_30", (String)"tdc-talp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"TerminationBillService_31", (String)"tdc-talp-formplugin", (Object[])new Object[0]));
            excelRowData.put("cannotoperatereason", errorMessage);
            DynamicObject person = talentRec.getDynamicObject("person");
            excelRowData.put("name", HRDyObjectPropUtil.getString((DynamicObject)person, (String)"name"));
            excelRowData.put("number", HRDyObjectPropUtil.getString((DynamicObject)person, (String)"number"));
            excelRowData.put("billno", talentRec.getString("billno"));
            excelRowData.put("org", HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("org")));
            excelRowData.put("adminorg", HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("adminorg")));
            excelRowData.put("position", HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("position")));
            excelRowData.put("stdposition", HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("stdposition")));
            excelRowData.put("job", HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("job")));
            excelRowData.put("applytype", ApplyTypeEnum.getDescByStatus((String)talentRec.getString("applytype")));
            excelRowData.put("businessstatus", EntryExitPoolStatusEnum.getEnumByStatus((String)talentRec.getString("businessstatus")).getDesc());
            excelRowData.put("talentpool", HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("talentpool")));
            excelRowData.put("currmatchdegree", HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("currmatchdegree")));
            excelRowData.put("targetcompetency", HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("targetcompetency")));
            excelRowData.put("intopooltype", HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("intopooltype")));
            excelRowData.put("intopooldate", TerminationBillService.parseDateToStr((Date)talentRec.getDate("intopooldate")));
            excelRowData.put("outofpooltype", HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("outofpooltype")));
            excelRowData.put("outofpooldate", TerminationBillService.parseDateToStr((Date)talentRec.getDate("outofpooldate")));
            excelRowData.put("submitter.name", HRDyObjectPropUtil.getName((DynamicObject)talentRec.getDynamicObject("submitter")));
            excelRowData.put("submitter.number", HRDyObjectPropUtil.getString((DynamicObject)talentRec.getDynamicObject("submitter"), (String)"number"));
            excelRowData.put("submittime", TerminationBillService.parseDateToStr((Date)talentRec.getDate("submittime")));
            exportData.add(excelRowData);
        }
        return exportData;
    }
}

