/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.task;

import java.util.Arrays;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.tdc.talp.business.ServiceFactory;
import kd.tdc.talp.business.application.service.RecommendApplicationService;
import kd.tdc.talp.business.servicehelper.RecommendQueryHelper;

public class RecommendOrgUpgradeTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(RecommendOrgUpgradeTask.class);
    private final RecommendApplicationService recommendApplicationService = (RecommendApplicationService)ServiceFactory.getService(RecommendApplicationService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("Start-RecommendOrgUpgradeTask-taskId:{}", (Object)this.taskId);
        boolean flag = true;
        try (TXHandle required = TX.required();){
            Object[] dys = RecommendQueryHelper.queryReceivingOrgIsZero();
            if (HRArrayUtils.isNotEmpty((Object[])dys)) {
                Arrays.stream(dys).forEach(dy -> dy.set("receivingorg", (Object)dy.getLong("recommendintopool.createorg.id")));
                this.recommendApplicationService.save((DynamicObject[])dys);
            }
        }
        if (flag) {
            this.disableTask();
            LOG.info("RecommendOrgUpgradeTask-Is-Success");
        }
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)kd.bos.service.ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

