/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.analysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.portal.constant.SchemeType;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.application.PermissionApplicationService;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;

public class TalentAnalysisPlugin
extends GridContainerPlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(TalentAnalysisPlugin.class);
    private static final String ADD_CLIENT_CALL_BACK = "addClientCallBack";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("org", (Object)this.getOrgId());
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit talentPool = (BasedataEdit)this.getView().getControl("talentpool");
        talentPool.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().addClientCallBack(ADD_CLIENT_CALL_BACK);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String name = e.getName();
        if (ADD_CLIENT_CALL_BACK.equals(name)) {
            boolean isViewPermItem = this.getViewPermCache();
            this.getView().setVisible(Boolean.valueOf(isViewPermItem), new String[]{"floatmenupanelap"});
            if (isViewPermItem) {
                this.preData();
            }
        }
        if ("showAllCardForm".equals(name)) {
            this.showAllCardForm(this.getAllCardConfigMap(), true);
        }
    }

    private boolean getViewPermCache() {
        IPageCache pageCache = this.getPageCache();
        String viewPermCache = pageCache.get("isViewPermItem");
        if (HRStringUtils.isEmpty((String)viewPermCache)) {
            boolean isViewPermItem = this.checkViewPermission("talp_talentanalysis");
            boolean hasPoolViewPerm = this.checkViewPermission("tdcs_talentpool");
            boolean hasTalentViewPerm = this.checkViewPermission("tdcs_reservetalent");
            pageCache.put("isViewPermItem", Boolean.toString(isViewPermItem));
            pageCache.put("hasPoolViewPerm", Boolean.toString(hasPoolViewPerm));
            pageCache.put("hasTalentViewPerm", Boolean.toString(hasTalentViewPerm));
            return isViewPermItem;
        }
        return Boolean.parseBoolean(viewPermCache);
    }

    private void preData() {
        IPageCache pageCache = this.getPageCache();
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)currUserId, (String)"34", (String)"3=0WAUGB+EOW", (String)"talp_talentanalysis", (String)"47150e89000000ac", (boolean)true);
        pageCache.put("hasAllOrgPerm", Boolean.toString(hasPermOrgResult.hasAllOrgPerm()));
        pageCache.put("orgIds", SerializationUtils.serializeToBase64((Object)hasPermOrgResult.getHasPermOrgs()));
        DynamicObject dy = (DynamicObject)this.getModel().getValue("org");
        if (Objects.isNull(dy)) {
            return;
        }
        long orgId = dy.getLong("id");
        boolean hasPoolViewPerm = this.checkViewPermission("tdcs_talentpool");
        List<Object> poolIds = Lists.newArrayList();
        MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)this.getModel().getDataEntity().get("talentpool");
        if (hasPoolViewPerm) {
            if (CollectionUtils.isEmpty((Collection)collection)) {
                QFilter dataRuleFilter = PermissionApplicationService.getDataRule((String)"3=0WAUGB+EOW", (String)"tdcs_talentpool", (String)"47150e89000000ac");
                poolIds = TalentPoolQueryHelper.queryPoolIdsByDataRuleFilter((Long)orgId, (QFilter)dataRuleFilter);
            } else {
                poolIds = collection.stream().map(item -> item.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            }
        }
        pageCache.put("poolIds", SerializationUtils.serializeToBase64((Object)poolIds));
        boolean hasTalentViewPerm = this.checkViewPermission("tdcs_reservetalent");
        List<Object> empIds = Lists.newArrayList();
        List<Object> perIds = Lists.newArrayList();
        List<Object> reserveTalentIds = Lists.newArrayList();
        if (hasPoolViewPerm && hasTalentViewPerm) {
            QFilter dataRuleFilter = PermissionApplicationService.getDataRule((String)"3=0WAUGB+EOW", (String)"tdcs_reservetalent", (String)"47150e89000000ac");
            Object[] resultMap = CollectionUtils.isEmpty((Collection)collection) ? TalentPoolQueryHelper.queryReserveTalentByDataRuleQFilter((String)"id,employee,person", (long)orgId, (List)Lists.newArrayList(), (QFilter)dataRuleFilter) : TalentPoolQueryHelper.queryReserveTalentByDataRuleQFilter((String)"id,employee,person", (long)orgId, (List)poolIds, (QFilter)dataRuleFilter);
            if (HRArrayUtils.isNotEmpty((Object[])resultMap)) {
                pageCache.put("data", SerializationUtils.serializeToBase64((Object)resultMap));
                empIds = Arrays.stream(resultMap).map(item -> item.getLong("employee")).collect(Collectors.toList());
                perIds = Arrays.stream(resultMap).map(item -> item.getLong("person")).collect(Collectors.toList());
                reserveTalentIds = Arrays.stream(resultMap).map(item -> item.getLong("id")).collect(Collectors.toList());
            }
        }
        pageCache.put("empIds", SerializationUtils.serializeToBase64((Object)empIds));
        pageCache.put("perIds", SerializationUtils.serializeToBase64((Object)perIds));
        pageCache.put("reserveTalentIds", SerializationUtils.serializeToBase64((Object)reserveTalentIds));
    }

    private boolean checkViewPermission(String fromId) {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"3=0WAUGB+EOW", (String)fromId, (String)"47150e89000000ac");
    }

    public void itemClick(ItemClickEvent evt) {
        if (this.checkPermissionChanged()) {
            this.showPermissionChangedView();
            return;
        }
        Map paramMap = evt.getParamsMap();
        String key = evt.getItemKey();
        if ("addCard".equals(key)) {
            if (paramMap.get("layout") != null) {
                this.getPageCache().put("layout", paramMap.get("layout").toString());
            }
            this.showNewCardTypeForm(null);
        } else if ("editEnd".equals(key)) {
            this.editEnd(SchemeType.UserScheme, (String)paramMap.get("layout"), null);
        } else if ("refresh".equals(key)) {
            this.clickFreshGridContainer();
        } else {
            super.itemClick(evt);
        }
    }

    public void showNewCardTypeForm(String cardTypeIndex) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("tdcs_card_custom_config");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CallBack_showAddCardForm"));
        if (StringUtils.isNotEmpty((String)cardTypeIndex)) {
            fsp.setCustomParam("event_rtn_addcard", (Object)cardTypeIndex);
        }
        fsp.setCustomParam("appNumber", (Object)"talp");
        this.getView().showForm(fsp);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldName = event.getProperty().getName();
        if (this.checkPermissionChanged()) {
            this.showPermissionChangedView();
            event.setCancel(true);
        }
        if ("talentpool".equals(fieldName)) {
            boolean hasPoolViewPerm = this.checkViewPermission("tdcs_talentpool");
            ListShowParameter lsp = (ListShowParameter)event.getFormShowParameter();
            if (hasPoolViewPerm) {
                QFilter dataRuleFilter = PermissionApplicationService.getDataRule((String)"3=0WAUGB+EOW", (String)"tdcs_talentpool", (String)"47150e89000000ac");
                DynamicObject dy = (DynamicObject)this.getModel().getValue("org");
                if (!Objects.isNull(dy)) {
                    long orgId = dy.getLong("id");
                    List poolIds = TalentPoolQueryHelper.queryPoolIdsByDataRuleFilter((Long)orgId, (QFilter)dataRuleFilter);
                    lsp.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)poolIds));
                    return;
                }
            }
            lsp.getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)0L));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        if (this.checkPermissionChanged()) {
            this.showPermissionChangedView();
            return;
        }
        String name = args.getProperty().getName();
        if ("org".equals(name)) {
            this.getModel().setValue("talentpool", null);
            this.clickFreshGridContainer();
        }
        if ("talentpool".equals(name)) {
            this.clickFreshGridContainer();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("refresh_grid_donothing".equals(operateKey) && this.checkPermissionChanged()) {
            args.setCancel(true);
        }
    }

    private void showPermissionChangedView() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\u3002\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"APPWorkBenchPlugin_0", (String)"tdc-talp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("refresh_grid"));
    }

    public void clickFreshGridContainer() {
        if (this.checkPermissionChanged()) {
            this.showPermissionChangedView();
        } else {
            super.clickFreshGridContainer();
            this.preData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (this.checkPermissionChanged()) {
            this.showPermissionChangedView();
        } else {
            this.preData();
            super.closedCallBack(e);
        }
    }

    private boolean checkPermissionChanged() {
        IPageCache pageCache = this.getPageCache();
        boolean isViewPermItem = this.checkViewPermission("talp_talentanalysis");
        if (!isViewPermItem) {
            return true;
        }
        boolean hasPoolViewPerm = this.checkViewPermission("tdcs_talentpool");
        String hasPoolViewPermCache = pageCache.get("hasPoolViewPerm");
        if (HRStringUtils.isNotEmpty((String)hasPoolViewPermCache) && hasPoolViewPerm != Boolean.parseBoolean(hasPoolViewPermCache)) {
            return true;
        }
        boolean hasTalentViewPerm = this.checkViewPermission("tdcs_reservetalent");
        String hasTalentViewPermCache = pageCache.get("hasTalentViewPerm");
        if (HRStringUtils.isNotEmpty((String)hasTalentViewPermCache) && hasTalentViewPerm != Boolean.parseBoolean(hasTalentViewPermCache)) {
            return true;
        }
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"34", (String)"3=0WAUGB+EOW", (String)"talp_talentanalysis", (String)"47150e89000000ac", (boolean)true);
        boolean currHasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        String hasAllOrgPermStr = pageCache.get("hasAllOrgPerm");
        if (Objects.isNull(hasAllOrgPermStr)) {
            return false;
        }
        if (hasAllOrgPermStr.equals(Boolean.toString(currHasAllOrgPerm))) {
            List currHasPermOrgIds = hasPermOrgResult.getHasPermOrgs();
            if (!currHasAllOrgPerm) {
                ArrayList cacheHasPermOrgIds;
                String orgIdsStr = pageCache.get("orgIds");
                List list = cacheHasPermOrgIds = HRStringUtils.isEmpty((String)orgIdsStr) ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)orgIdsStr);
                if (currHasPermOrgIds.size() != cacheHasPermOrgIds.size()) {
                    return true;
                }
                boolean isChange0 = cacheHasPermOrgIds.stream().anyMatch(item -> !currHasPermOrgIds.contains(item));
                boolean isChange1 = currHasPermOrgIds.stream().anyMatch(item -> !cacheHasPermOrgIds.contains(item));
                return isChange0 || isChange1;
            }
        } else {
            return true;
        }
        return false;
    }

    private long getOrgId() {
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)currUserId, (String)"34", (String)"3=0WAUGB+EOW", (String)"talp_talentanalysis", (String)"47150e89000000ac", (boolean)true);
        long currOrgId = RequestContext.get().getOrgId();
        LOG.info("getOrgId#currOrgId:{}", (Object)currOrgId);
        List hasPermOrgIds = hasPermOrgResult.getHasPermOrgs();
        if (!CollectionUtils.isEmpty((Collection)hasPermOrgIds) && hasPermOrgIds.stream().anyMatch(orgId -> orgId.equals(currOrgId))) {
            return currOrgId;
        }
        if (!CollectionUtils.isEmpty((Collection)hasPermOrgIds)) {
            return (Long)hasPermOrgIds.get(0);
        }
        return 0L;
    }
}

