/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.analysis.card;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.PieChart;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.common.enums.workbench.AgeTypeEnum;
import kd.tdc.talp.formplugin.formservice.AppWorkbenchService;
import kd.tdc.talp.formplugin.web.workbench.CardCommonPlugin;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;

public class AgeDistributionPlugin
extends CardCommonPlugin {
    private static final HrpiService HRPI_SERVICE = (HrpiService)ServiceFactory.getService(HrpiService.class);

    @Override
    protected void initData() {
        ArrayList perListIds;
        PieChart pieChartAp = (PieChart)this.getControl("piechartap");
        boolean hasViewCardPerm = this.hasViewCardPerm();
        if (!hasViewCardPerm) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            this.getView().setVisible(Boolean.FALSE, new String[]{"data_flex"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"no_view_flex"});
        IFormView parentView = this.getView().getParentView();
        IPageCache parentPageCache = parentView.getPageCache();
        String perIdsStr = parentPageCache.get("perIds");
        List list = perListIds = HRStringUtils.isEmpty((String)perIdsStr) ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)perIdsStr);
        if (CollectionUtils.isEmpty((Collection)perListIds)) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            return;
        }
        Map<String, Integer> dataMap = this.buildData(perListIds);
        if (CollectionUtils.isEmpty(dataMap)) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            return;
        }
        AppWorkbenchService.customLegendStyle(pieChartAp, dataMap);
        AppWorkbenchService.customTooltip(pieChartAp);
        String seriesName = ResManager.loadKDString((String)"\u5e74\u9f84\u7ed3\u6784", (String)"AgeDistributionPlugin_0", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        AppWorkbenchService.buildPieChartSeries(pieChartAp, dataMap, seriesName);
        this.getView().updateView("piechartap");
    }

    private Map<String, Integer> buildData(List<Long> perIds) {
        List perAgeColl = HRPI_SERVICE.listBatchPropPersonAttach(perIds, "person,age", null, "hrpi_pernontsprop");
        if (CollectionUtils.isEmpty((Collection)perAgeColl)) {
            return Maps.newHashMap();
        }
        Map<Long, Integer> idAgeMapping = perAgeColl.stream().collect(Collectors.toMap(item -> (Long)item.get("person"), item -> Integer.valueOf(((Object)item.getOrDefault("age", 0)).toString()), (v1, v2) -> v2));
        AtomicInteger num1 = new AtomicInteger(0);
        AtomicInteger num2 = new AtomicInteger(0);
        AtomicInteger num3 = new AtomicInteger(0);
        AtomicInteger num4 = new AtomicInteger(0);
        AtomicInteger num5 = new AtomicInteger(0);
        AtomicInteger num6 = new AtomicInteger(0);
        AtomicInteger num7 = new AtomicInteger(0);
        AtomicInteger num8 = new AtomicInteger(0);
        AtomicInteger num9 = new AtomicInteger(0);
        HashMap dataMap = Maps.newHashMap();
        perIds.forEach(perId -> {
            int age = idAgeMapping.getOrDefault(perId, 0);
            if (age == 0) {
                dataMap.put(AgeTypeEnum.OTHER.getDesc(), num9.addAndGet(1));
            } else if (age <= 25) {
                dataMap.put(AgeTypeEnum.UNDER_25_YEARS_OLD.getDesc(), num1.addAndGet(1));
            } else if (age <= 30) {
                dataMap.put(AgeTypeEnum.YEARS_OLD_26_35.getDesc(), num2.addAndGet(1));
            } else if (age <= 35) {
                dataMap.put(AgeTypeEnum.YEARS_OLD_31_35.getDesc(), num3.addAndGet(1));
            } else if (age <= 40) {
                dataMap.put(AgeTypeEnum.YEARS_OLD_36_40.getDesc(), num4.addAndGet(1));
            } else if (age <= 45) {
                dataMap.put(AgeTypeEnum.YEARS_OLD_41_45.getDesc(), num5.addAndGet(1));
            } else if (age <= 50) {
                dataMap.put(AgeTypeEnum.YEARS_OLD_46_50.getDesc(), num6.addAndGet(1));
            } else if (age <= 55) {
                dataMap.put(AgeTypeEnum.YEARS_OLD_51_55.getDesc(), num7.addAndGet(1));
            } else {
                dataMap.put(AgeTypeEnum.OVER_55_YEARS_OLD.getDesc(), num8.addAndGet(1));
            }
        });
        return dataMap;
    }
}

