/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.analysis.card;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.PieChart;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.common.enums.workbench.CompetencyEnum;
import kd.tdc.talp.formplugin.formservice.AppWorkbenchService;
import kd.tdc.talp.formplugin.web.workbench.CardCommonPlugin;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;

public class CompetencyDistributionPlugin
extends CardCommonPlugin {
    @Override
    protected void initData() {
        ArrayList reserveTalentListIds;
        PieChart pieChartAp = (PieChart)this.getControl("piechartap");
        boolean hasViewCardPerm = this.hasViewCardPerm();
        if (!hasViewCardPerm) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            this.getView().setVisible(Boolean.FALSE, new String[]{"data_flex"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"no_view_flex"});
        IFormView parentView = this.getView().getParentView();
        IPageCache parentPageCache = parentView.getPageCache();
        String reserveTalentIds = parentPageCache.get("reserveTalentIds");
        List list = reserveTalentListIds = HRStringUtils.isEmpty((String)reserveTalentIds) ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)reserveTalentIds);
        if (CollectionUtils.isEmpty((Collection)reserveTalentListIds)) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            return;
        }
        Map<String, Integer> dataMap = this.buildData(reserveTalentListIds);
        if (CollectionUtils.isEmpty(dataMap)) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            return;
        }
        AppWorkbenchService.customLegendStyle(pieChartAp, dataMap);
        AppWorkbenchService.customTooltip(pieChartAp);
        String formId = this.getView().getFormShowParameter().getFormId();
        String seriesName = "talp_currpostcompetency".equals(formId) ? ResManager.loadKDString((String)"\u5f53\u524d\u5c97\u4f4d\u80dc\u4efb\u529b\u5206\u5e03", (String)"CompetencyDistributionPlugin_0", (String)"tdc-talp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u50a8\u5907\u76ee\u6807\u80dc\u4efb\u529b\u5206\u5e03", (String)"CompetencyDistributionPlugin_1", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        AppWorkbenchService.buildPieChartSeries(pieChartAp, dataMap, seriesName);
        this.getView().updateView("piechartap");
    }

    private Map<String, Integer> buildData(List<Long> reserveTalentListIds) {
        String postCompetency;
        String selectField;
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("talp_currpostcompetency".equals(formId)) {
            selectField = "id,currmatchdegree";
            postCompetency = "currmatchdegree";
        } else {
            selectField = "id,targetcompetency";
            postCompetency = "targetcompetency";
        }
        Object[] reserveTalent = TalentPoolQueryHelper.queryReserveTalentByIds((String)selectField, reserveTalentListIds);
        if (HRArrayUtils.isEmpty((Object[])reserveTalent)) {
            return Maps.newHashMap();
        }
        Map<Long, Long> reserveTalentInfo = Arrays.stream(reserveTalent).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getLong(postCompetency), (v1, v2) -> v2));
        AtomicInteger num1 = new AtomicInteger(0);
        AtomicInteger num2 = new AtomicInteger(0);
        AtomicInteger num3 = new AtomicInteger(0);
        AtomicInteger num4 = new AtomicInteger(0);
        HashMap dataMap = Maps.newHashMap();
        reserveTalentListIds.forEach(reserveTalentId -> {
            long competencyId = (Long)reserveTalentInfo.get(reserveTalentId);
            if (competencyId == CompetencyEnum.FULLY_COMPETENCY.getPreDataId()) {
                dataMap.put(CompetencyEnum.FULLY_COMPETENCY.getDesc(), num1.addAndGet(1));
            } else if (competencyId == CompetencyEnum.COMPETENCY.getPreDataId()) {
                dataMap.put(CompetencyEnum.COMPETENCY.getDesc(), num2.addAndGet(1));
            } else if (competencyId == CompetencyEnum.BASIC_COMPETENCY.getPreDataId()) {
                dataMap.put(CompetencyEnum.BASIC_COMPETENCY.getDesc(), num3.addAndGet(1));
            } else if (competencyId == CompetencyEnum.NOT_COMPETENCY.getPreDataId()) {
                dataMap.put(CompetencyEnum.NOT_COMPETENCY.getDesc(), num4.addAndGet(1));
            }
        });
        return dataMap;
    }
}

