/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.analysis.card;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.PieChart;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.common.enums.workbench.EducationEnum;
import kd.tdc.talp.formplugin.formservice.AppWorkbenchService;
import kd.tdc.talp.formplugin.web.workbench.CardCommonPlugin;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;

public class EduDistributionPlugin
extends CardCommonPlugin {
    private static final Log LOG = LogFactory.getLog(EduDistributionPlugin.class);
    private static final HrpiService HRPI_SERVICE = (HrpiService)ServiceFactory.getService(HrpiService.class);

    @Override
    protected void initData() {
        ArrayList perListIds;
        PieChart pieChartAp = (PieChart)this.getControl("piechartap");
        boolean hasViewCardPerm = this.hasViewCardPerm();
        if (!hasViewCardPerm) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            this.getView().setVisible(Boolean.FALSE, new String[]{"data_flex"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"no_view_flex"});
        IFormView parentView = this.getView().getParentView();
        IPageCache parentPageCache = parentView.getPageCache();
        String perIdsStr = parentPageCache.get("perIds");
        List list = perListIds = HRStringUtils.isEmpty((String)perIdsStr) ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)perIdsStr);
        if (CollectionUtils.isEmpty((Collection)perListIds)) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            return;
        }
        Map<String, Integer> dataMap = this.buildData(perListIds);
        if (CollectionUtils.isEmpty(dataMap)) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            return;
        }
        AppWorkbenchService.customLegendStyle(pieChartAp, dataMap);
        AppWorkbenchService.customTooltip(pieChartAp);
        String seriesName = ResManager.loadKDString((String)"\u5b66\u5386\u5206\u5e03", (String)"EduDistributionPlugin_0", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        AppWorkbenchService.buildPieChartSeries(pieChartAp, dataMap, seriesName);
        this.getView().updateView("piechartap");
    }

    private Map<String, Integer> buildData(List<Long> perIds) {
        List perInfoList = HRPI_SERVICE.listBatchPropPersonAttach(perIds, "person,education", new QFilter("ishighestdegree", "=", (Object)"1"), "hrpi_pereduexp");
        Map<Long, Long> educationInfo = perInfoList.stream().collect(Collectors.toMap(item -> (Long)item.get("person"), item -> item.getOrDefault("education", 0L), (v1, v2) -> v2));
        AtomicInteger num1 = new AtomicInteger(0);
        AtomicInteger num2 = new AtomicInteger(0);
        AtomicInteger num3 = new AtomicInteger(0);
        AtomicInteger num4 = new AtomicInteger(0);
        AtomicInteger num5 = new AtomicInteger(0);
        AtomicInteger num6 = new AtomicInteger(0);
        HashMap dataMap = Maps.newHashMap();
        perIds.forEach(perId -> {
            long educationId = educationInfo.getOrDefault(perId, 0L);
            if (educationId == EducationEnum.DIPLOMA.getId()) {
                dataMap.put(EducationEnum.DIPLOMA.getDesc(), num1.addAndGet(1));
            } else if (educationId == EducationEnum.BACHELOR.getId()) {
                dataMap.put(EducationEnum.BACHELOR.getDesc(), num2.addAndGet(1));
            } else if (educationId == EducationEnum.MASTER.getId()) {
                dataMap.put(EducationEnum.MASTER.getDesc(), num3.addAndGet(1));
            } else if (educationId == EducationEnum.DOCTOR.getId()) {
                dataMap.put(EducationEnum.DOCTOR.getDesc(), num4.addAndGet(1));
            } else if (EducationEnum.equalsDiplomaBelow((Long)educationId)) {
                dataMap.put(EducationEnum.DIPLOMA_BELOW.getDesc(), num5.addAndGet(1));
            } else if (educationId == EducationEnum.OTHER.getId() || educationId == 0L) {
                dataMap.put(EducationEnum.OTHER.getDesc(), num6.addAndGet(1));
            }
        });
        return dataMap;
    }
}

