/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.analysis.card;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.PieChart;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.formplugin.formservice.AppWorkbenchService;
import kd.tdc.talp.formplugin.web.workbench.CardCommonPlugin;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;

public class PoolTypeDistributionPlugin
extends CardCommonPlugin {
    @Override
    protected void initData() {
        ArrayList poolListIds;
        PieChart pieChartAp = (PieChart)this.getControl("piechartap");
        boolean hasViewCardPerm = this.hasViewCardPerm();
        if (!hasViewCardPerm) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            this.getView().setVisible(Boolean.FALSE, new String[]{"data_flex"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"no_view_flex"});
        IFormView parentView = this.getView().getParentView();
        IPageCache parentPageCache = parentView.getPageCache();
        String poolIds = parentPageCache.get("poolIds");
        List list = poolListIds = HRStringUtils.isEmpty((String)poolIds) ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)poolIds);
        if (CollectionUtils.isEmpty((Collection)poolListIds)) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            return;
        }
        Map<String, Integer> dataMap = this.buildData(poolListIds);
        if (CollectionUtils.isEmpty(dataMap)) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            return;
        }
        AppWorkbenchService.customLegendStyle(pieChartAp, dataMap);
        AppWorkbenchService.customTooltip(pieChartAp);
        String formId = this.getView().getFormShowParameter().getFormId();
        String seriesName = "talp_intopoolanalysis".equals(formId) ? ResManager.loadKDString((String)"\u5165\u6c60\u7c7b\u578b\u5206\u5e03", (String)"PoolTypeDistributionPlugin_0", (String)"tdc-talp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u51fa\u6c60\u7c7b\u578b\u5206\u5e03", (String)"PoolTypeDistributionPlugin_1", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        AppWorkbenchService.buildPieChartSeries(pieChartAp, dataMap, seriesName);
        this.getView().updateView("piechartap");
    }

    private Map<String, Integer> buildData(List<Long> poolListIds) {
        Object[] resultMap;
        String helperFormId;
        String fieldName;
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("talp_intopoolanalysis".equals(formId)) {
            fieldName = "intopooltype";
            helperFormId = "tdcs_intopooltype";
            resultMap = TalentPoolQueryHelper.queryInPoolReserveTalentByPoolIds((String)"id,intopooltype", poolListIds);
        } else {
            fieldName = "outofpooltype";
            helperFormId = "tdcs_outofpooltype";
            resultMap = TalentPoolQueryHelper.queryOutPoolReserveTalentByPoolIds((String)"id,outofpooltype", poolListIds);
        }
        if (HRArrayUtils.isEmpty((Object[])resultMap)) {
            return Maps.newHashMap();
        }
        Map<Long, List<DynamicObject>> groupByType = Arrays.stream(resultMap).collect(Collectors.groupingBy(item -> item.getLong(fieldName)));
        Set<Long> typeIds = groupByType.keySet();
        Object[] typeNames = TalentPoolQueryHelper.queryNameByTypeAndIds((String)helperFormId, typeIds);
        if (HRArrayUtils.isEmpty((Object[])typeNames)) {
            return Maps.newHashMap();
        }
        Map<Long, String> idNameMapping = Arrays.stream(typeNames).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getString("name"), (v1, v2) -> v2));
        HashMap dataMap = Maps.newHashMap();
        groupByType.forEach((typeId, reserveTalent) -> dataMap.put(idNameMapping.get(typeId), reserveTalent.size()));
        return dataMap;
    }
}

