/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.analysis.card;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.PieChart;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.common.enums.workbench.ServingAgeTypeEnum;
import kd.tdc.talp.formplugin.formservice.AppWorkbenchService;
import kd.tdc.talp.formplugin.web.workbench.CardCommonPlugin;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;

public class ServingAgeDistributionPlugin
extends CardCommonPlugin {
    private static final HrpiService HRPI_SERVICE = (HrpiService)ServiceFactory.getService(HrpiService.class);

    @Override
    protected void initData() {
        ArrayList perListIds;
        PieChart pieChartAp = (PieChart)this.getControl("piechartap");
        boolean hasViewCardPerm = this.hasViewCardPerm();
        if (!hasViewCardPerm) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            this.getView().setVisible(Boolean.FALSE, new String[]{"data_flex"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"no_view_flex"});
        IFormView parentView = this.getView().getParentView();
        IPageCache parentPageCache = parentView.getPageCache();
        String perIdsStr = parentPageCache.get("perIds");
        List list = perListIds = HRStringUtils.isEmpty((String)perIdsStr) ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)perIdsStr);
        if (CollectionUtils.isEmpty((Collection)perListIds)) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            return;
        }
        Map<String, Integer> dataMap = this.buildData(perListIds);
        if (CollectionUtils.isEmpty(dataMap)) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            return;
        }
        AppWorkbenchService.customLegendStyle(pieChartAp, dataMap);
        AppWorkbenchService.customTooltip(pieChartAp);
        String seriesName = ResManager.loadKDString((String)"\u53f8\u9f84\u5206\u5e03", (String)"ServingAgeDistributionPlugin_0", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        AppWorkbenchService.buildPieChartSeries(pieChartAp, dataMap, seriesName);
        this.getView().updateView("piechartap");
    }

    private Map<String, Integer> buildData(List<Long> perIds) {
        List perEntServiceLenColl = HRPI_SERVICE.listBatchPropPersonAttach(perIds, "person,entservicelen", null, "hrpi_pernontsprop");
        if (CollectionUtils.isEmpty((Collection)perEntServiceLenColl)) {
            return Maps.newHashMap();
        }
        Map<Long, Double> idEntServiceLenMapping = perEntServiceLenColl.stream().collect(Collectors.toMap(item -> (Long)item.get("person"), item -> item.getOrDefault("entservicelen", new BigDecimal("0")).doubleValue(), (v1, v2) -> v2));
        AtomicInteger num1 = new AtomicInteger(0);
        AtomicInteger num2 = new AtomicInteger(0);
        AtomicInteger num3 = new AtomicInteger(0);
        AtomicInteger num4 = new AtomicInteger(0);
        AtomicInteger num5 = new AtomicInteger(0);
        HashMap dataMap = Maps.newHashMap();
        perIds.forEach(perId -> {
            double servingAge = idEntServiceLenMapping.getOrDefault(perId, 0.0);
            if (servingAge < 1.0) {
                dataMap.put(ServingAgeTypeEnum.UNDER_1_YEAR.getDesc(), num1.addAndGet(1));
            } else if (servingAge <= 3.0) {
                dataMap.put(ServingAgeTypeEnum.YEAR_1_3.getDesc(), num2.addAndGet(1));
            } else if (servingAge <= 5.0) {
                dataMap.put(ServingAgeTypeEnum.YEAR_3_5.getDesc(), num3.addAndGet(1));
            } else if (servingAge <= 10.0) {
                dataMap.put(ServingAgeTypeEnum.YEAR_5_10.getDesc(), num4.addAndGet(1));
            } else {
                dataMap.put(ServingAgeTypeEnum.OVER_10_YEAR.getDesc(), num5.addAndGet(1));
            }
        });
        return dataMap;
    }
}

