/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.analysis.card;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.PieChart;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.business.application.external.ExternalService;
import kd.tdc.talp.formplugin.formservice.AppWorkbenchService;
import kd.tdc.talp.formplugin.web.workbench.CardCommonPlugin;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;

public class SexDistributionPlugin
extends CardCommonPlugin {
    private static final Log LOG = LogFactory.getLog(SexDistributionPlugin.class);
    private static final HrpiService HRPI_SERVICE = (HrpiService)ServiceFactory.getService(HrpiService.class);
    private static final ExternalService EXTERNAL_SERVICE = (ExternalService)kd.tdc.talp.business.ServiceFactory.getService(ExternalService.class);

    @Override
    protected void initData() {
        ArrayList perListIds;
        PieChart pieChartAp = (PieChart)this.getControl("piechartap");
        boolean hasViewCardPerm = this.hasViewCardPerm();
        if (!hasViewCardPerm) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            this.getView().setVisible(Boolean.FALSE, new String[]{"data_flex"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"no_view_flex"});
        IFormView parentView = this.getView().getParentView();
        IPageCache parentPageCache = parentView.getPageCache();
        String perIdsStr = parentPageCache.get("perIds");
        List list = perListIds = HRStringUtils.isEmpty((String)perIdsStr) ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)perIdsStr);
        if (CollectionUtils.isEmpty((Collection)perListIds)) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            return;
        }
        Map<String, Integer> dataMap = this.buildData(perListIds);
        if (CollectionUtils.isEmpty(dataMap)) {
            pieChartAp.clearData();
            this.getView().updateView("piechartap");
            return;
        }
        AppWorkbenchService.customLegendStyle(pieChartAp, dataMap);
        AppWorkbenchService.customTooltip(pieChartAp);
        String seriesName = ResManager.loadKDString((String)"\u6027\u522b\u7ed3\u6784\u5206\u5e03", (String)"SexDistributionPlugin_0", (String)"tdc-talp-formplugin", (Object[])new Object[0]);
        AppWorkbenchService.buildPieChartSeries(pieChartAp, dataMap, seriesName);
        this.getView().updateView("piechartap");
    }

    private Map<String, Integer> buildData(List<Long> perIds) {
        DynamicObject[] dys = EXTERNAL_SERVICE.queryEnableSex("id,name");
        List perInfoList = HRPI_SERVICE.listBatchPropPersonAttach(perIds, "person,gender", null, "hrpi_pernontsprop");
        if (CollectionUtils.isEmpty((Collection)perInfoList)) {
            return Maps.newHashMap();
        }
        HashMap genderGroupPerId = Maps.newHashMapWithExpectedSize((int)perIds.size());
        perInfoList.forEach(map -> {
            Long genderId = map.getOrDefault("gender", 0L);
            Long perId = map.getOrDefault("person", 0L);
            Map objectMap = (Map)genderGroupPerId.get(genderId);
            if (CollectionUtils.isEmpty((Map)objectMap)) {
                objectMap = Maps.newHashMap();
                genderGroupPerId.put(genderId, objectMap);
            }
            objectMap.put(perId, perId);
        });
        HashMap dataMap = Maps.newHashMap();
        Arrays.stream(dys).forEach(dy -> {
            long genderId = dy.getLong("id");
            String genderName = dy.getString("name");
            Map perIdMap = (Map)genderGroupPerId.get(genderId);
            if (!CollectionUtils.isEmpty((Map)perIdMap)) {
                long perIdNum = perIds.stream().filter(perId -> !Objects.isNull(perIdMap.get(perId))).count();
                dataMap.put(genderName, Integer.valueOf(String.valueOf(perIdNum)));
            }
        });
        return dataMap;
    }
}

