/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.analysis.card;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.formplugin.web.workbench.CardCommonPlugin;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;
import kd.tdc.tdcs.common.util.CommonUtils;

public class TalentPoolOverviewPlugin
extends CardCommonPlugin {
    private static final HrpiService HRPI_SERVICE = (HrpiService)ServiceFactory.getService(HrpiService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container container1 = (Container)this.getControl("talent_pool_link_flex");
        container1.addClickListener((ClickListener)this);
        Container container2 = (Container)this.getControl("reserve_talent_link_flex");
        container2.addClickListener((ClickListener)this);
    }

    @Override
    protected void initData() {
        String perIdStr;
        ArrayList perIds;
        List personInfo;
        String reserveTalentIdStr;
        ArrayList reserveTalentIds;
        ArrayList poolIds;
        boolean hasViewCardPerm = this.hasViewCardPerm();
        if (!hasViewCardPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"data_flex"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"no_view_flex"});
        IFormView parentView = this.getView().getParentView();
        IDataModel model = this.getModel();
        IPageCache parentPageCache = parentView.getPageCache();
        String poolIdsStr = parentPageCache.get("poolIds");
        List list = poolIds = HRStringUtils.isEmpty((String)poolIdsStr) ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)poolIdsStr);
        if (!CollectionUtils.isEmpty((Collection)poolIds)) {
            model.setValue("poolnum", (Object)String.valueOf(poolIds.size()));
            DynamicObject[] dys = TalentPoolQueryHelper.queryTalentPoolInfoByIds((String)"createtime", (List)poolIds);
            Date currDate = new Date();
            long createTime = Arrays.stream(dys).mapToLong(item -> CommonUtils.dayDiff((Date)item.getDate("createtime"), (Date)currDate)).sum();
            String avgCreateTime = CommonUtils.substringInteger((double)createTime, (int)poolIds.size());
            model.setValue("avgcreatetime", (Object)avgCreateTime);
        }
        List list2 = reserveTalentIds = HRStringUtils.isEmpty((String)(reserveTalentIdStr = parentPageCache.get("reserveTalentIds"))) ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)reserveTalentIdStr);
        if (!CollectionUtils.isEmpty((Collection)reserveTalentIds)) {
            model.setValue("talentnum", (Object)String.valueOf(reserveTalentIds.size()));
            DynamicObject[] dys = TalentPoolQueryHelper.queryReserveTalentByIds((String)"inpooltime", (List)reserveTalentIds);
            long inPoolTime = Arrays.stream(dys).mapToLong(item -> item.getInt("inpooltime")).sum();
            String avgInPoolTime = CommonUtils.substringInteger((double)inPoolTime, (int)reserveTalentIds.size());
            model.setValue("avginpooltime", (Object)avgInPoolTime);
        }
        if (!CollectionUtils.isEmpty((Collection)(personInfo = HRPI_SERVICE.listPersonInfo((List)(perIds = HRStringUtils.isEmpty((String)(perIdStr = parentPageCache.get("perIds"))) ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)perIdStr)))))) {
            Map<Long, Map> perIdInfoMapping = personInfo.stream().collect(Collectors.toMap(item -> Long.valueOf(item.get("person_id").toString()), item -> item, (v1, v2) -> v1));
            int age = perIds.stream().mapToInt(perId -> ((Map)perIdInfoMapping.get(perId)).getOrDefault("age", 0)).sum();
            double entServiceLen = perIds.stream().mapToDouble(perId -> ((Map)perIdInfoMapping.get(perId)).getOrDefault("entservicelen", new BigDecimal("0")).doubleValue()).sum();
            String avgAge = CommonUtils.substringInteger((int)age, (int)perIds.size());
            String aveServingAge = CommonUtils.substringInteger((double)entServiceLen, (int)perIds.size());
            model.setValue("avgage", (Object)avgAge);
            model.setValue("avgservingage", (Object)aveServingAge);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IFormView parentView = this.getView().getParentView();
        OperationResult operationResult = parentView.invokeOperation("refresh_grid_donothing");
        parentView.sendFormAction(parentView);
        if (!operationResult.isSuccess()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\u3002\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"APPWorkBenchPlugin_0", (String)"tdc-talp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("refresh_grid"));
            return;
        }
        if ("reserve_talent_link_flex".equals(key)) {
            this.hypLinkToPage("tdcs_reservetalent");
        } else if ("talent_pool_link_flex".equals(key)) {
            this.hypLinkToPage("tdcs_talentpool");
        }
    }

    private void hypLinkToPage(String formId) {
        ListShowParameter lsp = new ListShowParameter();
        MulBasedataDynamicObjectCollection value = (MulBasedataDynamicObjectCollection)this.getView().getParentView().getModel().getValue("talentpool");
        List<Object> poolIds = !CollectionUtils.isEmpty((Collection)value) ? value.stream().map(item -> item.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()) : Lists.newArrayList();
        lsp.setCustomParam("talentpool", (Object)SerializationUtils.serializeToBase64((Object)poolIds));
        DynamicObject org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        if (!Objects.isNull(org)) {
            lsp.setCustomParam("org", (Object)String.valueOf(org.getLong("id")));
        }
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setBillFormId(formId);
        this.getView().showForm((FormShowParameter)lsp);
    }
}

