/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.entryexitpool;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.talp.business.ServiceFactory;
import kd.tdc.talp.business.servicehelper.EntryExitPoolQueryHelper;
import kd.tdc.talp.business.servicehelper.FormBasicService;
import kd.tdc.talp.business.servicehelper.RecommendQueryHelper;
import kd.tdc.talp.common.constants.entryexitpool.EntryExitPoolConstant;
import kd.tdc.talp.common.enums.entryexitpool.EntryExitPoolStatusEnum;
import kd.tdc.talp.formplugin.formservice.TerminationBillService;
import kd.tdc.tdcs.bussiness.application.TalentPoolApplicationService;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;
import kd.tdc.tdcs.bussiness.queryhelper.TalentFileQueryHelper;
import kd.tdc.tdcs.enums.common.StatusStyleEnum;
import kd.tdc.tdcs.enums.talentpool.ApplyTypeEnum;
import kd.tdc.tdcs.enums.talentpool.InPoolStatusEnum;

public class EntryExitPoolBillEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
EntryExitPoolConstant {
    private static final Log LOG = LogFactory.getLog(EntryExitPoolBillEdit.class);
    private static final FormBasicService FORM_BASIC_SERVICE = (FormBasicService)ServiceFactory.getService(FormBasicService.class);
    private static final TerminationBillService TERMINATION_BILL_SERVICE = (TerminationBillService)((Object)ServiceFactory.getService(TerminationBillService.class));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit reserveTalent = (BasedataEdit)this.getControl("reservetalent");
        reserveTalent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject eve) {
        List recommendIds;
        Object reserveTalent;
        Object talentFile;
        super.afterCreateNewData(eve);
        BillShowParameter bsp = (BillShowParameter)this.getView().getFormShowParameter();
        String refresh = (String)bsp.getCustomParam("refresh");
        if (!Objects.isNull(refresh) && "true".equals(refresh)) {
            return;
        }
        bsp.setCustomParam("refresh", (Object)"true");
        IDataModel model = this.getModel();
        Object org = bsp.getCustomParam("org");
        Long orgId = Objects.isNull(org) ? RequestContext.get().getOrgId() : Long.parseLong(String.valueOf(org));
        if (!Objects.isNull(org)) {
            model.setValue("org", (Object)orgId);
        }
        if (!Objects.isNull(talentFile = bsp.getCustomParam("talentfile"))) {
            model.setValue("talentfile", talentFile);
            Map fileInfo = TalentFileQueryHelper.getFileInfo((Long)Long.parseLong(String.valueOf(talentFile)));
            this.buildPrimaryEmpInfo(model, Long.parseLong(String.valueOf(fileInfo.getOrDefault("employee", 0L))), Long.parseLong(String.valueOf(fileInfo.getOrDefault("person", 0L))));
        } else {
            Map fileInfo;
            Object employeeId = bsp.getCustomParam("employee");
            if (!Objects.isNull(employeeId) && !CollectionUtils.isEmpty((Map)(fileInfo = TalentFileQueryHelper.getFileInfoByEmpId((Long)Long.parseLong(String.valueOf(employeeId)), (Long)orgId)))) {
                this.buildPrimaryEmpInfo(model, Long.parseLong(String.valueOf(fileInfo.getOrDefault("employee", 0L))), Long.parseLong(String.valueOf(fileInfo.getOrDefault("person", 0L))));
            }
        }
        Object talentPool = bsp.getCustomParam("talentpool");
        if (!Objects.isNull(talentPool)) {
            model.setValue("talentpool", (Object)Long.parseLong(String.valueOf(talentPool)));
        }
        if (!Objects.isNull(reserveTalent = bsp.getCustomParam("reservetalent"))) {
            this.getModel().setValue("reservetalent", (Object)Long.parseLong(String.valueOf(reserveTalent)));
        }
        if (!CollectionUtils.isEmpty((Collection)(recommendIds = (List)bsp.getCustomParam("talentrecommend")))) {
            DynamicObject[] recommendBills = RecommendQueryHelper.queryOriginalBeRecommendedByIds((String)"id,recommendsource,recommendintopool,recommendemp,recommenddate,recommendreason", (List)recommendIds);
            int[] length = model.batchCreateNewEntryRow("entryentity", recommendBills.length);
            for (int i = 0; i < length.length; ++i) {
                model.setValue("recommendid", recommendBills[i].get("id"), i);
                model.setValue("recommendsource", recommendBills[i].get("recommendsource"), i);
                model.setValue("recommendintopool", recommendBills[i].get("recommendintopool"), i);
                model.setValue("recommendemp", recommendBills[i].get("recommendemp"), i);
                model.setValue("recommenddate", recommendBills[i].get("recommenddate"), i);
                model.setValue("recommendreason", recommendBills[i].get("recommendreason"), i);
            }
            if (recommendBills.length == 1) {
                model.setValue("intopoolreason", recommendBills[0].get("recommendreason"));
                model.setValue("intopooltype", recommendBills[0].get("recommendsource"));
            }
        }
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entryRow : entryRows) {
            entryRow.getDataEntityState().setBizChanged(true);
            entryRow.getDataEntityState().setDirty(true);
            entryRow.getDataEntityState().setPushChanged(true);
        }
    }

    protected void showInfoPanel(long employeeId, long personId) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        LOG.info("employeeId:{},personId:{}", (Object)employeeId, (Object)personId);
        this.buildPrimaryEmpInfo(model, employeeId, personId);
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        if (HRCollUtil.isEmpty((Collection)collection)) {
            view.setVisible(Boolean.FALSE, new String[]{"recommend_show_flex"});
        }
        FormShowParameter poolFsp = TalentPoolApplicationService.buildTalentPoolInfoFSP((String)"pool_info_flex", (Object)model.getValue("talentpool_id"));
        view.showForm(poolFsp);
        FormShowParameter perInfoFsp = TalentPoolApplicationService.buildPersonInfoFSP((String)"person_info_flex", (long)employeeId, (long)personId, (String)this.getView().getPageId());
        view.showForm(perInfoFsp);
    }

    protected void buildPrimaryEmpInfo(IDataModel model, Long employeeId, Long personId) {
        model.setValue("employee", (Object)employeeId);
        model.setValue("person", (Object)personId);
        Map primaryInfoMap = HrpiService.queryPrimaryEmpInfoByEmpId((Long)employeeId);
        if (!CollectionUtils.isEmpty((Map)primaryInfoMap)) {
            model.setValue("adminorg", primaryInfoMap.get("adminorg"));
            model.setValue("position", primaryInfoMap.get("position"));
            model.setValue("stdposition", primaryInfoMap.get("stdposition"));
            model.setValue("job", primaryInfoMap.get("job"));
        } else {
            FORM_BASIC_SERVICE.clearFiledValue(model, new String[]{"adminorg", "position", "stdposition", "job"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showPanel(null);
        Label status_label = (Label)this.getControl("status_label");
        EntryExitPoolStatusEnum statusEnum = EntryExitPoolStatusEnum.getEnumByStatus((String)((String)this.getModel().getValue("businessstatus")));
        if (!Objects.isNull(statusEnum)) {
            status_label.setText(statusEnum.getDesc());
            Map customStyles = StatusStyleEnum.buildStyleMap((StatusStyleEnum)statusEnum.getStyleEnum(), (int)1, null);
            this.getView().updateControlMetadata("status_label", customStyles);
        }
    }

    protected void showPanel(String changeFieldName) {
    }

    public void rebuildRecommendInfo(DynamicObjectCollection recommendInfoEntity) {
        boolean isEmpty = CollectionUtils.isEmpty((Collection)recommendInfoEntity);
        if (!isEmpty) {
            List<Long> ids = recommendInfoEntity.stream().map(item -> item.getLong("recommendid")).collect(Collectors.toList());
            this.showRecommendPanel(ids);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"recommend_show_flex"});
        }
    }

    public void showRecommendPanel(List<Long> recommendIds) {
        if (CollectionUtils.isEmpty(recommendIds)) {
            DynamicObjectCollection collection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)collection)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"recommend_show_flex"});
                return;
            }
            List ids = collection.stream().map(item -> item.getLong("recommendid")).collect(Collectors.toList());
            recommendIds.addAll(ids);
        }
        HashMap customParams = Maps.newHashMap();
        customParams.put("id", recommendIds);
        FormShowParameter fsp = TalentPoolApplicationService.buildRecommendInfoFSP((String)"recommend_show_flex", (Map)customParams);
        this.getView().showForm(fsp);
        this.getView().setVisible(Boolean.TRUE, new String[]{"recommend_show_flex"});
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = ((Control)event.getSource()).getKey();
        if ("reservetalent".equals(fieldKey)) {
            ListShowParameter lsp = (ListShowParameter)event.getFormShowParameter();
            lsp.setFormId("bos_listf7");
            event.addCustomQFilter(new QFilter("inpoolstatus", "=", (Object)InPoolStatusEnum.IN_POOL.getStatus()));
            DynamicObject talentPool = (DynamicObject)this.getModel().getValue("talentpool");
            if (!Objects.isNull(talentPool)) {
                long poolId = talentPool.getLong("id");
                event.addCustomQFilter(new QFilter("talentpool", "=", (Object)poolId));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("terminate".equals(operateKey)) {
            TERMINATION_BILL_SERVICE.callValidatorBeforeDoOperation(args, (AbstractBillPlugIn)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("terminate".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        } else if (("save".equals(operateKey) || "submit".equals(operateKey) || "submiteffect".equals(operateKey)) && operationResult.isSuccess()) {
            this.updateFormTitle();
            this.getView().updateView();
        }
    }

    private void updateFormTitle() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject dy = dataEntity.getDynamicObject("person");
        if (!Objects.isNull(dy)) {
            String descByStatus = ApplyTypeEnum.getDescByStatus((String)dataEntity.getString("applytype"));
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"{0}-{1}", (String)"EntryExitPoolBillEdit_0", (String)"tdc-talp-formplugin", (Object[])new Object[]{descByStatus, dy.getString("name")})));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (!Objects.isNull(returnData) && "terminate".equals(actionId)) {
            TERMINATION_BILL_SERVICE.doOperationClosedCallBack(returnData, actionId, (AbstractBillPlugIn)this);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        DynamicObject bill;
        super.preOpenForm(args);
        BillShowParameter fsp = (BillShowParameter)args.getFormShowParameter();
        Object pkId = fsp.getPkId();
        if (!Objects.isNull(pkId) && !Objects.isNull(bill = EntryExitPoolQueryHelper.queryOriginalOneByIds((String)"applyType,person.name", (Object)pkId))) {
            String descByStatus = ApplyTypeEnum.getDescByStatus((String)bill.getString("applytype"));
            fsp.setCaption(ResManager.loadKDString((String)"{0}-{1}", (String)"EntryExitPoolBillEdit_0", (String)"tdc-talp-formplugin", (Object[])new Object[]{descByStatus, bill.getString("person.name")}));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        FORM_BASIC_SERVICE.setPropertyNotDataChanged(this.getModel(), new String[]{"applytype", "person", "employee", "adminorg", "position", "stdposition", "job"});
    }
}

