/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.entryexitpool;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tdc.talp.business.ServiceFactory;
import kd.tdc.talp.business.application.service.EntryExitPoolApplicationService;
import kd.tdc.talp.business.servicehelper.EntryExitPoolQueryHelper;
import kd.tdc.talp.business.servicehelper.FormBasicService;
import kd.tdc.talp.common.enums.entryexitpool.EntryExitPoolStatusEnum;
import kd.tdc.talp.formplugin.formservice.TerminationBillService;
import kd.tdc.tdcs.enums.talentpool.ApplyTypeEnum;

public class EntryExitPoolBillList
extends HRDataBaseList {
    private static final EntryExitPoolApplicationService ENTRY_EXIT_POOL_SERVICE = (EntryExitPoolApplicationService)ServiceFactory.getService(EntryExitPoolApplicationService.class);
    private static final FormBasicService FORM_BASIC_SERVICE = (FormBasicService)ServiceFactory.getService(FormBasicService.class);
    private static final TerminationBillService TERMINATION_BILL_SERVICE = (TerminationBillService)((Object)ServiceFactory.getService(TerminationBillService.class));

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        FORM_BASIC_SERVICE.beforeCreateListColumns(args, "person.number");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter fsp = (ListShowParameter)this.getView().getFormShowParameter();
        Map params = fsp.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)params)) {
            Object formId = params.get("formId");
            Object isFirstLoad = params.get("isFirstLoad");
            if (!Objects.isNull(formId) && "tdcs_reservetalent".equals(formId) && "true".equals(isFirstLoad)) {
                List commonFilterColumns = args.getCommonFilterColumns();
                commonFilterColumns.forEach(item -> {
                    Object nodeIds;
                    String fieldName = item.getFieldName();
                    if (fieldName.equals("businessstatus")) {
                        item.setDefaultValue((String)params.get("status"));
                    } else if (fieldName.equals("talentpool.name") && !Objects.isNull(nodeIds = params.get("nodeIds"))) {
                        List nodeIdsArr = (List)SerializationUtils.fromJsonString((String)nodeIds.toString(), List.class);
                        item.setDefaultValues(nodeIdsArr.stream().map(Object::toString).toArray());
                    }
                });
                params.put("isFirstLoad", "false");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"terminate")) {
            TERMINATION_BILL_SERVICE.callValidatorBeforeDoOperation(args, operateKey, (AbstractFormPlugin)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        BillShowParameter bsp;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (!Objects.isNull(args.getOperationResult()) && args.getOperationResult().isSuccess() && !Objects.isNull(bsp = ENTRY_EXIT_POOL_SERVICE.buildFormShowParameter(operateKey))) {
            bsp.setCustomParam("formId", (Object)"talp_entryexitpoolbase");
            bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            this.getView().showForm((FormShowParameter)bsp);
        }
        if ("terminate".equals(operateKey)) {
            TERMINATION_BILL_SERVICE.refreshAfterDoOperation(args, (AbstractFormPlugin)this);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if ("person_name".equals(fieldName)) {
            args.setCancel(true);
            Object focusRowPkId = this.getFocusRowPkId();
            DynamicObject bill = EntryExitPoolQueryHelper.queryOriginalOneByIds((String)"id,applytype,businessstatus", (Object)focusRowPkId);
            BillShowParameter bsp = new BillShowParameter();
            bsp.setCustomParam("formId", (Object)"talp_entryexitpoolbase");
            bsp.setPkId(bill.get("id"));
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String applyType = bill.getString("applytype");
            if (ApplyTypeEnum.IN_POOL_PAGE.getStatus().equals(applyType)) {
                bsp.setFormId("talp_entrypoolbill");
            } else {
                bsp.setFormId("talp_exitpoolbill");
            }
            String businessStatus = bill.getString("businessstatus");
            if (EntryExitPoolStatusEnum.isBeSubmitStatus((String)businessStatus)) {
                bsp.setStatus(OperationStatus.EDIT);
            } else {
                bsp.setStatus(OperationStatus.VIEW);
            }
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (!Objects.isNull(returnData) && "terminate".equals(actionId)) {
            TERMINATION_BILL_SERVICE.doOperationClosedCallBack(returnData, actionId, (AbstractFormPlugin)this);
        }
    }
}

