/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.entryexitpool;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.business.servicehelper.FormBasicService;
import kd.tdc.talp.common.enums.entryexitpool.EntryExitPoolStatusEnum;
import kd.tdc.talp.formplugin.web.entryexitpool.EntryExitPoolBillEdit;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.TalentPoolApplicationService;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;

public class EntryPoolBillEdit
extends EntryExitPoolBillEdit {
    private static final FormBasicService FORM_BASIC_SERVICE = (FormBasicService)kd.tdc.talp.business.ServiceFactory.getService(FormBasicService.class);
    private static final HrpiService HRPI_SERVICE = (HrpiService)ServiceFactory.getService(HrpiService.class);
    private static final Log LOG = LogFactory.getLog(EntryPoolBillEdit.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supervisor = (BasedataEdit)this.getControl("supervisor");
        supervisor.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit talentFile = (BasedataEdit)this.getControl("talentfile");
        talentFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void showPanel(String changeFieldName) {
        IDataModel model = this.getModel();
        boolean orgIsNull = Objects.isNull(model.getValue("org"));
        DynamicObject talentFile = (DynamicObject)model.getValue("talentfile");
        boolean talentPoolIsNull = Objects.isNull(model.getValue("talentpool"));
        boolean talentFileIsNull = Objects.isNull(talentFile);
        boolean hiddenContentPanel = orgIsNull || talentFileIsNull || talentPoolIsNull;
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(!hiddenContentPanel), new String[]{"contentpanel"});
        view.setVisible(Boolean.valueOf(hiddenContentPanel), new String[]{"empty_panel"});
        view.setEnable(Boolean.valueOf(!orgIsNull), new String[]{"talentpool", "talentfile"});
        if (HRStringUtils.isNotEmpty((String)changeFieldName)) {
            this.clearFieldValue();
            this.getModel().deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
            view.setVisible(Boolean.FALSE, new String[]{"recommend_show_flex"});
        }
        BillShowParameter bsp = (BillShowParameter)this.getView().getFormShowParameter();
        if (orgIsNull || "talp_entryexitpoolbase".equals(bsp.getCustomParam("formId"))) {
            this.getPageCache().put("checkEnable", "false");
        } else {
            String checkEnable = this.getPageCache().get("checkEnable");
            if (!"false".equals(checkEnable)) {
                String checkPoolEnable;
                String checkFileEnable = this.getPageCache().get("checkFileEnable");
                if (!"false".equals(checkFileEnable)) {
                    if (!talentFileIsNull) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"org", "talentfile"});
                    }
                    if (HRStringUtils.isEmpty((String)checkFileEnable)) {
                        this.getPageCache().put("checkFileEnable", String.valueOf(!talentFileIsNull));
                    }
                }
                if (!"false".equals(checkPoolEnable = this.getPageCache().get("checkPoolEnable"))) {
                    if (!talentPoolIsNull) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"org", "talentpool"});
                    }
                    if (HRStringUtils.isEmpty((String)checkPoolEnable)) {
                        this.getPageCache().put("checkPoolEnable", String.valueOf(!talentPoolIsNull));
                    }
                }
            }
        }
        if (hiddenContentPanel) {
            return;
        }
        this.showIntoPoolPanel();
        this.showInfoPanel(talentFile.getLong("employee_id"), talentFile.getLong("person_id"));
        LOG.info("person_id:{},person.id:{}", talentFile.get("person_id"), talentFile.get("person.id"));
        this.rebuildRecommendInfo(this.getModel().getEntryEntity("entryentity"));
    }

    private void clearFieldValue() {
        FORM_BASIC_SERVICE.clearFiledValue(this.getModel(), new String[]{"intopooldate", "intopoolreason", "intopooltype", "currmatchdegree", "targetcompetency", "supervisor"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        List attachments = attachmentPanel.getAttachmentData();
        for (Map attachment : attachments) {
            attachmentPanel.remove(attachment);
        }
    }

    private void showIntoPoolPanel() {
        IDataModel model = this.getModel();
        String businessStatus = (String)model.getValue("businessstatus");
        boolean beSubmitStatus = EntryExitPoolStatusEnum.isBeSubmitStatus((String)businessStatus);
        if (!beSubmitStatus) {
            DynamicObject reserveTalent;
            DynamicObject dataEntity = model.getDataEntity();
            HashMap customParams = Maps.newHashMap();
            String billNo = dataEntity.getString("billno");
            customParams.put("billno", billNo);
            customParams.put("talentpool", dataEntity.get("talentpool_id"));
            customParams.put("intopooldate", dataEntity.getDate("intopooldate"));
            customParams.put("targetcompetency", dataEntity.get("targetcompetency_id"));
            customParams.put("currmatchdegree", dataEntity.get("currmatchdegree_id"));
            customParams.put("intopooltype", dataEntity.get("intopooltype_id"));
            customParams.put("intopoolreason", dataEntity.getString("intopoolreason"));
            customParams.put("talp_entrypoolbill", "true");
            DynamicObject supervisor = dataEntity.getDynamicObject("supervisor");
            if (!Objects.isNull(supervisor)) {
                customParams.put("supervisor", supervisor.getPkValue());
            }
            if (!Objects.isNull(reserveTalent = TalentPoolQueryHelper.queryReserveTalentByIntoBillNo((String)billNo))) {
                customParams.put("inpooltime", reserveTalent.get("inpooltime"));
            }
            FormShowParameter fsp = TalentPoolApplicationService.buildInPoolInfoFSP((String)"in_pool_info_show", (Map)customParams);
            this.getView().showForm(fsp);
        }
        this.getView().setVisible(Boolean.valueOf(!beSubmitStatus), new String[]{"in_pool_info_show"});
        this.getView().setVisible(Boolean.valueOf(beSubmitStatus), new String[]{"inpoolinfoflex"});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Date intoPoolDate;
        String name;
        super.propertyChanged(args);
        switch (name = args.getProperty().getName()) {
            case "talentfile": 
            case "talentpool": 
            case "org": {
                this.showPanel(name);
                break;
            }
        }
        if ("intopooldate".equals(name) && !Objects.isNull(intoPoolDate = (Date)args.getChangeSet()[0].getNewValue())) {
            Date startDate;
            long talentPoolId = this.getModel().getDataEntity().getLong("talentpool_id");
            long empId = this.getModel().getDataEntity().getLong("employee_id");
            DynamicObject talentPool = TalentPoolQueryHelper.queryTalentPoolById((String)"createpooldate", (Long)talentPoolId);
            Date createPoolDate = talentPool.getDate("createpooldate");
            if (!Objects.isNull(createPoolDate) && intoPoolDate.compareTo(HRDateTimeUtils.truncateDate((Date)createPoolDate)) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4eba\u5458\u5165\u6c60\u65e5\u671f\u4e0d\u53ef\u65e9\u4e8e\u6240\u9009\u50a8\u5907\u6c60\u7684\u5efa\u6c60\u65e5\u671f \u201c{0}\u201d", (String)"EntryPoolBillEdit_0", (String)"tdc-talp-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)createPoolDate, (String)"yyyy-MM-dd")}));
                this.getModel().setValue("intopooldate", null);
                return;
            }
            Map empInfo = HRPI_SERVICE.getEmployee(Long.valueOf(empId));
            if (!CollectionUtils.isEmpty((Map)empInfo) && !Objects.isNull(startDate = (Date)empInfo.get("startdate")) && intoPoolDate.compareTo(startDate) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4eba\u5458\u5165\u6c60\u65e5\u671f\u4e0d\u53ef\u65e9\u4e8e\u5176\u5165\u804c\u65e5\u671f \u201c{0}\u201d", (String)"EntryPoolBillEdit_1", (String)"tdc-talp-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd")}));
                this.getModel().setValue("intopooldate", null);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String filedName = event.getProperty().getName();
        if (HRStringUtils.equals((String)filedName, (String)"supervisor")) {
            DynamicObject person = (DynamicObject)this.getModel().getValue("person");
            if (person == null) {
                return;
            }
            long person_id = person.getLong("id");
            HashMap idMaps = new HashMap(1);
            ArrayList<Long> pids = new ArrayList<Long>();
            pids.add(person_id);
            idMaps.put("person", pids);
            Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
            if (CollectionUtils.isEmpty((Map)result) || !((Boolean)result.get("success")).booleanValue()) {
                return;
            }
            Map map = (Map)result.get("data");
            if (CollectionUtils.isEmpty((Map)map) || ObjectUtils.isEmpty(map.get(person_id))) {
                return;
            }
            Map infoMap = (Map)map.get(person_id);
            if (CollectionUtils.isEmpty((Map)infoMap)) {
                return;
            }
            Long user = (Long)infoMap.get("user");
            QFilter qFilter = new QFilter("id", "!=", (Object)user);
            event.addCustomQFilter(qFilter);
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        FORM_BASIC_SERVICE.setPropertyNotDataChanged(this.getModel(), new String[]{"reservetalent"});
    }
}

