/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.entryexitpool;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.talp.business.servicehelper.FormBasicService;
import kd.tdc.talp.common.enums.entryexitpool.EntryExitPoolStatusEnum;
import kd.tdc.talp.formplugin.web.entryexitpool.EntryExitPoolBillEdit;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.TalentPoolApplicationService;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;

public class ExitPoolBillEdit
extends EntryExitPoolBillEdit {
    private static final FormBasicService FORM_BASIC_SERVICE = (FormBasicService)kd.tdc.talp.business.ServiceFactory.getService(FormBasicService.class);
    private static final HrpiService HRPI_SERVICE = (HrpiService)ServiceFactory.getService(HrpiService.class);

    @Override
    public void showPanel(String changeFieldName) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        boolean orgIsNull = Objects.isNull(model.getValue("org"));
        DynamicObject reserveTalent = (DynamicObject)model.getValue("reservetalent");
        boolean reserveTalentIsNull = Objects.isNull(reserveTalent);
        boolean talentPoolIsNull = Objects.isNull(model.getValue("talentpool"));
        boolean hiddenContentPanel = orgIsNull || reserveTalentIsNull || talentPoolIsNull;
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(!hiddenContentPanel), new String[]{"contentpanel"});
        view.setVisible(Boolean.valueOf(hiddenContentPanel), new String[]{"empty_panel"});
        view.setEnable(Boolean.valueOf(!orgIsNull), new String[]{"talentpool"});
        view.setEnable(Boolean.valueOf(!talentPoolIsNull), new String[]{"reservetalent"});
        if ("talentpool".equals(changeFieldName)) {
            model.setValue("reservetalent", null);
            reserveTalentIsNull = true;
            hiddenContentPanel = true;
        }
        if (HRStringUtils.isNotEmpty((String)changeFieldName)) {
            this.clearFieldValue();
        }
        if (hiddenContentPanel) {
            return;
        }
        this.showIntoPoolPanel();
        this.showOutOfPoolPanel();
        model.setValue("talentfile", (Object)dataEntity.getLong("reservetalent.talentfile_id"));
        DateEdit outOfPoolDateEdit = (DateEdit)this.getControl("outofpooldate");
        Date createPoolDate = this.getModel().getDataEntity().getDynamicObject("reservetalent").getDate("intopooldate");
        if (!Objects.isNull(createPoolDate)) {
            outOfPoolDateEdit.setMinDate(createPoolDate);
        }
        this.showInfoPanel(reserveTalent.getLong("employee_id"), reserveTalent.getLong("person_id"));
        this.rebuildRecommendInfo(reserveTalent.getDynamicObjectCollection("entryentity"));
        BillShowParameter bsp = (BillShowParameter)this.getView().getFormShowParameter();
        Map params = bsp.getCustomParams();
        if (!Objects.isNull(params.get("talentpool")) && !Objects.isNull(params.get("reservetalent"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", "talentpool", "reservetalent"});
        }
    }

    private void clearFieldValue() {
        FORM_BASIC_SERVICE.clearFiledValue(this.getModel(), new String[]{"outofpooldate", "outofpooltype", "outofpoolreason"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("outpoolattachmentpanel");
        List attachments = attachmentPanel.getAttachmentData();
        for (Map attachment : attachments) {
            attachmentPanel.remove(attachment);
        }
    }

    private void showIntoPoolPanel() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        HashMap customParams = Maps.newHashMap();
        Long reserveTalentId = dataEntity.getLong("reservetalent_id");
        DynamicObject bill = TalentPoolQueryHelper.queryOneReserveTalentById((String)"id,inpooltime,intopooltype,intobillno,group,talentpool,intopooldate,intopoolreason,targetcompetency,currmatchdegree,supervisor", (Object)reserveTalentId);
        if (!Objects.isNull(bill)) {
            customParams.put("billno", bill.getString("intobillno"));
            customParams.put("inpooltime", bill.get("inpooltime"));
            customParams.put("talentpool", bill.get("talentpool"));
            customParams.put("intopooltype", bill.get("intopooltype"));
            customParams.put("intopooldate", bill.getDate("intopooldate"));
            customParams.put("intopoolreason", bill.getString("intopoolreason"));
            customParams.put("targetcompetency", bill.get("targetcompetency"));
            customParams.put("currmatchdegree", bill.get("currmatchdegree"));
            customParams.put("supervisor", bill.get("supervisor"));
            model.setValue("intopooltype", bill.get("intopooltype"));
            model.setValue("intopooldate", bill.get("intopooldate"));
            model.setValue("intopoolreason", bill.get("intopoolreason"));
            model.setValue("targetcompetency", bill.get("targetcompetency"));
            model.setValue("currmatchdegree", bill.get("currmatchdegree"));
            model.setValue("supervisor", bill.get("supervisor"));
        }
        FormShowParameter fsp = TalentPoolApplicationService.buildInPoolInfoFSP((String)"in_pool_info_show", (Map)customParams);
        this.getView().showForm(fsp);
    }

    private void showOutOfPoolPanel() {
        IDataModel model = this.getModel();
        String businessStatus = (String)model.getValue("businessstatus");
        boolean beSubmitStatus = EntryExitPoolStatusEnum.isBeSubmitStatus((String)businessStatus);
        this.getView().setVisible(Boolean.valueOf(!beSubmitStatus), new String[]{"out_pool_info_show"});
        this.getView().setVisible(Boolean.valueOf(beSubmitStatus), new String[]{"outpoolinfoflex"});
        if (!beSubmitStatus) {
            HashMap customParams = Maps.newHashMap();
            DynamicObject dataEntity = model.getDataEntity();
            customParams.put("billno", dataEntity.getString("billno"));
            customParams.put("outofpooltype", dataEntity.get("outofpooltype_id"));
            customParams.put("outofpoolreason", dataEntity.getString("outofpoolreason"));
            customParams.put("outofpooldate", dataEntity.getDate("outofpooldate"));
            customParams.put("talp_exitpoolbill", "true");
            FormShowParameter fsp = TalentPoolApplicationService.buildOutPoolInfoFSP((String)"out_pool_info_show", (Map)customParams);
            this.getView().showForm(fsp);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Date startDate;
        long empId;
        Map empInfo;
        Date outOfPoolDate;
        String name;
        super.propertyChanged(args);
        switch (name = args.getProperty().getName()) {
            case "reservetalent": 
            case "talentpool": 
            case "org": {
                this.showPanel(name);
                break;
            }
        }
        if ("outofpooldate".equals(name) && !Objects.isNull(outOfPoolDate = (Date)args.getChangeSet()[0].getNewValue()) && !CollectionUtils.isEmpty((Map)(empInfo = HRPI_SERVICE.getEmployee(Long.valueOf(empId = this.getModel().getDataEntity().getLong("employee_id"))))) && !Objects.isNull(startDate = (Date)empInfo.get("startdate")) && outOfPoolDate.compareTo(startDate) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4eba\u5458\u51fa\u6c60\u65e5\u671f\u4e0d\u53ef\u65e9\u4e8e\u5176\u5165\u804c\u65e5\u671f \u201c{0}\u201d", (String)"ExitPoolBillEdit_0", (String)"tdc-talp-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd")}));
            this.getModel().setValue("outofpooldate", null);
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        FORM_BASIC_SERVICE.setPropertyNotDataChanged(this.getModel(), new String[]{"talentfile", "intopooldate", "intopooltype", "intopoolreason", "targetcompetency", "currmatchdegree", "supervisor"});
    }
}

