/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.recommend;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tdc.talp.business.ServiceFactory;
import kd.tdc.talp.business.application.service.EntryExitPoolApplicationService;
import kd.tdc.talp.business.servicehelper.FormBasicService;
import kd.tdc.talp.business.servicehelper.RecommendQueryHelper;
import kd.tdc.talp.common.enums.recommend.HandleStatusEnum;
import kd.tdc.talp.common.enums.recommend.RecommendStatusEnum;
import kd.tdc.talp.formplugin.formservice.PendingRecommendService;

public class PendingRecommendList
extends HRDataBaseList {
    private static final PendingRecommendService PENDING_RECOMMEND_SERVICE = (PendingRecommendService)((Object)ServiceFactory.getService(PendingRecommendService.class));
    private static final EntryExitPoolApplicationService ENTRY_EXIT_SERVICE = (EntryExitPoolApplicationService)ServiceFactory.getService(EntryExitPoolApplicationService.class);
    private static final FormBasicService FORM_BASIC_SERVICE = (FormBasicService)ServiceFactory.getService(FormBasicService.class);

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        if (event.getSource() instanceof ListOperationColumnDesc && event.getRowData().containsProperty("handlestatus")) {
            List operationColItems = (List)event.getFormatValue();
            String handleStatus = event.getRowData().getString("handlestatus");
            boolean isBeHandleStatus = HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.BE_HANDLE.getStatus());
            operationColItems.stream().filter(opItem -> "new_entry".equals(opItem.getOperationKey()) || "ignore".equals(opItem.getOperationKey())).forEach(opItem -> opItem.setVisible(isBeHandleStatus));
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.getQFilters().add(new QFilter("recommendstatus", "=", (Object)RecommendStatusEnum.RECOMMENDED.getStatus()));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        FORM_BASIC_SERVICE.beforeCreateListColumns(args, "person.number");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData;
        Set orgSet;
        boolean hasExitPoolPerm;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("batch_entry".equals(operateKey) && (hasExitPoolPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"3=0WAUGB+EOW", (String)"talp_pendingrecommend", (String)"37LT8JOUT1XW")) && !CollectionUtils.isEmpty(orgSet = (listSelectedData = args.getListSelectedData()).stream().map(ListSelectedRow::getMainOrgId).collect(Collectors.toSet())) && orgSet.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u53d1\u8d77\u51fa\u6c60\u3002\u5f53\u524d\u6240\u9009\u62e9\u4eba\u5458\u7684\u6240\u5728\u50a8\u5907\u6c60\u4e0d\u662f\u540c\u4e00\u4e2a\u4eba\u624d\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"PendingRecommendList_0", (String)"tdc-talp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("batch_entry".equals(operateKey) || "batch_ignore".equals(operateKey)) {
            PENDING_RECOMMEND_SERVICE.callValidatorBeforeDoOperation(args, operateKey, (AbstractFormPlugin)this);
        }
        if ("ignore".equals(operateKey) || "new_entry".equals(operateKey)) {
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            selectedRows.clear();
            selectedRows.add((Object)operate.getListFocusRow());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        BillShowParameter bsp = ENTRY_EXIT_SERVICE.buildFormShowParameter(operateKey);
        if (!Objects.isNull(bsp) && args.getOperationResult().isSuccess()) {
            bsp.setCustomParam("formId", (Object)"talp_pendingrecommend");
            bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            List successPkIds = args.getOperationResult().getSuccessPkIds();
            DynamicObject[] recommendBills = RecommendQueryHelper.queryOriginalBeRecommendedByIds((String)"id,org,recommendintopool,talentfile", successPkIds.stream().map(item -> Long.parseLong(String.valueOf(item))).collect(Collectors.toList()));
            if ("batch_entry".equals(operateKey)) {
                ArrayList talentList = Lists.newArrayListWithExpectedSize((int)successPkIds.size());
                Arrays.stream(recommendBills).forEach(recommendBill -> {
                    HashMap talentMap = Maps.newHashMap();
                    talentMap.put("talentpool", recommendBill.getLong("recommendintopool"));
                    talentMap.put("talentfile", recommendBill.getLong("talentfile"));
                    talentMap.put("id", recommendBill.getLong("id"));
                    talentList.add(talentMap);
                });
                bsp.setCustomParam("person", (Object)talentList);
            }
            if ("new_entry".equals(operateKey)) {
                bsp.setCustomParam("talentpool", (Object)recommendBills[0].getLong("recommendintopool"));
                bsp.setCustomParam("talentfile", (Object)recommendBills[0].getLong("talentfile"));
                bsp.setCustomParam("talentrecommend", (Object)Lists.newArrayList((Object[])new Long[]{recommendBills[0].getLong("id")}));
            }
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "new_entry": 
            case "batch_entry": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
        if (!Objects.isNull(returnData) && ("batch_entry".equals(actionId) || "batch_ignore".equals(actionId))) {
            PENDING_RECOMMEND_SERVICE.doOperationClosedCallBack(returnData, actionId, (AbstractFormPlugin)this);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (HRStringUtils.equals((String)callBackId, (String)"batch_ignore") && result.equals((Object)MessageBoxResult.Yes)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isopcancel", "0");
            this.getView().invokeOperation("batch_ignore", option);
        }
    }
}

