/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.talp.formplugin.web.recommend;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.talp.business.ServiceFactory;
import kd.tdc.talp.business.servicehelper.FormBasicService;
import kd.tdc.talp.common.constants.recommend.RecommendConstants;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;
import kd.tdc.tdcs.bussiness.queryhelper.TalentFileQueryHelper;

public class RecommendBasicEdit
extends HRDataBaseEdit
implements RecommendConstants {
    private static final FormBasicService FORM_BASIC_SERVICE = (FormBasicService)ServiceFactory.getService(FormBasicService.class);

    public void afterCreateNewData(EventObject event) {
        Object recommendSource;
        Object talentFile;
        super.afterCreateNewData(event);
        BillShowParameter bsp = (BillShowParameter)this.getView().getFormShowParameter();
        String refresh = (String)bsp.getCustomParam("refresh");
        if (!Objects.isNull(refresh) && "true".equals(refresh)) {
            return;
        }
        bsp.setCustomParam("refresh", (Object)"true");
        IDataModel model = this.getModel();
        Object org = bsp.getCustomParam("org");
        Long orgId = Objects.isNull(org) ? RequestContext.get().getOrgId() : Long.parseLong(String.valueOf(org));
        if (!Objects.isNull(org)) {
            model.setValue("org", (Object)orgId);
        }
        if (!Objects.isNull(talentFile = bsp.getCustomParam("talentfile"))) {
            model.setValue("talentfile", talentFile);
            Map fileInfo = TalentFileQueryHelper.getFileInfo((Long)Long.parseLong(String.valueOf(talentFile)));
            this.buildPrimaryEmpInfo(model, Long.parseLong(String.valueOf(fileInfo.getOrDefault("employee", 0L))), Long.parseLong(String.valueOf(fileInfo.getOrDefault("person", 0L))));
        } else {
            Map fileInfo;
            Object employeeId = bsp.getCustomParam("employee");
            if (!Objects.isNull(employeeId) && !CollectionUtils.isEmpty((Map)(fileInfo = TalentFileQueryHelper.getFileInfoByEmpId((Long)Long.parseLong(String.valueOf(employeeId)), (Long)orgId)))) {
                this.buildPrimaryEmpInfo(model, Long.parseLong(String.valueOf(fileInfo.getOrDefault("employee", 0L))), Long.parseLong(String.valueOf(fileInfo.getOrDefault("person", 0L))));
            }
        }
        Object talentPool = bsp.getCustomParam("talentpool");
        if (!Objects.isNull(talentPool)) {
            model.setValue("recommendintopool", (Object)Long.parseLong(String.valueOf(talentPool)));
        }
        if (!Objects.isNull(recommendSource = bsp.getCustomParam("recommendsource"))) {
            model.setValue("recommendsource", (Object)Long.parseLong(String.valueOf(recommendSource)));
        }
        this.setDefaultReferrer();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)"talentfile")) {
            Object newValue = args.getChangeSet()[0].getNewValue();
            IDataModel model = this.getModel();
            if (!Objects.isNull(newValue)) {
                DynamicObject dataEntity = model.getDataEntity();
                this.buildPrimaryEmpInfo(model, dataEntity.getLong("talentfile.employee_id"), dataEntity.getLong("talentfile.person_id"));
            } else {
                FORM_BASIC_SERVICE.clearFiledValue(model, new String[]{"person", "employee", "adminorg", "position", "stdposition", "job"});
            }
        }
    }

    protected void buildPrimaryEmpInfo(IDataModel model, Long employeeId, Long personId) {
        model.setValue("employee", (Object)employeeId);
        model.setValue("person", (Object)personId);
        Map primaryInfoMap = HrpiService.queryPrimaryEmpInfoByEmpId((Long)employeeId);
        if (!CollectionUtils.isEmpty((Map)primaryInfoMap)) {
            model.setValue("adminorg", primaryInfoMap.get("adminorg"));
            model.setValue("position", primaryInfoMap.get("position"));
            model.setValue("stdposition", primaryInfoMap.get("stdposition"));
            model.setValue("job", primaryInfoMap.get("job"));
        } else {
            FORM_BASIC_SERVICE.clearFiledValue(model, new String[]{"adminorg", "position", "stdposition", "job"});
        }
    }

    private void setDefaultReferrer() {
        Object value = this.getModel().getValue("recommendemp");
        if (Objects.isNull(value)) {
            this.getModel().setValue("recommendemp", (Object)RequestContext.get().getCurrUserId());
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        FORM_BASIC_SERVICE.setPropertyNotDataChanged(this.getModel(), new String[]{"person", "employee", "adminorg", "position", "stdposition", "job"});
    }
}

