/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.opplugin.validator;

import java.text.MessageFormat;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class TDCBaseDataImportValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        OperateOption option = this.validateContext.getOption();
        String isFromImport = (String)option.getVariables().get("importtag_of_datasource");
        if (!"true".equals(isFromImport)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DataEntityPropertyCollection propertyCollection = dataEntity.getDataEntity().getDataEntityType().getProperties();
            for (IDataEntityProperty property : propertyCollection) {
                boolean isShowUsed;
                Object object;
                if (property.getPropertyType() != DynamicObject.class || (object = dataEntity.getValue(property.getName())) == null) continue;
                if (object instanceof DynamicObject) {
                    isShowUsed = ((BasedataProp)property).isShowUsed();
                    this.singleDyObjectCheck((DynamicObject)object, isShowUsed, dataEntity, property);
                    continue;
                }
                if (!(object instanceof MulBasedataDynamicObjectCollection)) continue;
                isShowUsed = ((MulBasedataProp)property).isShowUsed();
                for (DynamicObject dyObject : (DynamicObjectCollection)object) {
                    this.singleDyObjectCheck(dyObject.getDynamicObject("fbasedataid"), isShowUsed, dataEntity, property);
                }
            }
        }
    }

    private void singleDyObjectCheck(DynamicObject object, boolean isShowUsed, ExtendedDataEntity dataEntity, IDataEntityProperty property) {
        DynamicProperty enableProp = object.getDynamicObjectType().getProperty("enable");
        DynamicProperty statusProp = object.getDynamicObjectType().getProperty("status");
        if (enableProp != null && isShowUsed && !"1".equals(object.getString("enable"))) {
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"{0}\u975e\u542f\u7528\u6570\u636e\u65e0\u6cd5\u88ab\u9009\u4e2d\u3002", (String)"TDCBaseDataImportValidator_0", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]), property.getName()));
        }
        if (statusProp != null && !"C".equals(object.getString("status"))) {
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"{0}\u975e\u5ba1\u6838\u6570\u636e\u65e0\u6cd5\u88ab\u9009\u4e2d\u3002", (String)"TDCBaseDataImportValidator_1", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]), property.getName()));
        }
    }
}

