/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.opplugin.validator.commorg;

import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.CommFrameApplicationService;

public class CommOrgSaveValidator
extends HRDataBaseValidator {
    private final CommFrameApplicationService commFrameApplicationService = (CommFrameApplicationService)ServiceFactory.getService(CommFrameApplicationService.class);

    public void validate() {
        super.validate();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject frame;
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObjectCollection certEntry = entity.getDynamicObjectCollection("jobscmentry");
            if (CollectionUtils.isEmpty((Collection)certEntry)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ba1\u7406\u804c\u4f4d\u4f53\u7cfb\u8303\u56f4\u4e0d\u53ef\u4e3a\u7a7a", (String)"CommOrgSaveValidator_0", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]));
            }
            if ((frame = entity.getDynamicObject("commframe")) == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u5c5e\u67b6\u6784\u7684\u72b6\u6001\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CommOrgSaveValidator_1", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]));
            } else {
                DynamicObject[] commFrameArr = this.commFrameApplicationService.getCommFrameById((Object)frame.getLong("id"));
                if (!"1".equals(commFrameArr[0].get("enable"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u5c5e\u67b6\u6784\u7684\u72b6\u6001\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CommOrgSaveValidator_1", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]));
                }
            }
            this.compareRegisterDateAndBsed(dataEntity);
            this.compareBesdAndFirstbsed(dataEntity);
            this.checkParentComm(dataEntity);
        }
    }

    private void compareBesdAndFirstbsed(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection parentComms = (DynamicObjectCollection)dataEntity.getValue("parentcomm");
        Date bsedValue = (Date)dataEntity.getValue("bsed");
        if (parentComms.size() > 0 && bsedValue != null) {
            Date maxBsed = new Date(HRBaseConstants.MAX_LOSEEFFECTDATETIME);
            for (int i = 0; i < parentComms.size(); ++i) {
                Date parentBesdDate = (Date)((DynamicObject)parentComms.get(0)).getDynamicObject("fbasedataid").get("bsed");
                if (!parentBesdDate.before(maxBsed)) continue;
                maxBsed = parentBesdDate;
            }
            if (bsedValue.before(maxBsed)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4e0a\u7ea7\u4e13\u59d4\u4f1a\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u3002", (String)"CommOrgFormPlugin_2", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void compareRegisterDateAndBsed(ExtendedDataEntity dataEntity) {
        Date registerDateValue = (Date)dataEntity.getValue("registerdate");
        Date bsedValue = (Date)dataEntity.getValue("bsed");
        if (registerDateValue != null && bsedValue != null && bsedValue.before(registerDateValue)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6210\u7acb\u65e5\u671f\u3002", (String)"CommOrgFormPlugin_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
        }
    }

    public void checkParentComm(ExtendedDataEntity dataEntity) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tdcs_commorgtype", (String)"number,name,index", (QFilter[])new QFilter[0]);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u4e13\u59d4\u4f1a\u7ec4\u7ec7\u7c7b\u578b\u201d\u4e3a\u7a7a,\u8bf7\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u589e\u52a0\u3002", (String)"CommUtils_0", (String)"tdc-tdcs-common", (Object[])new Object[0]));
            return;
        }
        int minIndex = Integer.MAX_VALUE;
        Long minId = 0L;
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.getInt("index") >= minIndex) continue;
            minIndex = dynamicObject.getInt("index");
            minId = dynamicObject.getLong("id");
        }
        DynamicObjectCollection parentComms = (DynamicObjectCollection)dataEntity.getValue("parentcomm");
        DynamicObject commorgtypeDyObj = (DynamicObject)dataEntity.getValue("commorgtype");
        if (parentComms.size() == 0 && !minId.equals(commorgtypeDyObj.getLong("id"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4e0a\u7ea7\u4e13\u59d4\u4f1a\u7ec4\u7ec7\u201d\u3002", (String)"CommUtils_1", (String)"tdc-tdcs-common", (Object[])new Object[0]));
        }
    }
}

