/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.opplugin.validator.commorg;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.domain.commorg.service.CommOrgDomainService;
import kd.tdc.tdcs.bussiness.domain.commorguser.enums.CommUserStatusEnum;
import kd.tdc.tdcs.bussiness.domain.commorguser.service.CommOrgUserDomainService;

public class CommOrgUserSaveValidator
extends HRDataBaseValidator {
    private static final Log logger = LogFactory.getLog(CommOrgUserSaveValidator.class);
    private final CommOrgUserDomainService commOrgUserDomainService = (CommOrgUserDomainService)ServiceFactory.getService(CommOrgUserDomainService.class);
    private final CommOrgDomainService commOrgDomainService = (CommOrgDomainService)ServiceFactory.getService(CommOrgDomainService.class);

    public void validate() {
        super.validate();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObjectCollection roleEntry;
            String errorMsg;
            QFilter phoneFilter;
            QFilter nameFilter;
            boolean exists;
            DynamicObject entity = dataEntity.getDataEntity();
            String isEmp = entity.getString("isemp");
            String name = entity.getString("name");
            String phone = entity.getString("phonenum");
            String email = entity.getString("email");
            this.checkEmail(dataEntity, email);
            DynamicObject person = entity.getDynamicObject("person");
            long commId = entity.getLong("comm.id");
            QFilter commFilter = new QFilter("comm", "=", (Object)commId);
            QFilter ignoreFilter = new QFilter("id", "!=", (Object)entity.getLong("boid")).and(new QFilter("iscurrentversion", "=", (Object)"1"));
            QFilter userStatusFilter = new QFilter("userstatus", "in", (Object)new String[]{CommUserStatusEnum.EFFECT.getNumber(), CommUserStatusEnum.WAIT_EFFECT.getNumber()});
            if ("0".equals(isEmp) && HRStringUtils.isNotEmpty((String)name) && HRStringUtils.isNotEmpty((String)phone) && (exists = this.commOrgUserDomainService.isExists(new QFilter[]{nameFilter = new QFilter("name", "=", (Object)name), phoneFilter = new QFilter("phonenum", "=", (Object)phone), commFilter, ignoreFilter, userStatusFilter}))) {
                errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u59d3\u540d\u548c\u624b\u673a\u53f7\u7801\u4e0e{0}\u91cd\u590d\uff0c\u8bf7\u786e\u8ba4", (String)"CommOrgUserSaveValidator_0", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]), name);
                this.showErrorMessage(errorMsg, dataEntity);
            }
            if ("1".equals(isEmp)) {
                QFilter empFilter;
                boolean exists2;
                if (person == null) {
                    String errorMsg2 = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4eba\u5458\u201d\u3002", (String)"CommOrgUserSaveValidator_9", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]);
                    this.showErrorMessage(errorMsg2, dataEntity);
                    return;
                }
                if (!HRObjectUtils.isEmpty((Object)person) && (exists2 = this.commOrgUserDomainService.isExists(new QFilter[]{empFilter = new QFilter("person", "=", person.getPkValue()), commFilter, ignoreFilter, userStatusFilter}))) {
                    String errorMsg3 = ResManager.loadKDString((String)"\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0\u6210\u5458\u3002", (String)"CommOrgUserSaveValidator_4", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]);
                    this.showErrorMessage(errorMsg3, dataEntity);
                }
            }
            if (CollectionUtils.isEmpty((Collection)(roleEntry = entity.getDynamicObjectCollection("roleentry"))) || ((DynamicObject)roleEntry.get(0)).getDynamicObject("commrole") == null) {
                String errorMsg4 = ResManager.loadKDString((String)"\u8bf7\u4e3a\u6210\u5458\u5206\u914d\u81f3\u5c11\u4e00\u4e2a\u89d2\u8272\u3002", (String)"CommOrgUserSaveValidator_3", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]);
                this.showErrorMessage(errorMsg4, dataEntity);
                return;
            }
            AtomicBoolean checkPass = new AtomicBoolean(true);
            roleEntry.forEach(dynamicObject -> {
                if (dynamicObject.get("commrole") == null) {
                    checkPass.set(false);
                }
                if (dynamicObject.get("roleeffectdate") == null) {
                    checkPass.set(false);
                }
            });
            if (!checkPass.get()) {
                return;
            }
            List collect = roleEntry.stream().filter(role -> "1".equals(role.getString("ismain"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect) || ((DynamicObject)roleEntry.get(0)).getDynamicObject("commrole") == null) {
                errorMsg = ResManager.loadKDString((String)"\u8bf7\u4e3a\u6210\u5458\u5206\u914d\u4e00\u4e2a\u4e3b\u89d2\u8272\u3002", (String)"CommOrgUserSaveValidator_1", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]);
                this.showErrorMessage(errorMsg, dataEntity);
            } else if (collect.size() > 1) {
                Date now = HRDateTimeUtils.dateFormatDate((Date)new Date());
                Long effectMainRole = collect.stream().filter(d -> d.getDate("roleexpiredate") == null || now.compareTo(d.getDate("roleexpiredate")) <= 0).count();
                if (effectMainRole > 1L) {
                    String errorMsg5 = ResManager.loadKDString((String)"\u53ea\u53ef\u9009\u62e9\u4e00\u4e2a\u4e3b\u89d2\u8272\u3002", (String)"CommOrgUserSaveValidator_2", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]);
                    this.showErrorMessage(errorMsg5, dataEntity);
                }
            }
            Date commEffectiveDate = this.commOrgDomainService.queryOne(Long.valueOf(commId)).getDate("bsed");
            boolean compareDate = true;
            for (DynamicObject roleObj : roleEntry) {
                String errorMsg6;
                Date roleEffectDate = roleObj.getDate("roleeffectdate");
                Date roleExpireDate = roleObj.getDate("roleexpiredate");
                String roleName = roleObj.getString("commrole.name");
                if (roleExpireDate != null && roleEffectDate != null && roleEffectDate.compareTo(roleExpireDate) > 0) {
                    errorMsg6 = ResManager.loadKDString((String)"\u201c{0}\u201d\u89d2\u8272\u7684\u5931\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6216\u7b49\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"CommOrgUserSaveValidator_5", (String)"tdc-tdcs-opplugin", (Object[])new Object[]{roleName});
                    this.showErrorMessage(errorMsg6, dataEntity);
                    compareDate = false;
                }
                if (commEffectiveDate == null || roleEffectDate == null || roleEffectDate.compareTo(commEffectiveDate) >= 0) continue;
                errorMsg6 = ResManager.loadKDString((String)"\u201c{0}\u201d\u89d2\u8272\u751f\u6548\u65e5\u671f\u9700\u665a\u4e8e\u7b49\u4e8e\u4e13\u59d4\u4f1a\u751f\u6548\u65e5\u671f\u3002", (String)"CommOrgUserSaveValidator_7", (String)"tdc-tdcs-opplugin", (Object[])new Object[]{roleName});
                this.showErrorMessage(errorMsg6, dataEntity);
                compareDate = false;
            }
            if (!compareDate) continue;
            this.dateIsContinuous(roleEntry, dataEntity);
        }
    }

    public void checkEmail(ExtendedDataEntity dataEntity, String email) {
        boolean flag;
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)email) && !(flag = StringUtils.isEmail((String)email))) {
            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u90ae\u7bb1\u201d\u3002", (String)"CommOrgUserSaveValidator_8", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]));
        }
    }

    private void dateIsContinuous(DynamicObjectCollection roleEntry, ExtendedDataEntity dataEntity) {
        List sortedRoleObjs = roleEntry.stream().sorted(Comparator.comparing(r -> r.getDate("roleeffectdate"))).collect(Collectors.toList());
        Date lastDate = ((DynamicObject)sortedRoleObjs.get(0)).getDate("roleexpiredate");
        for (int i = 0; i < sortedRoleObjs.size() - 1 && lastDate != null; ++i) {
            DynamicObject nextRoleObj = (DynamicObject)sortedRoleObjs.get(i + 1);
            boolean isContinue = true;
            Date nextEffectDate = nextRoleObj.getDate("roleeffectdate");
            Date nextExpireDate = nextRoleObj.getDate("roleexpiredate");
            if (lastDate != null && lastDate.compareTo(nextEffectDate) < 0) {
                String errorMsg = ResManager.loadKDString((String)"\u5404\u89d2\u8272\u7684\u751f\u6548\u671f\u4e4b\u95f4\u4e0d\u53ef\u51fa\u73b0\u65ad\u6863\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CommOrgUserSaveValidator_6", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]);
                this.showErrorMessage(errorMsg, dataEntity);
                isContinue = false;
            } else if (nextExpireDate == null || nextExpireDate.after(lastDate)) {
                lastDate = nextExpireDate;
            }
            if (!isContinue) break;
        }
    }

    private void showErrorMessage(String errorMsg, ExtendedDataEntity dataEntity) {
        logger.info(MessageFormat.format("{0} this dataEntity is : {1}", errorMsg, dataEntity.getBillPkId()));
        this.addErrorMessage(dataEntity, errorMsg);
    }
}

