/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.opplugin.web.commorg;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.domain.certgroup.service.CertGroupDomainService;
import kd.tdc.tdcs.bussiness.domain.commorguser.enums.CommUserStatusEnum;
import kd.tdc.tdcs.opplugin.validator.commorg.CommOrgUserSaveValidator;

public class CommOrgUserSaveOp
extends HRDataBaseOp {
    private final CertGroupDomainService certGroupDomainService = (CertGroupDomainService)ServiceFactory.getService(CertGroupDomainService.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new CommOrgUserSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(beforeOperationArgs);
        for (DynamicObject commOrgUser : dataEntities = beforeOperationArgs.getDataEntities()) {
            List expiredDateSortedRoleObjs;
            List effectDateSortedRoleObjs = commOrgUser.getDynamicObjectCollection("roleentry").stream().sorted(Comparator.comparing(r -> r.getDate("roleeffectdate"))).collect(Collectors.toList());
            Date minRoleEffectDate = ((DynamicObject)effectDateSortedRoleObjs.get(0)).getDate("roleeffectdate");
            if (minRoleEffectDate.compareTo(new Date()) <= 0) {
                commOrgUser.set("userstatus", (Object)CommUserStatusEnum.EFFECT.getNumber());
            }
            if ((expiredDateSortedRoleObjs = commOrgUser.getDynamicObjectCollection("roleentry").stream().filter(r -> r.getDate("roleexpiredate") != null).sorted(Comparator.comparing(r -> r.getDate("roleexpiredate"))).collect(Collectors.toList())).size() == effectDateSortedRoleObjs.size() && effectDateSortedRoleObjs.size() > 0) {
                Date maxRoleExpireDate = ((DynamicObject)expiredDateSortedRoleObjs.get(expiredDateSortedRoleObjs.size() - 1)).getDate("roleexpiredate");
                commOrgUser.set("quitdate", (Object)maxRoleExpireDate);
            } else {
                commOrgUser.set("quitdate", null);
            }
            commOrgUser.set("joindate", (Object)minRoleEffectDate);
            commOrgUser.set("bsed", (Object)minRoleEffectDate);
            String isEmp = commOrgUser.getString("isemp");
            if (HRStringUtils.equals((String)isEmp, (String)"1")) {
                String personName = commOrgUser.getString("person.person.name");
                commOrgUser.set("name", (Object)personName);
                String number = commOrgUser.getString("person.person.number");
                commOrgUser.set("number", (Object)number);
                commOrgUser.set("phonenum", null);
                commOrgUser.set("email", null);
                commOrgUser.set("country", null);
                commOrgUser.set("bosuser", null);
            } else if (HRStringUtils.equals((String)isEmp, (String)"0")) {
                commOrgUser.set("person", null);
            }
            if (commOrgUser.getDate("quitdate") == null || !commOrgUser.getDate("quitdate").before(new Date())) continue;
            Date date = new Date();
            commOrgUser.set("brled", (Object)date);
            commOrgUser.set("userstatus", (Object)CommUserStatusEnum.EXIT.getNumber());
            commOrgUser.set("modifytime", (Object)date);
            commOrgUser.set("modifier", (Object)RequestContext.get().getCurrUserId());
            HashMap<Long, ArrayList> certmemberMap = new HashMap<Long, ArrayList>(4);
            certmemberMap.put(commOrgUser.getDynamicObject("comm").getLong("id"), Lists.newArrayList((Object[])new Long[]{commOrgUser.getLong("boid")}));
            this.certGroupDomainService.quit(certmemberMap);
        }
    }
}

