/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.opplugin.web.coordination;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.CoordinationApplicationService;
import kd.tdc.tdcs.bussiness.domain.coordination.service.CoordTaskLogDomainService;
import kd.tdc.tdcs.common.constants.coordination.CoordExecuteTypeEnum;
import kd.tdc.tdcs.common.constants.coordination.CoordTaskStatusEnum;
import kd.tdc.tdcs.opplugin.validator.coordination.CoordinationManualValidator;

public class CoordinationManualOp
extends HRDataBaseOp {
    private static final CoordinationApplicationService coordinationApplicationService = (CoordinationApplicationService)ServiceFactory.getService(CoordinationApplicationService.class);
    private final CoordTaskLogDomainService coordTaskLogDomainService = (CoordTaskLogDomainService)ServiceFactory.getService(CoordTaskLogDomainService.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("taskstatus");
        fieldKeys.add("startdate");
        fieldKeys.add("enddate");
        fieldKeys.add("taskexecinfo");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new CoordinationManualValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String operationKey = args.getOperationKey();
        DynamicObject[] taskDys = args.getDataEntities();
        String updateTaskStatus = "";
        String logStr = "";
        long currentTimeMillis = System.currentTimeMillis();
        if (HRStringUtils.equals((String)operationKey, (String)"manuallabeling")) {
            updateTaskStatus = CoordTaskStatusEnum.MANUAL_HANDLED.getStatus();
            logStr = ResManager.loadKDString((String)"\u6807\u8bb0\u624b\u5de5\u5904\u7406\u3002", (String)"CoordinationManualOp_01", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]);
        } else if (HRStringUtils.equals((String)operationKey, (String)"unmark")) {
            updateTaskStatus = CoordTaskStatusEnum.TO_BE_EXECUTE.getStatus();
            logStr = ResManager.loadKDString((String)"\u53d6\u6d88\u6807\u8bb0\u3002", (String)"CoordinationManualOp_02", (String)"tdc-tdcs-opplugin", (Object[])new Object[0]);
        }
        String finalLogStr = logStr;
        String finalUpdateTaskStatus = updateTaskStatus;
        Arrays.stream(taskDys).forEach(taskDy -> {
            taskDy.set("startdate", (Object)currentTimeMillis);
            taskDy.set("enddate", (Object)currentTimeMillis);
            taskDy.set("taskstatus", (Object)finalUpdateTaskStatus);
            this.coordTaskLogDomainService.log(taskDy, CoordExecuteTypeEnum.MANUAL_EXECUTION.getType(), finalLogStr);
        });
        coordinationApplicationService.updateTaskStatus(taskDys, updateTaskStatus, finalLogStr);
    }
}

