/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.opplugin.web.coordination;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.CoordinationApplicationService;
import kd.tdc.tdcs.opplugin.validator.coordination.CoordinationSubscriberValidator;

public class CoorinationSubscriberOp
extends HRDataBaseOp {
    private final CoordinationApplicationService coordinationApplicationService = (CoordinationApplicationService)ServiceFactory.getService(CoordinationApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("substatus");
        fieldKeys.add("suber");
        fieldKeys.add("subtime");
        fieldKeys.add("msgsubno");
        fieldKeys.add("msgpublishertype");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new CoordinationSubscriberValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        String operationKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        List msgSubNos = Arrays.stream(dataEntities).filter(dataEntity -> dataEntity.getString("msgpublishertype").equals("tdcs_coordpublisher")).map(dataEntity -> dataEntity.getString("msgsubno")).collect(Collectors.toList());
        long currUserId = RequestContext.get().getCurrUserId();
        Date subDate = new Date();
        if (HRStringUtils.equals((String)operationKey, (String)"subscribe")) {
            for (DynamicObject dataEntity2 : dataEntities) {
                dataEntity2.set("substatus", (Object)"1");
                dataEntity2.set("suber", (Object)currUserId);
                dataEntity2.set("subtime", (Object)subDate);
            }
            this.coordinationApplicationService.subscribeInDomainCoordMsg(msgSubNos);
        }
        if (HRStringUtils.equals((String)operationKey, (String)"nosubscribe")) {
            for (DynamicObject dataEntity2 : dataEntities) {
                dataEntity2.set("substatus", (Object)"0");
            }
            this.coordinationApplicationService.unsubscribeInDomainCoordMsg(msgSubNos);
        }
    }
}

