/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.opplugin.web.talentpool;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.HaosService;
import kd.tdc.tdcs.common.constants.talentpool.pool.TalentPoolConstants;
import kd.tdc.tdcs.opplugin.validator.talentpool.TalentPoolValidator;

public class TalentPoolOp
extends HRDataBaseOp
implements TalentPoolConstants {
    private static final HaosService HAOS_SERVICE = (HaosService)ServiceFactory.getService(HaosService.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("enable");
        Collections.addAll(fieldKeys, "islimitpersonnum", "createpooldate", "personnumlimit", "allapplyadminorg", "group");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new TalentPoolValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.saveFiledValue(args.getDataEntities());
        }
        if (HRStringUtils.equals((String)operationKey, (String)"submit")) {
            this.saveFiledValue(args.getDataEntities());
        }
    }

    private void saveFiledValue(DynamicObject[] dataEntities) {
        for (DynamicObject dy : dataEntities) {
            DynamicObjectCollection collection;
            if (dy.getDate("createpooldate") == null) {
                dy.set("createpooldate", (Object)HRDateTimeUtils.getNowDate());
            }
            if (CollectionUtils.isEmpty((Collection)(collection = dy.getDynamicObjectCollection("entryentity")))) {
                return;
            }
            List applyAdminOrgIds = collection.stream().map(item -> item.getDynamicObject("applyadminorg").getLong("id")).collect(Collectors.toList());
            DynamicObjectCollection objectCollection = dy.getDynamicObjectCollection("allapplyadminorg");
            objectCollection.clear();
            for (Long orgId : applyAdminOrgIds) {
                DynamicObject dynamicObject = objectCollection.addNew();
                dynamicObject.set("fbasedataid", (Object)orgId);
            }
        }
    }
}

