/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.task.talentpool;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.tdc.tdcs.bussiness.application.TalentPoolApplicationService;
import kd.tdc.tdcs.bussiness.application.external.HaosService;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;

public class SuitAdminOrgUpgradeTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(SuitAdminOrgUpgradeTask.class);
    private static final HaosService HAOS_SERVICE = (HaosService)kd.tdc.tdcs.bussiness.ServiceFactory.getService(HaosService.class);
    private static final TalentPoolApplicationService talentPoolApplicationService = (TalentPoolApplicationService)kd.tdc.tdcs.bussiness.ServiceFactory.getService(TalentPoolApplicationService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("Start-TalentPoolAdminOrgUpgradeTask-taskId:{}", (Object)this.taskId);
        DLock lock = DLock.create((String)"TalentPoolAdminOrgUpgradeTask_42T8WRAQS5P7");
        try {
            if (lock.tryLock(3600000L)) {
                Object[] dys = TalentPoolQueryHelper.includeLowLevelPools();
                if (HRArrayUtils.isNotEmpty((Object[])dys)) {
                    long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                    List rootOrgTreeResult = HAOS_SERVICE.batchGetAllSubOrg((List)Lists.newArrayList((Object[])new Long[]{rootOrgId}), new Date());
                    List rootOrgIds = rootOrgTreeResult.stream().filter(item -> "1".equals(item.get("businessStatus"))).map(item -> Long.valueOf(String.valueOf(item.get("orgId")))).collect(Collectors.toList());
                    Arrays.stream(dys).forEach(poolDy -> {
                        DynamicObjectCollection collection = poolDy.getDynamicObjectCollection("entryentity");
                        HashSet adminOrgIds = Sets.newHashSet();
                        HashSet includeLowLevelIds = Sets.newHashSet();
                        collection.forEach(entryDy -> {
                            long adminOrgId = entryDy.getLong("applyadminorg.id");
                            adminOrgIds.add(adminOrgId);
                            if (entryDy.getBoolean("includelowlevel")) {
                                if (rootOrgId != adminOrgId) {
                                    includeLowLevelIds.add(adminOrgId);
                                } else {
                                    adminOrgIds.addAll(rootOrgIds);
                                }
                            }
                        });
                        if (HRCollUtil.isNotEmpty((Collection)includeLowLevelIds)) {
                            List orgTreeResult = HAOS_SERVICE.batchGetAllSubOrg((List)Lists.newArrayList((Iterable)includeLowLevelIds), new Date());
                            Set orgTreeIds = orgTreeResult.stream().filter(item -> "1".equals(item.get("businessStatus"))).map(item -> Long.valueOf(String.valueOf(item.get("orgId")))).collect(Collectors.toSet());
                            adminOrgIds.addAll(orgTreeIds);
                        }
                        collection.clear();
                        for (Long adminOrgId : adminOrgIds) {
                            DynamicObject dynamicObject = collection.addNew();
                            dynamicObject.set("applyadminorg", (Object)adminOrgId);
                            dynamicObject.set("includelowlevel", (Object)"0");
                        }
                        talentPoolApplicationService.savePoolDy(poolDy);
                    });
                    LOG.info("TalentPoolAdminOrgUpgradeTask-Is-Success");
                }
                this.disableTask();
            }
        }
        catch (Exception exception) {
            LOG.error("TalentPoolAdminOrgUpgradeTask-Is-Fail-The-Exception", (Throwable)exception);
        }
        finally {
            lock.unlock();
        }
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

