/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.batchconfirm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class BatchConfirmPlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(BatchConfirmPlugin.class);
    private static final String CONFIRM = "confirm";
    private static final String EXPORTEXCEL = "exportexcel";
    private static final Map<String, String[]> pageLblMap;
    private static final Map<String, String[]> pageFieldMap;

    public void beforeBindData(EventObject e) {
        Object customParamObj;
        super.beforeBindData(e);
        this.updatePage();
        String fitNum = (String)this.getView().getFormShowParameter().getCustomParam("lbl_fitnum");
        if ("0".equals(fitNum)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONFIRM});
        }
        if ((customParamObj = this.getView().getFormShowParameter().getCustomParam("customReason")) != null) {
            this.getView().getModel().setValue("details", (Object)String.valueOf(customParamObj));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM});
        this.addClickListeners(new String[]{EXPORTEXCEL});
    }

    public void click(EventObject evt) {
        Control sControl = (Control)evt.getSource();
        if (HRStringUtils.equals((String)sControl.getKey(), (String)EXPORTEXCEL)) {
            this.exportExcel();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)opKey, (String)"donothing") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            HashMap<String, Object> result = new HashMap<String, Object>(3);
            result.put("iscofirm", Boolean.TRUE);
            String formId = this.getView().getFormShowParameter().getFormId();
            if (formId.contains("reason")) {
                result.put("details", this.getModel().getValue("details"));
                result.put("reason", this.getModel().getValue("reason"));
            }
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }

    private void exportExcel() {
        String excelName = (String)this.getView().getFormShowParameter().getCustomParam("excelname");
        List exportDataList = (List)this.getView().getFormShowParameter().getCustomParam("exportdatalist");
        List headDataList = new ArrayList();
        try {
            headDataList = (List)HRJSONUtils.cast((String)this.getView().getFormShowParameter().getCustomParam("headdatalist").toString(), List.class, (Class[])new Class[]{HRExportHeadObject.class});
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, (List)exportDataList, headDataList);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        if (!HRStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }

    private void updatePage() {
        String[] filedList;
        String[] lblList;
        String formId = this.getView().getFormShowParameter().getFormId();
        for (String lbl : lblList = pageLblMap.get(formId)) {
            String param = (String)this.getView().getFormShowParameter().getCustomParam(lbl);
            if (HRStringUtils.isEmpty((String)param)) {
                param = " ";
            }
            LabelAp labelAp = this.createLabel(lbl, param);
            this.getView().updateControlMetadata(lbl, labelAp.createControl());
        }
        for (String field : filedList = pageFieldMap.get(formId)) {
            String param = (String)this.getView().getFormShowParameter().getCustomParam(field);
            if (HRStringUtils.isEmpty((String)param)) continue;
            FieldEdit fieldEdit = (FieldEdit)this.getControl(field);
            fieldEdit.setCaption(new LocaleString(param));
            DynamicProperty dynamicProperty = this.getModel().getDataEntityType().getProperty(field);
            dynamicProperty.getDisplayName().setLocaleValue(param);
        }
    }

    private LabelAp createLabel(String key, String name) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(name));
        return labelAp;
    }

    static {
        HashMap<String, String[]> temp = new HashMap<String, String[]>();
        temp.put("tdcs_batchconfirm", new String[]{"lbl_allnum", "lbl_fitnum", "lbl_fit", "lbl_nofitnum", "lbl_nofit", "lbl_final"});
        temp.put("tdcs_allrightconfirm", new String[]{"lbl_final"});
        temp.put("tdcs_reasonconfirm", new String[]{"lbl_allnum", "lbl_fitnum", "lbl_fit", "lbl_nofitnum", "lbl_nofit"});
        temp.put("tdcs_allreasonconfirm", new String[0]);
        temp.put("tdcs_sigreasonconfirm", new String[]{"lbl_allnum", "lbl_fitnum", "lbl_fit", "lbl_nofitnum", "lbl_nofit"});
        temp.put("tdcs_sigreason2confirm", new String[]{"lbl_final", "lbl_allnum", "lbl_fitnum", "lbl_fit", "lbl_nofitnum", "lbl_nofit"});
        temp.put("tdcs_allreasonsigconfirm", new String[0]);
        temp.put("tdcs_allreasonsigconfirm2", new String[]{"lbl_final"});
        pageLblMap = Collections.unmodifiableMap(temp);
        temp = new HashMap();
        temp.put("tdcs_batchconfirm", new String[0]);
        temp.put("tdcs_allrightconfirm", new String[0]);
        temp.put("tdcs_reasonconfirm", new String[]{"reason", "details"});
        temp.put("tdcs_allreasonconfirm", new String[]{"reason", "details"});
        temp.put("tdcs_sigreasonconfirm", new String[]{"details"});
        temp.put("tdcs_sigreason2confirm", new String[]{"details"});
        temp.put("tdcs_allreasonsigconfirm", new String[]{"details"});
        temp.put("tdcs_allreasonsigconfirm2", new String[]{"details"});
        pageFieldMap = Collections.unmodifiableMap(temp);
    }
}

