/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.certificationgroup;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class CerMemberEntryPlugin
extends AbstractListPlugin {
    private final HRBaseServiceHelper CERMEM_HELPER = new HRBaseServiceHelper("tdcs_certmemberentry");
    private Map<String, Object> result = new HashMap<String, Object>();

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addListRowClickListener((ListRowClickListener)this);
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btnclose"});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Object[] pkIds = this.getSelectedRows().getPrimaryKeyValues();
        String selectFields = "id,person,person.id,person.person,person.person.id,person.person.name,ctteeper,ctteeper.name,ctteeper.person.person,ctteeper.person.person.id,ctteeper.person.person.name,ctteeper.person.empnumber,source,isemp,ctteeper.bosuser,membername,membernumber,uniquekey";
        DynamicObject[] dynamicObjects = this.CERMEM_HELPER.query(selectFields, new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
        List nameList = Arrays.stream(dynamicObjects).map(row -> row.getString("membername")).collect(Collectors.toList());
        List numberList = Arrays.stream(dynamicObjects).map(row -> row.getString("membernumber")).collect(Collectors.toList());
        List ctteeperList = Arrays.stream(dynamicObjects).filter(dynamicObject -> "0".equals(dynamicObject.getString("isemp"))).map(dynamicObject -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ctteeper", dynamicObject.getString("ctteeper.id"));
            if (dynamicObject.getBoolean("ctteeper.isemp")) {
                map.put("personId", dynamicObject.getString("person.person.id"));
                map.put("ctteeperName", dynamicObject.getString("membername"));
                map.put("ctteeperNum", dynamicObject.getString("membernumber"));
                map.put("ctteeperEmpId", dynamicObject.getString("person.id"));
            }
            if (!dynamicObject.getBoolean("ctteeper.isemp")) {
                map.put("ctteeperName", dynamicObject.getString("membername"));
                map.put("ctteeperNum", dynamicObject.getString("membernumber"));
                map.put("ctteeperBosUserId", dynamicObject.getString("ctteeper.bosuser.id"));
                map.put("ctteeperBosUserName", dynamicObject.getString("ctteeper.bosuser.name"));
                map.put("ctteeperBosUserNumber", dynamicObject.getString("ctteeper.bosuser.number"));
            }
            map.put("uniquekey", dynamicObject.getString("uniquekey"));
            map.put("entryid", dynamicObject.getString("id"));
            return map;
        }).collect(Collectors.toList());
        List empLists = Arrays.stream(dynamicObjects).filter(dynamicObject -> "1".equals(dynamicObject.getString("isemp"))).map(dynamicObject -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("employee", dynamicObject.getString("person.id"));
            map.put("personId", dynamicObject.getString("person.person.id"));
            map.put("empLoyeeName", dynamicObject.getString("membername"));
            map.put("empLoyeeNum", dynamicObject.getString("membernumber"));
            map.put("entryid", dynamicObject.getString("id"));
            map.put("uniquekey", dynamicObject.getString("uniquekey"));
            return map;
        }).collect(Collectors.toList());
        List allMembers = Arrays.stream(dynamicObjects).map(dynamicObject -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("employee", dynamicObject.getString("person.id"));
            map.put("personId", dynamicObject.getString("person.person.id"));
            map.put("memberName", dynamicObject.getString("membername"));
            map.put("memberNumber", dynamicObject.getString("membernumber"));
            map.put("entryid", dynamicObject.getString("id"));
            map.put("ctteeper", dynamicObject.getString("ctteeper.id"));
            map.put("ctteeperBosUserId", dynamicObject.getString("ctteeper.bosuser.id"));
            map.put("isemp", dynamicObject.getString("isemp"));
            return map;
        }).collect(Collectors.toList());
        this.result.put("pkIds", pkIds);
        this.result.put("name", String.join((CharSequence)";", nameList));
        this.result.put("number", String.join((CharSequence)";", numberList));
        this.result.put("ctteeper", ctteeperList);
        this.result.put("employee", empLists);
        this.result.put("allMembers", allMembers);
        this.getView().returnDataToParent(this.result);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        if (HRStringUtils.equals((String)"btnok", (String)control.getKey()) && this.getSelectedRows().size() > 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u5b89\u639220\u4f4d\u8bc4\u59d4\u3002", (String)"CerMemberEntryPlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        String opBtn = HRStringUtils.equals((String)"btnok", (String)control.getKey()) ? "btnok" : "btnclose";
        this.result.put("btn", opBtn);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.result.put("btn", "btnok");
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List listQFilter = e.getQFilters();
        QFilter userFilter = new QFilter("userstatus", "=", (Object)"1");
        listQFilter.add(userFilter);
    }
}

