/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.certificationgroup;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.tdcs.bussiness.domain.certgroup.enums.CertMemberSourceEnum;
import kd.tdc.tdcs.common.util.CommUtils;

public class CertMemberPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String CTTEE_PER = "ctteeper";
    private static final String PERSON = "person";
    private static final String PERSON_ID = "personId";
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit ctteeper = (BasedataEdit)this.getControl(CTTEE_PER);
        ctteeper.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Integer index = (Integer)formShowParameter.getCustomParam("index");
        if (index != null) {
            this.initDate();
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.initPersonMustInput();
    }

    private void initDate() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String source = (String)formShowParameter.getCustomParam("source");
        IDataModel model = this.getModel();
        model.setValue("source", (Object)source);
        model.setValue("remark", formShowParameter.getCustomParam("remark"));
        model.setValue(PERSON, formShowParameter.getCustomParam(PERSON));
        model.setValue(CTTEE_PER, formShowParameter.getCustomParam(CTTEE_PER));
        List roleIds = (List)formShowParameter.getCustomParam("certmbrrole");
        model.setValue("certmbrrole", (Object)roleIds.toArray(new Long[0]));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String personId;
        DynamicObject person;
        DynamicObject ctteeper;
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        Set employeeIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam(PERSON_ID)));
        if (HRStringUtils.equals((String)name, (String)"source")) {
            this.clearPerson();
            this.initPersonMustInput();
        }
        if (HRStringUtils.equals((String)name, (String)CTTEE_PER) && (ctteeper = (DynamicObject)this.getModel().getValue(CTTEE_PER)) != null && !CollectionUtils.isEmpty((Collection)employeeIdSet)) {
            String ctteeperId = ctteeper.getString("person.id");
            String string = ctteeperId = HRStringUtils.isNotEmpty((String)ctteeperId) ? ctteeperId : CommUtils.appendStr((String[])new String[]{ctteeper.getString("name"), ctteeper.getString("phonenum")});
            if (HRStringUtils.isNotEmpty((String)ctteeperId) && employeeIdSet.contains(ctteeperId)) {
                this.getModel().setValue(CTTEE_PER, null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0\u6210\u5458\u3002", (String)"CertMemberPlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            }
        }
        if (HRStringUtils.equals((String)name, (String)PERSON) && !HRObjectUtils.isEmpty((Object)(person = (DynamicObject)this.getModel().getValue(PERSON))) && HRStringUtils.isNotEmpty((String)(personId = person.getString("id"))) && !CollectionUtils.isEmpty((Collection)employeeIdSet) && employeeIdSet.contains(personId)) {
            this.getModel().setValue(PERSON, null);
            this.getModel().setValue(PERSON, null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0\u6210\u5458\u3002", (String)"CertMemberPlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
        }
    }

    private void initPersonMustInput() {
        String source = (String)this.getModel().getValue("source");
        Boolean isComm = CertMemberSourceEnum.COMM.getNumber().equals(source);
        BasedataEdit ctteeper = (BasedataEdit)this.getView().getControl(CTTEE_PER);
        ctteeper.setMustInput(isComm.booleanValue());
        this.getView().setVisible(isComm, new String[]{CTTEE_PER});
        BasedataEdit showPerson = (BasedataEdit)this.getView().getControl(PERSON);
        showPerson.setMustInput(isComm == false);
        this.getView().setVisible(Boolean.valueOf(isComm == false), new String[]{PERSON});
    }

    private void clearPerson() {
        this.getModel().setValue(CTTEE_PER, null);
        this.getModel().setValue(PERSON, null);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (HRStringUtils.equals((String)operateKey, (String)BTN_OK) && success) {
            DynamicObject entity = this.getModel().getDataEntity();
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Integer index = (Integer)formShowParameter.getCustomParam("index");
            if (index != null) {
                returnData.put("index", index);
            }
            String source = entity.getString("source");
            returnData.put("source", source);
            if (CertMemberSourceEnum.COMM.getNumber().equals(source)) {
                returnData.put(CTTEE_PER, entity.getDynamicObject(CTTEE_PER));
            } else if (CertMemberSourceEnum.OTHER.getNumber().equals(source)) {
                returnData.put(PERSON, entity.getDynamicObject(PERSON));
            }
            DynamicObjectCollection roleCollection = entity.getDynamicObjectCollection("certmbrrole");
            Set roleIds = roleCollection.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            returnData.put("certmbrrole", roleIds);
            returnData.put("remark", entity.getString("remark"));
            returnData.put("pageId", this.getView().getPageId());
            this.getView().returnDataToParent(returnData);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)CTTEE_PER)) {
            QFilter filter = new QFilter("userstatus", "=", (Object)"1");
            beforeF7SelectEvent.getCustomQFilters().add(filter);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("commorg", formShowParameter.getCustomParam("commorg"));
        }
    }
}

