/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.certificationgroup;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.CommOrgApplicationService;
import kd.tdc.tdcs.bussiness.domain.certgroup.enums.CertMemberSourceEnum;
import kd.tdc.tdcs.bussiness.domain.certgroup.enums.TeamTypeEnum;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;
import kd.tdc.tdcs.common.util.CommUtils;
import kd.tdc.tdcs.common.util.CommonUtils;

public class CertificationGroupPlugin
extends HRDataBaseEdit
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(CertificationGroupPlugin.class);
    private static final String CERT_MEMBER = "certMember";
    private static final String PERSON_ID = "personId";
    private static final String ENTRYENTITY_ID = "entryentity_id";
    private static final String ADDENTRY = "addentry";
    private final CommOrgApplicationService commOrgApplicationService = (CommOrgApplicationService)ServiceFactory.getService(CommOrgApplicationService.class);
    private final FormCommonService formCommonService = (FormCommonService)ServiceFactory.getService(FormCommonService.class);
    private static final String[] fields = new String[]{"membername", "membernumber", "certmbrrole", "source", "isemp", "remark", "person", "ctteeper", "userstatus", "entryid", "id", "uniquekey"};
    private static final String[] quitFelds = new String[]{"quitmembername", "quitmembernumber", "quitcertmbrrole", "quitsource", "quitisemp", "quitremark", "quitperson", "quitctteeper", "quituserstatus", "quitentryid", "id", "quituniquekey"};

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid perEntry = (EntryGrid)this.getView().getControl("certcentry");
        perEntry.addHyperClickListener((HyperLinkClickListener)this);
        Toolbar toolbar = (Toolbar)this.getView().getControl("advcontoolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject eve) {
    }

    public void afterBindData(EventObject object) {
        super.afterBindData(object);
        this.changeOrgByTeamType();
        Object commOrgId = this.getView().getFormShowParameter().getCustomParam("commOrgId");
        if (commOrgId != null) {
            this.getModel().setValue("teamtype", (Object)TeamTypeEnum.COMM.getNumber());
            this.getModel().setValue("commorg", commOrgId);
            this.getView().setEnable(Boolean.FALSE, new String[]{"teamtype", "commorg"});
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("certcentry");
        for (DynamicObject certc : entryEntity) {
            DynamicObject person;
            if (!HRObjectUtils.isEmpty((Object)certc.getDynamicObject("person"))) {
                person = certc.getDynamicObject("person.person");
                certc.set("membername", (Object)person.getString("name"));
                certc.set("membernumber", (Object)person.getString("number"));
                certc.set("isemp", (Object)"1");
                continue;
            }
            if (HRObjectUtils.isEmpty((Object)certc.getDynamicObject("ctteeper"))) continue;
            person = certc.getDynamicObject("ctteeper");
            certc.set("membername", (Object)person.getString("name"));
            if (person.getDynamicObject("person") != null) {
                certc.set("membernumber", (Object)person.getDynamicObject("person").getString("empnumber"));
            }
            certc.set("isemp", (Object)person.getString("isemp"));
        }
        this.getView().updateView("certcentry");
        this.filterQuitPerson();
        this.getModel().setDataChanged(false);
    }

    private void filterQuitPerson() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("certcentry");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        for (String field : fields) {
            setter.addField(field, new Object[0]);
        }
        TableValueSetter quitSetter = new TableValueSetter(new String[0]);
        for (String quitField : quitFelds) {
            quitSetter.addField(quitField, new Object[0]);
        }
        this.setTableValueSetter(setter, quitSetter, entryEntity);
        model.deleteEntryData("certcentry");
        model.deleteEntryData("quitcertcentry");
        model.batchCreateNewEntryRow("certcentry", setter);
        model.batchCreateNewEntryRow("quitcertcentry", quitSetter);
        model.endInit();
        this.getView().updateView("certcentry");
        this.getView().updateView("quitcertcentry");
    }

    private void setTableValueSetter(TableValueSetter setter, TableValueSetter quitSetter, DynamicObjectCollection dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long entryid = dynamicObject.getLong("id");
            Long personId = null;
            if (dynamicObject.get("person") != null) {
                personId = dynamicObject.getDynamicObject("person").getLong("id");
            }
            Long ctteeperId = null;
            if (dynamicObject.get("ctteeper") != null) {
                ctteeperId = dynamicObject.getDynamicObject("ctteeper").getLong("id");
            }
            if (HRStringUtils.equals((String)dynamicObject.getString("userstatus"), (String)"1")) {
                setter.addRow(new Object[]{dynamicObject.get("membername"), dynamicObject.get("membernumber"), dynamicObject.getDynamicObjectCollection("certmbrrole"), dynamicObject.get("source"), dynamicObject.get("isemp"), dynamicObject.get("remark"), personId, ctteeperId, dynamicObject.get("userstatus"), entryid, entryid, dynamicObject.get("uniquekey")});
                continue;
            }
            quitSetter.addRow(new Object[]{dynamicObject.get("membername"), dynamicObject.get("membernumber"), dynamicObject.getDynamicObjectCollection("certmbrrole"), dynamicObject.get("source"), dynamicObject.get("isemp"), dynamicObject.get("remark"), personId, ctteeperId, dynamicObject.get("userstatus"), entryid, entryid, dynamicObject.get("uniquekey")});
        }
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        super.propertyChanged(changedArgs);
        String name = changedArgs.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"teamtype")) {
            this.changeOrgByTeamType();
        }
    }

    private void changeOrgByTeamType() {
        BasedataEdit group;
        BasedataEdit commOrg;
        String teamType = (String)this.getModel().getValue("teamtype");
        IFormView view = this.getView();
        if (TeamTypeEnum.COMM.getNumber().equals(teamType)) {
            view.setVisible(Boolean.TRUE, new String[]{"commorg"});
            view.setVisible(Boolean.FALSE, new String[]{"group"});
            commOrg = (BasedataEdit)view.getControl("commorg");
            commOrg.setMustInput(true);
            group = (BasedataEdit)view.getControl("group");
            group.setMustInput(false);
            this.getModel().setValue("group", null);
        }
        if (TeamTypeEnum.ORG.getNumber().equals(teamType)) {
            view.setVisible(Boolean.TRUE, new String[]{"group"});
            view.setVisible(Boolean.FALSE, new String[]{"commorg"});
            commOrg = (BasedataEdit)view.getControl("commorg");
            commOrg.setMustInput(false);
            group = (BasedataEdit)view.getControl("group");
            group.setMustInput(true);
            this.getModel().setValue("commorg", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object argsSource = args.getSource();
        FormOperate operate = (FormOperate)argsSource;
        String opKey = operate.getOperateKey();
        if ("save".equals(opKey) || "submit".equals(opKey)) {
            DynamicObjectCollection certcentry = this.getModel().getEntryEntity("certcentry");
            this.getModel().setValue("total", (Object)certcentry.size());
        }
    }

    private Boolean getResetEntryFlag(String opKey) {
        return "save".equals(opKey) || "saveandnew".equals(opKey) || "submit".equals(opKey) || "audit".equals(opKey);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (HRStringUtils.equals((String)key, (String)ADDENTRY)) {
            FormShowParameter showParameter = this.createBaseParameter(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u5458", (String)"CertificationGroupPlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            showParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean success;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        boolean bl = success = operationResult == null || operationResult.isSuccess();
        if (HRStringUtils.equals((String)operateKey, (String)"deleteentry") && success) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"CertificationGroupPlugin_2", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
        }
        if (this.getResetEntryFlag(operateKey).booleanValue()) {
            this.filterQuitPerson();
            this.getModel().setDataChanged(false);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)CERT_MEMBER)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            Map data = CommonUtils.castMap((Object)closedCallBackEvent.getReturnData(), String.class);
            if (CollectionUtils.isEmpty((Map)data)) {
                return;
            }
            String sonPageId = (String)data.get("pageId");
            if (sonPageId.equals(this.getPageCache().get("sonPageId"))) {
                return;
            }
            this.getPageCache().put("sonPageId", sonPageId);
            Integer index = (Integer)data.get("index");
            if (index == null) {
                index = model.createNewEntryRow("certcentry");
            }
            String source = (String)data.get("source");
            if (CertMemberSourceEnum.COMM.getNumber().equals(source)) {
                DynamicObject ctteeper = (DynamicObject)data.get("ctteeper");
                model.setValue("ctteeper", (Object)ctteeper, index.intValue());
                String name = ctteeper.getString("name");
                model.setValue("membername", (Object)name, index.intValue());
                if (ctteeper.getDynamicObject("person") != null) {
                    String empNumber = ctteeper.getDynamicObject("person").getString("empnumber");
                    model.setValue("membernumber", (Object)empNumber, index.intValue());
                    model.setValue("person", (Object)ctteeper.getDynamicObject("person"), index.intValue());
                    model.setValue("uniquekey", (Object)CommUtils.appendStr((String[])new String[]{name, ";", empNumber}), index.intValue());
                } else {
                    String phonenum = ctteeper.getString("phonenum");
                    model.setValue("uniquekey", (Object)CommUtils.appendStr((String[])new String[]{name, ";", phonenum}), index.intValue());
                }
                model.setValue("isemp", (Object)ctteeper.getString("isemp"), index.intValue());
            } else if (CertMemberSourceEnum.OTHER.getNumber().equals(source)) {
                DynamicObject person = (DynamicObject)data.get("person");
                model.setValue("person", (Object)person, index.intValue());
                DynamicObject per = person.getDynamicObject("person");
                model.setValue("membername", (Object)per.getString("name"), index.intValue());
                model.setValue("membernumber", (Object)per.getString("number"), index.intValue());
                model.setValue("isemp", (Object)"1", index.intValue());
                model.setValue("uniquekey", (Object)CommUtils.appendStr((String[])new String[]{per.getString("name"), ";", per.getString("number")}), index.intValue());
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u77e5\u6210\u5458\u6765\u6e90\uff0c\u65b0\u589e\u5931\u8d25\u3002", (String)"CertificationGroupPlugin_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
                logger.info(MessageFormat.format("CertificationGroupPlugin add entry member fail, source not matched, return data is {0}", data));
                model.deleteEntryRow("index", index.intValue());
                return;
            }
            model.setValue("source", (Object)source, index.intValue());
            model.setValue("remark", data.get("remark"), index.intValue());
            Set roleIds = CommonUtils.castSet(data.get("certmbrrole"), Long.class);
            model.setValue("certmbrrole", (Object)roleIds.toArray(new Long[0]), index.intValue());
            model.endInit();
            this.getView().updateView("certcentry");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (fieldName.equals("membername")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("certcentry");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("certcentry", rowIndex);
            DynamicObjectCollection roleCollection = entryRowEntity.getDynamicObjectCollection("certmbrrole");
            Set roleIds = roleCollection.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toSet());
            FormShowParameter showParameter = this.createBaseParameter(ResManager.loadKDString((String)"\u6210\u5458\u4fe1\u606f", (String)"CertificationGroupPlugin_3", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
            BillOperationStatus billStatus = baseShowParameter.getBillStatus();
            if (billStatus.equals((Object)BillOperationStatus.EDIT) || billStatus.equals((Object)BillOperationStatus.ADDNEW)) {
                showParameter.setStatus(OperationStatus.EDIT);
            } else {
                showParameter.setStatus(OperationStatus.VIEW);
            }
            showParameter.setCustomParam("index", (Object)rowIndex);
            showParameter.setCustomParam("certmbrrole", roleIds);
            showParameter.setCustomParam("source", (Object)entryRowEntity.getString("source"));
            showParameter.setCustomParam("remark", (Object)entryRowEntity.getString("remark"));
            showParameter.setCustomParam("person", (Object)entryRowEntity.getLong("person.id"));
            showParameter.setCustomParam("person.person.id", (Object)entryRowEntity.getLong("person.person.id"));
            showParameter.setCustomParam("ctteeper", (Object)entryRowEntity.getLong("ctteeper.id"));
            this.getView().showForm(showParameter);
        }
    }

    private FormShowParameter createBaseParameter(String caption) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tdcs_certmember");
        showParameter.setCaption(caption);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CERT_MEMBER));
        showParameter.setCustomParam(PERSON_ID, (Object)SerializationUtils.serializeToBase64(this.getEmployeeIds()));
        DynamicObject commOrg = (DynamicObject)this.getModel().getValue("commorg");
        showParameter.setCustomParam("commorg", commOrg == null ? null : commOrg.getPkValue());
        return showParameter;
    }

    private Set<String> getEmployeeIds() {
        DynamicObjectCollection entryRows = this.getModel().getDataEntity(true).getDynamicObjectCollection("certcentry");
        HashSet employeeIdSet = Sets.newHashSetWithExpectedSize((int)entryRows.size());
        for (DynamicObject entryRow : entryRows) {
            String personId;
            String source = entryRow.getString("source");
            if (CertMemberSourceEnum.COMM.getNumber().equals(source)) {
                DynamicObject ctterper = entryRow.getDynamicObject("ctteeper");
                if (ctterper == null) continue;
                String ctteeperId = ctterper.getString("person.id");
                personId = HRStringUtils.isNotEmpty((String)ctteeperId) ? ctteeperId : CommUtils.appendStr((String[])new String[]{ctterper.getString("name"), ctterper.getString("phonenum")});
            } else {
                DynamicObject person = entryRow.getDynamicObject("person");
                if (person == null) continue;
                personId = person.getString("id");
            }
            if (!HRStringUtils.isNotEmpty((String)personId) || personId.equals("0")) continue;
            employeeIdSet.add(personId);
        }
        return employeeIdSet;
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        BillShowParameter showParameter = (BillShowParameter)args.getFormShowParameter();
        if (showParameter.getPkId() == null) {
            return;
        }
        long pkId = Long.parseLong(showParameter.getPkId().toString());
        if (pkId != 0L) {
            DynamicObject dynamicObject = this.commOrgApplicationService.queryOneCertificationGroup(Long.valueOf(pkId));
            if ("tdcs_certificationgroup".equals(showParameter.getFormId())) {
                showParameter.setCaption(ResManager.loadKDString((String)"\u8ba4\u8bc1\u7ec4-{0}", (String)"CertificationGroupPlugin_4", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{dynamicObject.getString("name")}));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.formCommonService.setPropertyNotDataChanged(this.getModel(), new String[]{"total"});
    }
}

