/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;

public class BaseInfoPlugin
extends HRCoreBaseBillList {
    private static final ExternalService EXTERNAL_SERVICE = (ExternalService)ServiceFactory.getService(ExternalService.class);
    private static final String NATIVE_PLACE = "nativeplace";
    private static final String JOB = "job";
    private static final String JOB_LEVEL = "joblevel";
    private static final String JOB_GRADE = "jobgrade";
    private static final String JOB_CLASS = "jobclass";
    private static final String JOB_FAMILY = "jobfamily";
    private static final String JOB_SEQ = "jobseq";
    private static final String PHONE = "phone";
    private static final String WORK_PHONE = "workphone";
    private static final String BUS_EMAIL = "busemail";
    private static final String POLITICAL_STATUS = "politicalstatus";
    private static final String PARTY = "party";
    private static final String JOIN_PARTY_DATE = "joinpartydate";
    private static final String NATIONALITY = "nationality";
    private static final String FOLK = "folk";
    private static final String BIRTHDAY = "birthday";
    private static final String BEGIN_SERVICE_DATE = "beginservicedate";
    private static final String ENT_SERVICE_LEN = "entservicelen";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long personId = (Long)formShowParameter.getCustomParam("person");
        Long employeeId = (Long)formShowParameter.getCustomParam("employee");
        this.showBaseInfo(personId);
        this.showParty(personId);
        this.showContact(personId);
        this.showPosition(employeeId);
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    private void showBaseInfo(long personId) {
        Map personInfoMap = EXTERNAL_SERVICE.getPersonInfo(personId);
        if (CollectionUtils.isEmpty((Map)personInfoMap)) {
            return;
        }
        this.getModel().setValue(NATIONALITY, personInfoMap.get("nationality_id"));
        this.getModel().setValue(FOLK, personInfoMap.get("folk_id"));
        this.getModel().setValue(BIRTHDAY, personInfoMap.get(BIRTHDAY));
        this.getModel().setValue(BEGIN_SERVICE_DATE, personInfoMap.get(BEGIN_SERVICE_DATE));
        this.getModel().setValue(ENT_SERVICE_LEN, personInfoMap.get(ENT_SERVICE_LEN));
    }

    private void showParty(long personId) {
        List partyInfoList = EXTERNAL_SERVICE.listPersonAttachs(personId, "hrpi_perregion");
        if (CollectionUtils.isEmpty((Collection)partyInfoList)) {
            return;
        }
        Map result = (Map)partyInfoList.get(0);
        this.getModel().setValue(NATIVE_PLACE, (Object)(ObjectUtils.isEmpty(result.get(NATIVE_PLACE)) ? "" : result.get(NATIVE_PLACE)));
        this.getModel().setValue(POLITICAL_STATUS, result.get("politicalstatus_id"));
        this.getModel().setValue(PARTY, result.get("party_id"));
        this.getModel().setValue(JOIN_PARTY_DATE, result.get(JOIN_PARTY_DATE) == null ? null : (Date)result.get(JOIN_PARTY_DATE));
    }

    private void showContact(long personId) {
        List contactInfoList = EXTERNAL_SERVICE.listPersonAttachs(personId, "hrpi_percontact");
        if (CollectionUtils.isEmpty((Collection)contactInfoList)) {
            return;
        }
        Map contactMap = (Map)contactInfoList.get(0);
        this.getModel().setValue(PHONE, contactMap.get(PHONE));
        this.getModel().setValue(WORK_PHONE, contactMap.get(WORK_PHONE));
        this.getModel().setValue(BUS_EMAIL, contactMap.get(BUS_EMAIL));
    }

    private void showPosition(long employeeId) {
        DynamicObject result = EXTERNAL_SERVICE.getPositionInfo(employeeId);
        if (HRObjectUtils.isEmpty((Object)result)) {
            return;
        }
        this.getModel().setValue(JOB, result.get(JOB));
        this.getModel().setValue(JOB_LEVEL, result.get(JOB_LEVEL));
        this.getModel().setValue(JOB_GRADE, result.get(JOB_GRADE));
        this.getModel().setValue(JOB_CLASS, result.get(JOB_CLASS));
        this.getModel().setValue(JOB_FAMILY, result.get(JOB_FAMILY));
        this.getModel().setValue(JOB_SEQ, result.get(JOB_SEQ));
    }
}

