/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.CommFrameApplicationService;
import kd.tdc.tdcs.bussiness.application.CommOrgApplicationService;
import kd.tdc.tdcs.bussiness.application.external.HbjmJobApplicationService;
import kd.tdc.tdcs.bussiness.formservice.comm.CommOrgService;
import kd.tdc.tdcs.common.bo.NodeBo;
import kd.tdc.tdcs.common.util.CommUtils;

public class CommOrgFormPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
BeforeF7SelectListener,
TabSelectListener {
    private final HbjmJobApplicationService hbjmJobApplicationService = (HbjmJobApplicationService)ServiceFactory.getService(HbjmJobApplicationService.class);
    private final CommOrgApplicationService commOrgApplicationService = (CommOrgApplicationService)ServiceFactory.getService(CommOrgApplicationService.class);
    private final CommFrameApplicationService commFrameApplicationService = (CommFrameApplicationService)ServiceFactory.getService(CommFrameApplicationService.class);
    private static final Log logger = LogFactory.getLog(CommOrgFormPlugin.class);
    private final CommOrgService commOrgService = (CommOrgService)ServiceFactory.getService(CommOrgService.class);
    private final List<String> opNameList = Lists.newArrayList((Object[])new String[]{"save", "saveandnew", "submit", "unsubmit", "audit", "unaudit", "disable", "enable", "insertdata_his", "confirmchange", "confirmchangenoaudit"});

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Search leftSearch = (Search)this.getControl("jobsearchap");
        leftSearch.addEnterListener((SearchEnterListener)this);
        Search rightSearch = (Search)this.getView().getControl("viewsearchap");
        rightSearch.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"btn_addjobscm", "btn_removejobscm", "memberlab", "grouplab"});
        MulBasedataEdit parentCommEdit = (MulBasedataEdit)this.getControl("parentcomm");
        parentCommEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit commFrame = (BasedataEdit)this.getControl("commframe");
        commFrame.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"certificationgroup", "commmember"});
        Tab tabapmsg = (Tab)this.getControl("tabapmsg");
        tabapmsg.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject eve) {
        Map customParams;
        IPageCache pageCache = this.getPageCache();
        this.setModelValue();
        if (StringUtils.isEmpty((CharSequence)pageCache.get("minCommOrgTypeId"))) {
            CommUtils.getMinCommOrtTypeIdAndNum((IFormView)this.getView());
        }
        if ("insertdata_his".equals((customParams = this.getView().getFormShowParameter().getCustomParams()).get("option"))) {
            this.initChangeCsk(pageCache);
            if (HRDateTimeUtils.dayAfter((Date)new Date(), (Date)((Date)this.getModel().getValue("bsed")))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"registerdate"});
            }
        } else {
            this.initNewCsk();
        }
    }

    private void initNewCsk() {
        this.initCskLeftTreeFromDb();
        TreeView rightTree = (TreeView)this.getControl("jobviewtree");
        rightTree.deleteAllNodes();
        this.getPageCache().put("rightTreeCache", null);
        this.cleanControlValue();
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
    }

    private void initChangeCsk(IPageCache pageCache) {
        String currentCommOrgTypeId;
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("commorgtype");
        if (dynamicObject == null) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            currentCommOrgTypeId = customParams.get("currentCommOrgTypeId").toString();
        } else {
            currentCommOrgTypeId = dynamicObject.getPkValue().toString();
        }
        String minCommOrgTypeId = pageCache.get("minCommOrgTypeId");
        if (currentCommOrgTypeId.equals(minCommOrgTypeId)) {
            this.initCskLeftTreeFromDb();
        } else {
            this.initOrSearchJjLeftTreeFromDb(null, "CreateNewData", "initLeftRoot");
        }
        this.initCskRightTreeFromDb();
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
    }

    private void setModelValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        DynamicObject frameFrameObj = this.getModel().getDataEntity().getDynamicObject("commframe");
        if (frameFrameObj != null) {
            Long frameId = frameFrameObj.getLong("id");
            this.setFrameId(frameId);
        } else if (customParams.get("id") != null) {
            Long id = Long.parseLong(customParams.get("id").toString());
            this.setFrameId(id);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"manageflexpanelap"});
        }
        IPageCache pageCache = this.getView().getPageCache();
        if (pageCache.get("framejobscmId") != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mangerjobscmflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tabap"});
        } else if (customParams.get("framejobscmId") != null) {
            pageCache.put("framejobscmId", customParams.get("framejobscmId").toString());
            this.getView().setVisible(Boolean.FALSE, new String[]{"mangerjobscmflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tabap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"mangerjobscmflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabap"});
        }
        pageCache.put("customParamMap", SerializationUtils.toJsonString((Object)customParams));
    }

    private void setFrameId(Long id) {
        this.getModel().setValue("commframe", (Object)id);
        this.getFrameJobScmIds(id);
        this.getView().setVisible(Boolean.TRUE, new String[]{"manageflexpanelap"});
    }

    private void initCskLeftTreeFromDb() {
        IPageCache pageCache = this.getView().getPageCache();
        String framejobscmIds = pageCache.get("framejobscmId");
        List<Long> framejobIdList = this.getFrameJobScmIdList(framejobscmIds);
        if (framejobIdList.size() == 0) {
            return;
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("edittabpage");
        this.constructCskLeftTree(framejobIdList);
    }

    private void initTreeView(String treeCache, String controlName) {
        if (StringUtils.isEmpty((CharSequence)treeCache)) {
            TreeView treeView = (TreeView)this.getControl(controlName);
            treeView.deleteAllNodes();
            treeView.addNode(this.getRootTreeNode());
            treeView.setRootVisible(true);
        }
    }

    private TreeNode getRootTreeNode() {
        TreeNode rootTree = new TreeNode();
        rootTree.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"CommOrgFormPlugin_9", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
        rootTree.setIsOpened(true);
        return rootTree;
    }

    private List<Long> getFrameJobScmIdList(String framejobscmIds) {
        ArrayList<Long> framejobIdList = new ArrayList<Long>(8);
        if (framejobscmIds == null) {
            return framejobIdList;
        }
        if (framejobscmIds.contains(";")) {
            String[] split;
            for (String str : split = framejobscmIds.split(";")) {
                framejobIdList.add(Long.parseLong(str));
            }
        } else {
            framejobIdList.add(Long.parseLong(framejobscmIds));
        }
        return framejobIdList;
    }

    private void constructCskLeftTree(List<Long> framejobIdList) {
        TreeNode rootTree = new TreeNode();
        Map<String, TreeNode> seqTreeNodeMap = this.setScmAndSeqTreeNode(framejobIdList, rootTree);
        Map<String, TreeNode> familyTreeNodeMap = this.setSeqAndFamilyTreeNode(framejobIdList, seqTreeNodeMap);
        this.setFamilyAndClassTreeNode(framejobIdList, familyTreeNodeMap);
        TreeView leftTreeView = (TreeView)this.getControl("jobscmtree");
        leftTreeView.deleteAllNodes();
        leftTreeView.setRootVisible(true);
        leftTreeView.addNodes(rootTree.getChildren());
        IPageCache pageCache = this.getPageCache();
        pageCache.put("initLeftRoot", SerializationUtils.toJsonString((Object)rootTree.getChildren()));
    }

    private void setFamilyAndClassTreeNode(List<Long> framejobIdList, Map<String, TreeNode> familyTreeNodeMap) {
        DynamicObject[] classAndSubClassArr = this.hbjmJobApplicationService.getFamilyAndClassRelation(framejobIdList);
        HashMap<String, ArrayList> classAndSubClassMap = new HashMap<String, ArrayList>(16);
        for (DynamicObject dynamicObject : classAndSubClassArr) {
            if (dynamicObject.get("jobclass") == null) continue;
            String jobclasslevel = ((DynamicObject)dynamicObject.get("jobclass")).getString("jobclasslevel");
            if (classAndSubClassMap.get(jobclasslevel) == null) {
                classAndSubClassMap.put(jobclasslevel, Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
                continue;
            }
            ((List)classAndSubClassMap.get(jobclasslevel)).add(dynamicObject);
        }
        List sortJobclasslevelList = classAndSubClassMap.keySet().stream().sorted().collect(Collectors.toList());
        HashMap<String, TreeNode> classTreeNodeMap = new HashMap<String, TreeNode>(16);
        for (String jobclasslevel : sortJobclasslevelList) {
            if ("1".equals(jobclasslevel)) {
                HashMap<String, List<TreeNode>> familyAndClassNodeListMap = new HashMap<String, List<TreeNode>>(16);
                List classObjects = (List)classAndSubClassMap.get(jobclasslevel);
                for (DynamicObject object : classObjects) {
                    String familyId;
                    String scmId = CommUtils.parseId((DynamicObject)object, (String)"jobscm");
                    if ("0".equals(scmId) || "0".equals(familyId = CommUtils.parseId((DynamicObject)object, (String)"jobfamily"))) continue;
                    String familyUniqueId = CommUtils.appendStr((String[])new String[]{scmId, ":", "jobfamily", familyId});
                    this.parseDataToMap("jobclass", classTreeNodeMap, familyAndClassNodeListMap, object, scmId, familyUniqueId);
                }
                this.doTreeNodeRelation(familyTreeNodeMap, familyAndClassNodeListMap);
                continue;
            }
            HashMap<String, TreeNode> sonClassTreeNodeMap = new HashMap<String, TreeNode>(16);
            HashMap<String, List<TreeNode>> sonClassAndParentClassNodeListMap = new HashMap<String, List<TreeNode>>(16);
            List subClassObjects = (List)classAndSubClassMap.get(jobclasslevel);
            for (DynamicObject object : subClassObjects) {
                String parentClassId;
                DynamicObject parentClassObject;
                String scmId = CommUtils.parseId((DynamicObject)object, (String)"jobscm");
                if ("0".equals(scmId) || (parentClassObject = (DynamicObject)((DynamicObject)object.get("jobclass")).get("parent")) == null || "0".equals(parentClassId = parentClassObject.getString("id"))) continue;
                String parentClassUniqueId = CommUtils.appendStr((String[])new String[]{scmId, ":", "jobclass", parentClassId});
                this.parseDataToMap("jobclass", sonClassTreeNodeMap, sonClassAndParentClassNodeListMap, object, scmId, parentClassUniqueId);
            }
            this.doTreeNodeRelation(classTreeNodeMap, sonClassAndParentClassNodeListMap);
            classTreeNodeMap = sonClassTreeNodeMap;
        }
    }

    private Map<String, TreeNode> setSeqAndFamilyTreeNode(List<Long> framejobIdList, Map<String, TreeNode> seqTreeNodeMap) {
        DynamicObject[] familyArr;
        HashMap<String, TreeNode> familyTreeNodeMap = new HashMap<String, TreeNode>(16);
        HashMap<String, List<TreeNode>> seqAndFamilyNodeListMap = new HashMap<String, List<TreeNode>>(16);
        for (DynamicObject object : familyArr = this.hbjmJobApplicationService.getSeqAndFamilyRelation(framejobIdList)) {
            String seqId;
            String scmId = CommUtils.parseId((DynamicObject)object, (String)"jobscm");
            if ("0".equals(scmId) || "0".equals(seqId = CommUtils.parseId((DynamicObject)object, (String)"jobseq"))) continue;
            String seqUniqueId = CommUtils.appendStr((String[])new String[]{scmId, ":", "jobseq", seqId});
            this.parseDataToMap("jobfamily", familyTreeNodeMap, seqAndFamilyNodeListMap, object, scmId, seqUniqueId);
        }
        this.doTreeNodeRelation(seqTreeNodeMap, seqAndFamilyNodeListMap);
        return familyTreeNodeMap;
    }

    private Map<String, TreeNode> setScmAndSeqTreeNode(List<Long> framejobIdList, TreeNode rootTree) {
        DynamicObject[] sepArr = this.hbjmJobApplicationService.getScmAndSeqRelation(framejobIdList);
        HashMap<String, TreeNode> scmTreeNodeMap = new HashMap<String, TreeNode>(16);
        HashMap<String, TreeNode> seqTreeNodeMap = new HashMap<String, TreeNode>(16);
        HashMap<String, List<TreeNode>> scmAndSeqNodeListMap = new HashMap<String, List<TreeNode>>(16);
        for (DynamicObject object : sepArr) {
            String scmId = CommUtils.parseId((DynamicObject)object, (String)"jobscm");
            if ("0".equals(scmId)) continue;
            String scmName = CommUtils.parseName((DynamicObject)object, (String)"jobscm");
            TreeNode scmTreeNode = new TreeNode(rootTree.getId(), scmId, scmName);
            if (scmTreeNodeMap.get(scmId) == null) {
                rootTree.addChild(scmTreeNode);
                scmTreeNode.setIsOpened(true);
                scmTreeNodeMap.put(scmId, scmTreeNode);
            }
            this.parseDataToMap("jobseq", seqTreeNodeMap, scmAndSeqNodeListMap, object, scmId, scmId);
        }
        this.doTreeNodeRelation(scmTreeNodeMap, scmAndSeqNodeListMap);
        return seqTreeNodeMap;
    }

    private void parseDataToMap(String controlName, Map<String, TreeNode> treeNodeMap, Map<String, List<TreeNode>> relationNodeListMap, DynamicObject dynamicObject, String scmId, String uniqueParentId) {
        String id = CommUtils.parseId((DynamicObject)dynamicObject, (String)controlName);
        if ("0".equals(id)) {
            return;
        }
        String uniqueTreeId = CommUtils.appendStr((String[])new String[]{scmId, ":", controlName, id});
        String name = CommUtils.parseName((DynamicObject)dynamicObject, (String)controlName);
        TreeNode treeNode = new TreeNode(uniqueParentId, uniqueTreeId, name);
        CommUtils.setTreeNodeListMap((TreeNode)treeNode, relationNodeListMap);
        treeNodeMap.putIfAbsent(uniqueTreeId, treeNode);
    }

    private void doTreeNodeRelation(Map<String, TreeNode> fatherTreeNodeMap, Map<String, List<TreeNode>> relationNodeListMap) {
        List sortUniqueId = fatherTreeNodeMap.keySet().stream().sorted().collect(Collectors.toList());
        for (String id : sortUniqueId) {
            List<TreeNode> treeNodes = relationNodeListMap.get(id);
            if (treeNodes == null || treeNodes.size() == 0) continue;
            TreeNode fatherNode = fatherTreeNodeMap.get(id);
            fatherNode.addChildren(treeNodes);
        }
    }

    private void treeviewLoad(Map<String, NodeBo> jobClassNodeBoMap, List<DynamicObject> jobArr, TreeView treeView, String pageCacheKey) {
        HashMap<String, TreeNode> jobScmTreeNodeMap = new HashMap<String, TreeNode>(8);
        HashMap<String, TreeNode> fatherTreeNodeMap = new HashMap<String, TreeNode>(8);
        for (DynamicObject dynamicObject : jobArr) {
            TreeNode jobScmTreeNode;
            String jobScmId = CommUtils.parseId((DynamicObject)dynamicObject, (String)"jobscm");
            if (jobScmTreeNodeMap.get(jobScmId) == null) {
                jobScmTreeNode = new TreeNode(null, jobScmId, CommUtils.parseName((DynamicObject)dynamicObject, (String)"jobscm"), false);
                jobScmTreeNode.setIsOpened(true);
            } else {
                jobScmTreeNode = (TreeNode)jobScmTreeNodeMap.get(jobScmId);
            }
            String treeIdPrefix = CommUtils.appendStr((String[])new String[]{jobScmId, ":"});
            String jobseqKey = this.doTreeLoad(fatherTreeNodeMap, dynamicObject, jobScmTreeNode, "jobseq", treeIdPrefix);
            String jobFamilyKey = this.doTreeLoad(fatherTreeNodeMap, dynamicObject, (TreeNode)fatherTreeNodeMap.get(jobseqKey), "jobfamily", treeIdPrefix);
            this.doJobClassTreeLoad(jobClassNodeBoMap, fatherTreeNodeMap, dynamicObject, (TreeNode)fatherTreeNodeMap.get(jobFamilyKey), "jobclass", treeIdPrefix);
            jobScmTreeNodeMap.put(jobScmId, jobScmTreeNode);
        }
        ArrayList treeNodeList = new ArrayList(jobScmTreeNodeMap.values());
        treeView.deleteAllNodes();
        treeView.addNodes(treeNodeList);
        if (StringUtils.isNotEmpty((CharSequence)pageCacheKey)) {
            IPageCache pageCache = this.getPageCache();
            pageCache.put(pageCacheKey, SerializationUtils.toJsonString(treeNodeList));
        }
    }

    private String doTreeLoad(Map<String, TreeNode> fatherTreeNodeMap, DynamicObject dynamicObject, TreeNode fatherNode, String controlName, String prefix) {
        String jobId = CommUtils.parseId((DynamicObject)dynamicObject, (String)controlName);
        String uniqueId = CommUtils.appendStr((String[])new String[]{prefix, controlName, jobId});
        if (!"0".equals(jobId)) {
            String jobName = CommUtils.parseName((DynamicObject)dynamicObject, (String)controlName);
            if (fatherTreeNodeMap.get(uniqueId) == null) {
                TreeNode tn = new TreeNode(fatherNode.getId(), uniqueId, jobName, false);
                fatherTreeNodeMap.put(uniqueId, tn);
                fatherNode.addChild(tn);
            }
        }
        return uniqueId;
    }

    private String doJobClassTreeLoad(Map<String, NodeBo> jobClassNodeBoMap, Map<String, TreeNode> fatherTreeNodeMap, DynamicObject dynamicObject, TreeNode fatherNode, String controlName, String prefix) {
        String jobId = CommUtils.parseId((DynamicObject)dynamicObject, (String)controlName);
        if (!"0".equals(jobId)) {
            String uniqueId = CommUtils.appendStr((String[])new String[]{prefix, controlName, jobId});
            DynamicObject parentDynamicObject = dynamicObject.getDynamicObject("jobclass").getDynamicObject("parent");
            String jobName = CommUtils.parseName((DynamicObject)dynamicObject, (String)controlName);
            if (parentDynamicObject == null) {
                if (fatherTreeNodeMap.get(uniqueId) == null) {
                    TreeNode tn = new TreeNode(fatherNode.getId(), uniqueId, jobName, false);
                    fatherTreeNodeMap.put(uniqueId, tn);
                    fatherNode.addChild(tn);
                }
            } else {
                this.addLoseTreeNode(jobClassNodeBoMap, fatherTreeNodeMap, fatherNode, prefix, jobId, jobName, controlName);
            }
        }
        return CommUtils.appendStr((String[])new String[]{prefix, jobId});
    }

    private String addLoseTreeNode(Map<String, NodeBo> jobClassNodeBoMap, Map<String, TreeNode> fatherTreeNodeMap, TreeNode fatherNode, String prefix, String jobId, String name, String controlName) {
        if (jobClassNodeBoMap.get(jobId) == null) {
            String uniqueJobId = CommUtils.appendStr((String[])new String[]{prefix, controlName, jobId});
            if (fatherTreeNodeMap.get(uniqueJobId) == null) {
                TreeNode tn = new TreeNode(fatherNode.getId(), CommUtils.appendStr((String[])new String[]{prefix, controlName, jobId}), name, false);
                fatherTreeNodeMap.put(uniqueJobId, tn);
                fatherNode.addChild(tn);
            }
            return uniqueJobId;
        }
        NodeBo nodeBo = jobClassNodeBoMap.get(jobId);
        String parentId = nodeBo.getParentId();
        String parentName = nodeBo.getParentName();
        String parentUniqueJobId = this.addLoseTreeNode(jobClassNodeBoMap, fatherTreeNodeMap, fatherNode, prefix, parentId, parentName, controlName);
        String uniqueJobId = CommUtils.appendStr((String[])new String[]{prefix, controlName, jobId});
        TreeNode fatherTreeNode = fatherTreeNodeMap.get(parentUniqueJobId);
        if (fatherTreeNodeMap.get(uniqueJobId) == null) {
            TreeNode tn = new TreeNode(fatherTreeNode.getId(), uniqueJobId, name, false);
            fatherTreeNodeMap.put(uniqueJobId, tn);
            fatherTreeNode.addChild(tn);
        }
        return uniqueJobId;
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        IPageCache pageCache = this.getPageCache();
        if (pageCache.get("framejobscmId") == null) {
            this.setModelValue();
        }
        if (StringUtils.isEmpty((CharSequence)pageCache.get("minCommOrgTypeId"))) {
            CommUtils.getMinCommOrtTypeIdAndNum((IFormView)this.getView());
        }
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String dataStatus = (String)this.getModel().getValue("status");
        String enable = (String)this.getModel().getValue("enable");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ((OperationStatus.EDIT.equals((Object)operationStatus) || OperationStatus.VIEW.equals((Object)operationStatus)) && !HRStringUtils.equals((String)"A", (String)dataStatus) && !HRStringUtils.equals((String)"10", (String)enable)) {
            this.showJobView(pageCache, customParams);
        } else if (operationStatus.equals((Object)OperationStatus.EDIT) && HRStringUtils.equals((String)"10", (String)enable) && customParams.get("skipCheckFieldRule") == null) {
            this.initChangeCsk(this.getPageCache());
        }
    }

    private void showJobView(IPageCache pageCache, Map<String, Object> customParams) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("viewtabpage");
        this.getView().setVisible(Boolean.FALSE, new String[]{"labelap2", "labelap4"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"tabap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"manageflexpanelap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
        Tab msgTab = (Tab)this.getView().getControl("tabapmsg");
        msgTab.activeTab("commmember");
        this.showRelaMsg("commmember");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjects = dataEntity.getDynamicObjectCollection("jobscmentry");
        this.setEntryValue(dynamicObjects, "pid", "id", "job", "jobscmview");
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("commorgtype");
        String currentCommOrgTypeId = dynamicObject.getPkValue().toString();
        customParams.put("currentCommOrgTypeId", currentCommOrgTypeId);
        pageCache.put("customParamMap", SerializationUtils.toJsonString(customParams));
    }

    private void setEntryValue(DynamicObjectCollection dynamicObjects, String ... fields) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("treeentryentity");
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        for (String field : fields) {
            setter.addField(field, new Object[0]);
        }
        this.setTableValueSetter(setter, dynamicObjects);
        model.batchCreateNewEntryRow("treeentryentity", setter);
        model.endInit();
        this.getView().updateView("treeentryentity");
    }

    private void setTableValueSetter(TableValueSetter setter, DynamicObjectCollection dynamicObjects) {
        HashMap<String, String> idsMap = new HashMap<String, String>(dynamicObjects.size());
        Map<String, NodeBo> jobClassNodeBoMap = this.getParentJobClass((List<DynamicObject>)dynamicObjects);
        HashSet<String> setterSet = new HashSet<String>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String jobClassId;
            String jobFamilyId;
            String jobScmId = CommUtils.parseId((DynamicObject)dynamicObject, (String)"jobscm");
            String jobScmName = this.parseLocalName((DynamicObject)dynamicObject.get("jobscm"));
            String jobSeqId = CommUtils.parseId((DynamicObject)dynamicObject, (String)"jobseq");
            if (!"0".equals(jobSeqId)) {
                String jobSeqName = this.parseLocalName((DynamicObject)dynamicObject.get("jobseq"));
                this.setSetter(setter, jobScmId, this.getJobId(idsMap, jobScmId, jobSeqId, "jobseq"), jobSeqName, jobScmName, setterSet);
            }
            if (!"0".equals(jobFamilyId = CommUtils.parseId((DynamicObject)dynamicObject, (String)"jobfamily"))) {
                String jobFamilyName = this.parseLocalName((DynamicObject)dynamicObject.get("jobfamily"));
                this.setSetter(setter, this.getJobId(idsMap, jobScmId, jobSeqId, "jobseq"), this.getJobId(idsMap, jobScmId, jobFamilyId, "jobfamily"), jobFamilyName, jobScmName, setterSet);
            }
            if ("0".equals(jobClassId = CommUtils.parseId((DynamicObject)dynamicObject, (String)"jobclass"))) continue;
            String jobClassName = this.parseLocalName((DynamicObject)dynamicObject.get("jobclass"));
            if (jobClassNodeBoMap.size() == 0) {
                this.setSetter(setter, this.getJobId(idsMap, jobScmId, jobFamilyId, "jobfamily"), this.getJobId(idsMap, jobScmId, jobClassId, "jobclass"), jobClassName, jobScmName, setterSet);
                continue;
            }
            this.addLoseJobClass(jobClassNodeBoMap, setter, idsMap, jobScmId, jobScmName, jobFamilyId, jobClassId, jobClassName, "jobfamily", setterSet);
        }
    }

    private String addLoseJobClass(Map<String, NodeBo> jobClassNodeBoMap, TableValueSetter setter, Map<String, String> idsMap, String jobScmId, String jobScmName, String parentJobClassId, String jobClassId, String jobClassName, String flag, Set<String> setterSet) {
        if (jobClassNodeBoMap.get(jobClassId) == null) {
            this.setSetter(setter, this.getJobId(idsMap, jobScmId, parentJobClassId, flag), this.getJobId(idsMap, jobScmId, jobClassId, "jobclass"), jobClassName, jobScmName, setterSet);
            return jobClassId;
        }
        NodeBo nodeBo = jobClassNodeBoMap.get(jobClassId);
        String id = nodeBo.getId();
        String name = nodeBo.getName();
        String parentId = nodeBo.getParentId();
        String parentName = nodeBo.getParentName();
        String fatherJobClassId = this.addLoseJobClass(jobClassNodeBoMap, setter, idsMap, jobScmId, jobScmName, parentJobClassId, parentId, parentName, flag, setterSet);
        this.setSetter(setter, this.getJobId(idsMap, jobScmId, fatherJobClassId, "jobclass"), this.getJobId(idsMap, jobScmId, id, "jobclass"), name, jobScmName, setterSet);
        return id;
    }

    private String getJobId(Map<String, String> idsMap, String jobId1, String jobId2, String flag) {
        String uniqueId = CommUtils.appendStr((String[])new String[]{jobId1, jobId2, flag});
        if (idsMap.get(uniqueId) != null) {
            return idsMap.get(uniqueId);
        }
        String id = Long.valueOf(ORM.create().genLongId("tdcs_commorg")).toString();
        idsMap.put(uniqueId, id);
        return id;
    }

    private String parseLocalName(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return "";
        }
        return dynamicObject.getString("name");
    }

    private void setSetter(TableValueSetter setter, String parentId, String id, String job, String jobscmview, Set<String> setterSet) {
        if (setterSet.add(id) && !"0".equals(id) && StringUtils.isNotEmpty((CharSequence)job) && StringUtils.isNotEmpty((CharSequence)jobscmview)) {
            setter.addRow(new Object[]{parentId, id, job, jobscmview});
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.setCommOrgControlVisible();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object fromPage = customParams.get("fromPage");
        Object hisAction = customParams.get("his_action");
        if (fromPage != null && hisAction != null && fromPage.toString().equals("fromHisAction") && hisAction.toString().equals("open_insert_data_page")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
        }
    }

    private void setCommOrgControlVisible() {
        IPageCache pageCache = this.getView().getPageCache();
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("commorgtype");
        if (dynamicObject == null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"commframe"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"parentcomm"});
        } else {
            String currentCommOrgTypeId = dynamicObject.getPkValue().toString();
            String minCommOrgTypeId = pageCache.get("minCommOrgTypeId");
            if (minCommOrgTypeId.equals(currentCommOrgTypeId)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"commframe"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"parentcomm"});
            } else {
                this.setParentCommEnable();
                this.getView().setVisible(Boolean.TRUE, new String[]{"parentcomm"});
                BasedataEdit control = (BasedataEdit)this.getControl("parentcomm");
                control.setMustInput(true);
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"hisversionbtn"});
    }

    private void setParentCommEnable() {
        DynamicObject commFrameObj = this.getModel().getDataEntity().getDynamicObject("commframe");
        if (commFrameObj == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"parentcomm"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"parentcomm"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject frameObj;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        logger.info(MessageFormat.format("\u5f53\u524d\u89e6\u53d1\u7684\u6309\u94ae\u7684key\u4e3a\uff1a{0}", formOperate.getOperateKey()));
        if ("save".equals(operateKey) || this.isConfireChangeBtn(operateKey)) {
            IPageCache pageCache;
            String framejobscmIds;
            Boolean registerDateflag = this.compareRegisterDateAndBsed();
            if (!registerDateflag.booleanValue()) {
                args.setCancel(true);
            }
            if (!this.compareBesdAndFirstbsed().booleanValue()) {
                args.setCancel(true);
            }
            if (StringUtils.isEmpty((CharSequence)(framejobscmIds = (pageCache = this.getView().getPageCache()).get("framejobscmId")))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u7ba1\u7406\u4fe1\u606f\u201d\u9762\u677f\u70b9\u51fb\u201c\u7ba1\u7406\u804c\u4f4d\u4f53\u7cfb\u201d\u6dfb\u52a0\u804c\u4f4d\u4f53\u7cfb\u65b9\u6848\u3002", (String)"CommOrgFormPlugin_10", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
        if ("addframejobscm".equals(operateKey) && (frameObj = (DynamicObject)this.getModel().getValue("commframe")) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e13\u59d4\u4f1a\u67b6\u6784\u9875\u9762\u72b6\u6001\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CommOrgFormPlugin_12", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        boolean needCheckCommFrame = this.opNameList.stream().anyMatch(e -> e.equals(operateKey));
        Long commframeId = this.getModel().getDataEntity().getLong("commframe.id");
        String bizObjName = this.getView().getEntityId();
        if (needCheckCommFrame && !this.commOrgService.canUserCommFrame(commframeId, bizObjName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"{0}\u7684\u529f\u80fd\u6743\u9650\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6240\u5c5e\u67b6\u6784\u3002", (String)"CommOrgStdTreeListPlugin_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{this.getModel().getDataEntity().getString("commframe.name")}));
            args.setCancel(true);
        }
    }

    private boolean isConfireChangeBtn(String opKey) {
        return "confirmchange".equals(opKey) || "auditconfirmchange".equals(opKey) || "confirmchangenoaudit".equals(opKey);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ((this.isConfireChangeBtn(args.getOperateKey()) || "submit".equals(args.getOperateKey()) || "audit".equals(args.getOperateKey())) && args.getOperationResult().isSuccess()) {
            this.showJobView(this.getPageCache(), this.getView().getFormShowParameter().getCustomParams());
            this.setCommOrgControlVisible();
        }
        if (("unsubmit".equals(args.getOperateKey()) || "unaudit".equals(args.getOperateKey()) || "revise".equals(args.getOperateKey())) && args.getOperationResult().isSuccess()) {
            this.setCommOrgControlVisible();
            this.initChangeCsk(this.getPageCache());
        }
        if ((this.isConfireChangeBtn(args.getOperateKey()) || "submit".equals(args.getOperateKey()) || "audit".equals(args.getOperateKey()) || "save".equals(args.getOperateKey())) && args.getOperationResult().isSuccess()) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("commframe");
            Long frameId = dynamicObject.getLong("id");
            this.commOrgApplicationService.updateCommOrgSize(frameId, dynamicObject);
        }
        if ("addframejobscm".equals(args.getOperateKey())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tdcs_framejobscm");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            DynamicObject frameObj = this.getModel().getDataEntity().getDynamicObject("commframe");
            paramMap.put("id", frameObj.getLong("id"));
            paramMap.put("name", frameObj.getString("name"));
            showParameter.setCustomParams(paramMap);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setframejobscm"));
            this.getView().showForm(showParameter);
        }
    }

    public void beforeClosed(BeforeClosedEvent args) {
        super.beforeClosed(args);
        String status = (String)this.getModel().getValue("status");
        if (HRStringUtils.equals((String)"B", (String)status)) {
            this.getModel().setDataChanged(false);
        }
        HashMap<String, Long> returnDataMap = new HashMap<String, Long>(8);
        DynamicObject frameFrameObj = this.getModel().getDataEntity().getDynamicObject("commframe");
        if (frameFrameObj != null) {
            Long frameId = frameFrameObj.getLong("id");
            returnDataMap.put("id", frameId);
        }
        this.getView().returnDataToParent(returnDataMap);
    }

    private void parseTreeAndSetEntry() {
        IPageCache pageCache = this.getView().getPageCache();
        String rightRootString = pageCache.get("rightTreeCache");
        if (StringUtils.isEmpty((CharSequence)rightRootString)) {
            return;
        }
        List rightTreeNodeList = SerializationUtils.fromJsonStringToList((String)rightRootString, TreeNode.class);
        ArrayList<String> pathStrList = new ArrayList<String>(8);
        for (TreeNode treeNode : rightTreeNodeList) {
            this.getTreePath(treeNode, treeNode.getId(), pathStrList, CommUtils.appendStr((String[])new String[]{treeNode.getId(), ":"}));
        }
        this.setDataEntity(pathStrList);
    }

    private void getTreePath(TreeNode fatherTreeNode, String pathStr, List<String> pathStrList, String replaceStr) {
        if (CollectionUtils.isEmpty((Collection)fatherTreeNode.getChildren())) {
            pathStrList.add(pathStr);
            return;
        }
        for (TreeNode treeNode : fatherTreeNode.getChildren()) {
            String appendStr = CommUtils.appendStr((String[])new String[]{";", treeNode.getId()}).replace(replaceStr, "");
            pathStr = pathStr + appendStr;
            this.getTreePath(treeNode, pathStr, pathStrList, replaceStr);
            pathStr = pathStr.replace(appendStr, "");
        }
    }

    private void setDataEntity(List<String> pathStrList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("jobscmentry");
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("jobscm", new Object[0]);
        setter.addField("jobseq", new Object[0]);
        setter.addField("jobfamily", new Object[0]);
        setter.addField("jobclass", new Object[0]);
        for (String str : pathStrList) {
            String[] jobIdArr = str.split(";");
            if (jobIdArr.length <= 4) {
                setter.addRow(new Object[]{this.getJobId(jobIdArr, 0), this.getJobId(jobIdArr, 1), this.getJobId(jobIdArr, 2), this.getJobId(jobIdArr, 3)});
                continue;
            }
            setter.addRow(new Object[]{this.getJobId(jobIdArr, 0), this.getJobId(jobIdArr, 1), this.getJobId(jobIdArr, 2), this.getJobId(jobIdArr, jobIdArr.length - 1)});
        }
        model.batchCreateNewEntryRow("jobscmentry", setter);
        model.endInit();
        this.getView().updateView("jobscmentry");
    }

    private Long getJobId(String[] jobIdArr, int index) {
        String value;
        try {
            value = jobIdArr[index].replaceAll("jobseq", "").replaceAll("jobfamily", "").replaceAll("jobclass", "");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            value = "0";
        }
        return Long.parseLong(value);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String changeProperty = args.getProperty().getName();
        if ("commorgtype".equals(changeProperty)) {
            this.setControlVisibleByCommOrgType(args);
        }
        if ("commframe".equals(changeProperty)) {
            this.changeCommFrame(args);
        }
        if ("bsed".equals(changeProperty) || "registerdate".equals(changeProperty)) {
            this.compareRegisterDateAndBsed();
        }
        if ("bsed".equals(changeProperty) || "parentcomm".equals(changeProperty)) {
            this.compareBesdAndFirstbsed();
        }
        if ("parentcomm".equals(changeProperty) && ((DynamicObjectCollection)this.getModel().getValue("parentcomm")).size() > 0) {
            this.initOrSearchJjLeftTreeFromDb(null, "change", "initLeftRoot");
        }
        if ("framejobscm".equals(changeProperty)) {
            this.resetCsk("jobsearchap", "initLeftRoot", "jobscmtree");
            this.resetCsk("viewsearchap", "rightTreeCache", "jobviewtree");
            DynamicObjectCollection jobScmObjs = this.getModel().getDataEntity().getDynamicObjectCollection("framejobscm");
            if (!CollectionUtils.isEmpty((Collection)jobScmObjs)) {
                List<Long> jobScmIds = jobScmObjs.stream().map(d -> d.getLong("fbasedataid_id")).collect(Collectors.toList());
                this.constructCskLeftTree(jobScmIds);
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("jobscmentry");
        }
    }

    private void resetCsk(String searchControlName, String cacheKey, String treeControlName) {
        Search search = (Search)this.getControl(searchControlName);
        search.setSearchKey("");
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put(cacheKey, null);
        this.initTreeView(pageCache.get(cacheKey), treeControlName);
    }

    private void setControlVisibleByCommOrgType(PropertyChangedArgs args) {
        ChangeData[] changeSet = args.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            if (changeSet[0].getOldValue() == null) {
                IPageCache pageCache = this.getView().getPageCache();
                DynamicObject commorgtypeDyObj = (DynamicObject)this.getView().getModel().getValue("commorgtype");
                String number = commorgtypeDyObj.getString("number");
                if (number != null && number.equals(pageCache.get("minCommOrgTypeNumber"))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"commframe"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"parentcomm"});
                } else {
                    this.setParentCommEnable();
                    this.getView().setVisible(Boolean.TRUE, new String[]{"parentcomm"});
                    MulBasedataEdit control = (MulBasedataEdit)this.getControl("parentcomm");
                    control.setMustInput(true);
                }
            } else {
                this.getPageCache().put("oldCommOrgTypeId", ((DynamicObject)changeSet[0].getOldValue()).getString("id"));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e13\u59d4\u4f1a\u7ec4\u7ec7\u7c7b\u578b\u540e\uff0c\u5c06\u6e05\u9664\u9875\u9762\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"CommOrgFormPlugin_7", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("commorgTypeSureChange", (IFormPlugin)this));
            }
        }
    }

    private void changeCommFrame(PropertyChangedArgs args) {
        DynamicObject frameFrameObj = this.getModel().getDataEntity().getDynamicObject("commframe");
        if (frameFrameObj != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"manageflexpanelap"});
        }
        this.setParentCommEnable();
        ChangeData[] changeSet = args.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            if (changeSet[0].getOldValue() != null) {
                this.getPageCache().put("oldcommframe", ((DynamicObject)changeSet[0].getOldValue()).getString("id"));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u5c5e\u67b6\u6784\u5207\u6362\u540e\uff0c\u5c06\u6e05\u9664\u7ba1\u7406\u804c\u4f4d\u4f53\u7cfb\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"CommOrgFormPlugin_11", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("commFrameSureChange", (IFormPlugin)this));
            } else {
                this.commFramChangeInit();
            }
        }
    }

    private void commFramChangeInit() {
        DynamicObject frameFrameObj = this.getModel().getDataEntity().getDynamicObject("commframe");
        IPageCache pageCache = this.getView().getPageCache();
        if (frameFrameObj != null) {
            Long frameId = frameFrameObj.getLong("id");
            this.getFrameJobScmIds(frameId);
            if (pageCache.get("framejobscmId") == null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"mangerjobscmflex"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tabap"});
                return;
            }
            this.doCommFramChangeInit();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("commorgTypeSureChange".equals(event.getCallBackId()) && "Yes".equals(event.getResultValue())) {
            this.cleanControlValue();
            this.initCskLeftTreeFromDb();
            TreeView rightTree = (TreeView)this.getControl("jobviewtree");
            rightTree.deleteAllNodes();
            this.setCommOrgControlVisible();
            this.getPageCache().put("rightTreeCache", null);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("jobscmentry");
        } else if ("commorgTypeSureChange".equals(event.getCallBackId()) && "No".equals(event.getResultValue())) {
            Long oldCommOrgTypeId = Long.parseLong(this.getPageCache().get("oldCommOrgTypeId"));
            this.getModel().beginInit();
            this.getModel().setValue("commorgtype", (Object)oldCommOrgTypeId);
            this.getView().updateView();
            this.getModel().endInit();
        }
        if ("commFrameSureChange".equals(event.getCallBackId()) && "Yes".equals(event.getResultValue())) {
            this.commFramChangeInit();
        } else if ("commFrameSureChange".equals(event.getCallBackId()) && "No".equals(event.getResultValue())) {
            Long oldCommFrameId = Long.parseLong(this.getPageCache().get("oldcommframe"));
            this.getModel().beginInit();
            this.getModel().setValue("commframe", (Object)oldCommFrameId);
            this.getView().updateView();
            this.getModel().endInit();
        }
        DynamicObject frameFrameObj = this.getModel().getDataEntity().getDynamicObject("commframe");
        if (frameFrameObj == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"manageflexpanelap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"manageflexpanelap"});
        }
    }

    private void doCommFramChangeInit() {
        this.initCskLeftTreeFromDb();
        TreeView rightTree = (TreeView)this.getControl("jobviewtree");
        rightTree.deleteAllNodes();
        this.getPageCache().put("rightTreeCache", null);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("jobscmentry");
        Object frameObj = this.getModel().getValue("commframe");
        if (frameObj != null) {
            long frameId = ((DynamicObject)this.getModel().getValue("commframe")).getLong("id");
            this.getFrameJobScmIds(frameId);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"mangerjobscmflex"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"tabap"});
        this.initNewCsk();
    }

    private void getFrameJobScmIds(Long frameId) {
        DynamicObject[] commFrameByIdArr = this.commFrameApplicationService.getCommFrameById((Object)frameId);
        if (commFrameByIdArr == null) {
            return;
        }
        DynamicObject commFrameObj = commFrameByIdArr[0];
        DynamicObjectCollection framejobscm = commFrameObj.getDynamicObjectCollection("framejobscm");
        if (framejobscm == null) {
            return;
        }
        String frameJobScmIds = CommUtils.appendMulitBaseId((DynamicObjectCollection)framejobscm, (String)";");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("framejobscmId", frameJobScmIds);
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("framejobscmId", frameJobScmIds);
    }

    private void cleanControlValue() {
        this.getModel().setValue("parentcomm", null);
        this.getModel().setValue("adminorg", null);
        this.getModel().setValue("area", null);
        Search leftSearch = (Search)this.getControl("jobsearchap");
        leftSearch.setSearchKey("");
        Search rightSearch = (Search)this.getControl("viewsearchap");
        rightSearch.setSearchKey("");
    }

    private Boolean compareRegisterDateAndBsed() {
        Date registerDateValue = (Date)this.getModel().getValue("registerdate");
        Date bsedValue = (Date)this.getModel().getValue("bsed");
        if (registerDateValue != null && bsedValue != null && bsedValue.before(registerDateValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6210\u7acb\u65e5\u671f\u3002", (String)"CommOrgFormPlugin_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean compareBesdAndFirstbsed() {
        DynamicObjectCollection parentComms = (DynamicObjectCollection)this.getView().getModel().getValue("parentcomm");
        Date bsedValue = (Date)this.getModel().getValue("bsed");
        if (parentComms.size() > 0 && bsedValue != null) {
            Date maxBsed = new Date(HRBaseConstants.MAX_LOSEEFFECTDATETIME);
            for (int i = 0; i < parentComms.size(); ++i) {
                Date parentBesdDate = (Date)((DynamicObject)parentComms.get(0)).getDynamicObject("fbasedataid").get("bsed");
                if (!parentBesdDate.before(maxBsed)) continue;
                maxBsed = parentBesdDate;
            }
            if (bsedValue.before(maxBsed)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4e0a\u7ea7\u4e13\u59d4\u4f1a\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u3002", (String)"CommOrgFormPlugin_2", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private void initOrSearchJjLeftTreeFromDb(String seachText, String methodFlag, String cacheKey) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("edittabpage");
        this.getView().setVisible(Boolean.TRUE, new String[]{"tabap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"manageflexpanelap"});
        DynamicObjectCollection parentComms = (DynamicObjectCollection)this.getModel().getValue("parentcomm");
        ArrayList<Long> parentCommIdList = new ArrayList<Long>(8);
        for (DynamicObject parentComm : parentComms) {
            if (parentComm.getDynamicObject("fbasedataid") == null) continue;
            parentCommIdList.add(parentComm.getDynamicObject("fbasedataid").getLong("id"));
        }
        DynamicObject[] commOrgDynamicObjs = this.commOrgApplicationService.queryParentCommOrgJobData(parentCommIdList);
        TreeView rightTree = (TreeView)this.getControl("jobviewtree");
        if (commOrgDynamicObjs.length == 0) {
            ((TreeView)this.getControl("jobscmtree")).deleteAllNodes();
            rightTree.deleteAllNodes();
            return;
        }
        HashMap map = new HashMap(commOrgDynamicObjs.length);
        for (DynamicObject commOrgObj : commOrgDynamicObjs) {
            DynamicObjectCollection jobCollection = (DynamicObjectCollection)commOrgObj.get("jobscmentry");
            for (DynamicObject jobObj : jobCollection) {
                if (StringUtils.isNotEmpty((CharSequence)seachText)) {
                    String jobscmName = CommUtils.parseName((DynamicObject)jobObj, (String)"jobscm");
                    String jobseqName = CommUtils.parseName((DynamicObject)jobObj, (String)"jobseq");
                    String jobFamilyName = CommUtils.parseName((DynamicObject)jobObj, (String)"jobfamily");
                    String jobclassName = CommUtils.parseName((DynamicObject)jobObj, (String)"jobclass");
                    String uniqueName = CommUtils.appendStr((String[])new String[]{jobscmName, ";", jobseqName, ";", jobFamilyName, ";", jobclassName});
                    if (!uniqueName.contains(seachText)) continue;
                }
                String jobscmId = CommUtils.parseId((DynamicObject)jobObj, (String)"jobscm");
                String jobseqId = CommUtils.parseId((DynamicObject)jobObj, (String)"jobseq");
                String jobFamilyId = CommUtils.parseId((DynamicObject)jobObj, (String)"jobfamily");
                String jobclassId = CommUtils.parseId((DynamicObject)jobObj, (String)"jobclass");
                String uniqueId = CommUtils.appendStr((String[])new String[]{jobscmId, jobseqId, jobFamilyId, jobclassId});
                if (map.get(uniqueId) == null) {
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
                    list.add(jobObj);
                    map.put(uniqueId, list);
                    continue;
                }
                ((List)map.get(uniqueId)).add(jobObj);
            }
        }
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(8);
        for (List objList : map.values()) {
            if (parentCommIdList.size() != objList.size()) continue;
            dynamicObjectList.add((DynamicObject)objList.get(0));
        }
        Map<String, NodeBo> jobClassNodeBoMap = this.getParentJobClass(dynamicObjectList);
        this.treeviewLoad(jobClassNodeBoMap, dynamicObjectList, (TreeView)this.getControl("jobscmtree"), cacheKey);
        if ("change".equals(methodFlag)) {
            rightTree.deleteAllNodes();
            this.getPageCache().put("rightTreeCache", null);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("jobscmentry");
        }
    }

    private void initCskRightTreeFromDb() {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("edittabpage");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long currentCommOrgId = (Long)customParams.get("currentDataId");
        if (currentCommOrgId == null) {
            currentCommOrgId = (Long)this.getModel().getDataEntity().getPkValue();
        }
        DynamicObject[] commOrgDynamicObjs = this.commOrgApplicationService.queryParentCommOrgJobData((List)Lists.newArrayList((Object[])new Long[]{currentCommOrgId}));
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(8);
        for (DynamicObject commOrgObj : commOrgDynamicObjs) {
            DynamicObjectCollection jobCollection = (DynamicObjectCollection)commOrgObj.get("jobscmentry");
            dynamicObjectList.addAll((Collection<DynamicObject>)jobCollection);
        }
        Map<String, NodeBo> jobClassNodeBoMap = this.getParentJobClass(dynamicObjectList);
        this.treeviewLoad(jobClassNodeBoMap, dynamicObjectList, (TreeView)this.getControl("jobviewtree"), "rightTreeCache");
    }

    private Map<String, NodeBo> getParentJobClass(List<DynamicObject> dynamicObjectList) {
        ArrayList<Long> haveSubClassIdList = new ArrayList<Long>(8);
        for (DynamicObject dynamicObject : dynamicObjectList) {
            DynamicObject parentJobClassObj;
            DynamicObject jobClassObj = dynamicObject.getDynamicObject("jobclass");
            if (jobClassObj == null || (parentJobClassObj = jobClassObj.getDynamicObject("parent")) == null) continue;
            Long jobFamilyId = jobClassObj.getDynamicObject("jobfamily").getLong("id");
            haveSubClassIdList.add(jobFamilyId);
        }
        HashMap<String, NodeBo> subClassAndClassMap = new HashMap<String, NodeBo>(16);
        if (haveSubClassIdList.size() > 0) {
            DynamicObject[] jobClassHrObjs;
            for (DynamicObject jobClassObj : jobClassHrObjs = this.hbjmJobApplicationService.getClassHrData(haveSubClassIdList)) {
                DynamicObject parentJobClassObj = jobClassObj.getDynamicObject("parent");
                if (parentJobClassObj == null) continue;
                String parentId = parentJobClassObj.getString("id");
                String parentName = parentJobClassObj.getString("name");
                String id = jobClassObj.getString("id");
                String name = jobClassObj.getString("name");
                subClassAndClassMap.put(id, new NodeBo(parentId, parentName, id, name));
            }
        }
        return subClassAndClassMap;
    }

    public void click(EventObject evt) {
        Long commOrgId;
        super.click(evt);
        Control source = (Control)evt.getSource();
        IPageCache pageCache = this.getPageCache();
        if ("btn_addjobscm".equals(source.getKey())) {
            this.refreshRightTreeFromCache(pageCache, "initLeftRoot", "jobscmtree");
        }
        if ("btn_removejobscm".equals(source.getKey())) {
            this.refreshRightTreeFromCache(pageCache, "rightTreeCache", "jobviewtree");
        }
        if ((commOrgId = (Long)((BillShowParameter)this.getView().getFormShowParameter()).getPkId()) == null) {
            commOrgId = this.getModel().getDataEntity().getLong("boid");
        }
        String commOrgName = this.getModel().getDataEntity().getString("name");
        if (commOrgId != null && "memberlab".equals(source.getKey())) {
            this.setParameter(commOrgId, commOrgName, "tdcs_commorguser", new QFilter("comm", "=", (Object)commOrgId));
        } else if (commOrgId != null && "grouplab".equals(source.getKey())) {
            this.setParameter(commOrgId, commOrgName, "tdcs_certificationgroup", new QFilter("commorg", "=", (Object)commOrgId));
        }
    }

    private void setParameter(Long commOrgId, String commOrgName, String billFormId, QFilter filter) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId(billFormId);
        showParameter.setCustomParam("commOrgId", (Object)commOrgId);
        showParameter.setCustomParam("commOrgName", (Object)commOrgName);
        showParameter.getListFilterParameter().setFilter(filter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void refreshRightTreeFromCache(IPageCache pageCache, String cacheTreeNodeKey, String treeControlName) {
        TreeNode rightRoot = new TreeNode();
        String cacheRootJsonString = pageCache.get(cacheTreeNodeKey);
        if (cacheRootJsonString == null) {
            return;
        }
        List cacheNodeList = SerializationUtils.fromJsonStringToList((String)cacheRootJsonString, TreeNode.class);
        TreeView treeView = (TreeView)this.getControl(treeControlName);
        List selectedNodeId = treeView.getTreeState().getSelectedNodeId();
        if (selectedNodeId.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u6570\u636e\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CommOrgFormPlugin_5", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<String> selectedSet = new HashSet<String>(selectedNodeId);
        if ("jobscmtree".equals(treeControlName)) {
            String leftRootJsonString = pageCache.get("initLeftRoot");
            this.addLoseId(selectedSet, selectedNodeId, leftRootJsonString);
            String rightRootJsonString = pageCache.get("rightTreeCache");
            if (StringUtils.isNotEmpty((CharSequence)rightRootJsonString)) {
                List rightNodeList = SerializationUtils.fromJsonStringToList((String)rightRootJsonString, TreeNode.class);
                List rightTreeIds = CommUtils.getAllTreeIdFromTreeNode((List)rightNodeList);
                selectedSet.addAll(rightTreeIds);
            }
        }
        rightRoot.addChildren(cacheNodeList);
        Predicate<TreeNode> predicate = "initLeftRoot".equals(cacheTreeNodeKey) ? treeNode -> !selectedSet.contains(treeNode.getId()) : treeNode -> selectedSet.contains(treeNode.getId());
        ArrayList<String> deleteIdList = new ArrayList<String>(8);
        this.getDeleteIdList(cacheNodeList, deleteIdList, predicate);
        for (String id : deleteIdList) {
            rightRoot.deleteChildNode(id);
        }
        TreeView rightTreeView = (TreeView)this.getControl("jobviewtree");
        rightTreeView.deleteAllNodes();
        rightRoot.setIsOpened(true);
        this.openCskRightTree(rightRoot);
        rightTreeView.addNode(rightRoot);
        rightTreeView.setRootVisible(false);
        List children = rightRoot.getChildren();
        pageCache.put("rightTreeCache", SerializationUtils.toJsonString((Object)children));
        this.parseTreeAndSetEntry();
    }

    private void addLoseId(Set<String> set, List<String> selectedNodeIds, String leftRootJsonString) {
        Map<String, String> rootKeyMap = set.stream().collect(Collectors.toMap(str -> str.split(":")[0], str -> str, (oldValue, newValue) -> newValue));
        set.addAll(rootKeyMap.keySet());
        List leftNodeList = SerializationUtils.fromJsonStringToList((String)leftRootJsonString, TreeNode.class);
        for (TreeNode treeNode : leftNodeList) {
            if (!set.contains(treeNode.getId())) continue;
            ArrayList<String> maybeNeedAddIdList = new ArrayList<String>(8);
            this.getLostPartId(maybeNeedAddIdList, treeNode, set, selectedNodeIds);
        }
    }

    private void getLostPartId(List<String> maybeNeedAddIdList, TreeNode parentTreeNode, Set<String> set, List<String> selectedNodeIds) {
        if (parentTreeNode.getChildren() == null) {
            if (selectedNodeIds.contains(parentTreeNode.getId())) {
                set.addAll(maybeNeedAddIdList);
            }
            return;
        }
        for (TreeNode treeNode : parentTreeNode.getChildren()) {
            String id = treeNode.getId();
            maybeNeedAddIdList.add(id);
            this.getLostPartId(maybeNeedAddIdList, treeNode, set, selectedNodeIds);
            maybeNeedAddIdList.remove(id);
        }
    }

    private void openCskRightTree(TreeNode parentTree) {
        if (parentTree.getChildren() == null) {
            return;
        }
        for (TreeNode treeNode : parentTree.getChildren()) {
            treeNode.setIsOpened(true);
            this.openCskRightTree(treeNode);
        }
    }

    private void getDeleteIdList(List<TreeNode> rightChildren, List<String> deleteidList, Predicate<TreeNode> predicate) {
        if (rightChildren == null || rightChildren.size() == 0) {
            return;
        }
        for (TreeNode treeNode : rightChildren) {
            if (predicate.test(treeNode)) {
                deleteidList.add(treeNode.getId());
            }
            this.getDeleteIdList(treeNode.getChildren(), deleteidList, predicate);
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        Search search = (Search)searchEnterEvent.getSource();
        String searchText = searchEnterEvent.getText().trim();
        if (StringUtils.equals((CharSequence)"jobsearchap", (CharSequence)search.getKey())) {
            this.treeSeach(searchText, "initLeftRoot", "jobscmtree");
        }
        if (StringUtils.equals((CharSequence)"viewsearchap", (CharSequence)search.getKey())) {
            this.treeSeach(searchText, "rightTreeCache", "jobviewtree");
        }
    }

    private void treeSeach(String searchText, String cacheTreeNodeKey, String controlName) {
        TreeView treeView = (TreeView)this.getControl(controlName);
        IPageCache pageCache = this.getPageCache();
        String rootString = pageCache.get(cacheTreeNodeKey);
        if (StringUtils.isEmpty((CharSequence)rootString)) {
            treeView.deleteAllNodes();
            return;
        }
        List treeNodeList = SerializationUtils.fromJsonStringToList((String)rootString, TreeNode.class);
        TreeNode rootTreeNode = new TreeNode();
        if ("".equals(searchText)) {
            treeView.deleteAllNodes();
            rootTreeNode.setIsOpened(true);
            rootTreeNode.addChildren(treeNodeList);
            treeView.addNode(rootTreeNode);
            treeView.setRootVisible(false);
        } else {
            this.doSearch(searchText, treeView, treeNodeList, rootTreeNode);
        }
    }

    private void doSearch(String searchText, TreeView treeView, List<TreeNode> treeNodeList, TreeNode rootTreeNode) {
        ArrayList<String> containsTextIdPathList = new ArrayList<String>(8);
        ArrayList<String> allTreeIdList = new ArrayList<String>(8);
        for (TreeNode treeNode : treeNodeList) {
            allTreeIdList.add(treeNode.getId());
            this.getContainsSearchTextPathIds(treeNode, treeNode.getId(), treeNode.getText(), containsTextIdPathList, allTreeIdList, searchText);
        }
        if (CollectionUtils.isEmpty(containsTextIdPathList)) {
            treeView.deleteAllNodes();
            rootTreeNode.setIsOpened(true);
            treeView.addNode(rootTreeNode);
            treeView.setRootVisible(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"CommOrgFormPlugin_6", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            return;
        }
        rootTreeNode.addChildren(treeNodeList);
        HashSet<String> containsTextIdSet = new HashSet<String>(16);
        for (String longId : containsTextIdPathList) {
            String[] ids = longId.split(";");
            containsTextIdSet.addAll(Arrays.asList(ids));
        }
        for (String id : allTreeIdList) {
            if (containsTextIdSet.contains(id)) continue;
            rootTreeNode.deleteChildNode(id);
        }
        for (TreeNode treeNode : rootTreeNode.getChildren()) {
            boolean containSearchTextFlag = CommUtils.unfoldTreeContainKey((TreeNode)treeNode, (String)searchText, (boolean)false);
            if (!containSearchTextFlag) continue;
            treeNode.setIsOpened(containSearchTextFlag);
        }
        treeView.deleteAllNodes();
        rootTreeNode.setIsOpened(true);
        treeView.addNode(rootTreeNode);
        treeView.setRootVisible(false);
    }

    private void getContainsSearchTextPathIds(TreeNode fatherTreeNode, String idStr, String textStr, List<String> containsTextIdPathList, List<String> allTreeIdList, String searchText) {
        if (CollectionUtils.isEmpty((Collection)fatherTreeNode.getChildren())) {
            if (textStr.contains(searchText)) {
                containsTextIdPathList.add(idStr);
            }
            return;
        }
        for (TreeNode treeNode : fatherTreeNode.getChildren()) {
            allTreeIdList.add(treeNode.getId());
            String appendIdStr = CommUtils.appendStr((String[])new String[]{";", treeNode.getId()});
            String appendTextStr = CommUtils.appendStr((String[])new String[]{";", treeNode.getText()});
            idStr = idStr + appendIdStr;
            textStr = textStr + appendTextStr;
            this.getContainsSearchTextPathIds(treeNode, idStr, textStr, containsTextIdPathList, allTreeIdList, searchText);
            idStr = idStr.replace(appendIdStr, "");
            textStr = textStr.replace(appendTextStr, "");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Object commOrgType = this.getModel().getValue("commorgtype");
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        if (commOrgType != null && HRStringUtils.equals((String)name, (String)"parentcomm")) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
            if (this.getModel().getValue("commframe") != null) {
                DynamicObject commFramDynamicObject = (DynamicObject)this.getModel().getValue("commframe");
                qFilters.add(new QFilter("commframe", "=", (Object)commFramDynamicObject.getLong("id")));
            }
            Long beforeCommOrgId = this.getBeforeCommOrgId();
            qFilters.add(new QFilter("commorgtype", "=", (Object)beforeCommOrgId));
            listFilterParameter.getQFilters().addAll(qFilters);
        }
        if (HRStringUtils.equals((String)name, (String)"parentcomm") && commOrgType == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u201c\u4e13\u59d4\u4f1a\u7ec4\u7ec7\u7c7b\u578b\u201d\u3002", (String)"CommOrgFormPlugin_4", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
        }
    }

    private Long getBeforeCommOrgId() {
        IPageCache pageCache = this.getView().getPageCache();
        DynamicObject currentCommOrgTypeObj = (DynamicObject)this.getModel().getValue("commorgtype");
        int currentCommOrgIndex = currentCommOrgTypeObj.getInt("index");
        String commOrtTypeMapStr = pageCache.get("indexIdMap");
        HashMap commOrtTypeMap = (HashMap)SerializationUtils.fromJsonString((String)commOrtTypeMapStr, HashMap.class);
        int minDeviationValue = Integer.MAX_VALUE;
        String beforeIndex = "10";
        for (String indexStr : commOrtTypeMap.keySet()) {
            int deviationValue = currentCommOrgIndex - Integer.parseInt(indexStr);
            if (deviationValue <= 0 || deviationValue >= minDeviationValue) continue;
            beforeIndex = indexStr;
            minDeviationValue = deviationValue;
        }
        return (Long)commOrtTypeMap.get(beforeIndex);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        Map customParams;
        super.preOpenForm(args);
        BillShowParameter showParameter = (BillShowParameter)args.getFormShowParameter();
        Object objPkId = showParameter.getPkId();
        if (Objects.isNull(objPkId) && Objects.isNull(objPkId = (customParams = showParameter.getCustomParams()).get("currentDataId"))) {
            return;
        }
        Long pkId = Long.parseLong(String.valueOf(objPkId));
        DynamicObject dynamicObject = this.commOrgApplicationService.queryOneCommOrg(pkId);
        if ("tdcs_commorg".equals(showParameter.getFormId())) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u4e13\u59d4\u4f1a\u7ec4\u7ec7-{0}", (String)"CommOrgFormPlugin_8", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{dynamicObject.getString("name")}));
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.showRelaMsg(tabKey);
    }

    private void showRelaMsg(String tabKey) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"linkflex"});
        Long commOrgId = this.getModel().getDataEntity().getLong("boid");
        String commOrgName = this.getModel().getDataEntity().getString("name");
        if ("commmember".equals(tabKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"grouplab"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"memberlab"});
            this.setParameter(commOrgId, commOrgName, "tdcs_commorguser", Lists.newArrayList((Object[])new QFilter[]{new QFilter("comm", "=", (Object)commOrgId), new QFilter("userstatus", "!=", (Object)"10")}), "commmember");
        } else if ("certificationgroup".equals(tabKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"grouplab"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"memberlab"});
            this.setParameter(commOrgId, commOrgName, "tdcs_certificationgroup", Lists.newArrayList((Object[])new QFilter[]{new QFilter("commorg", "=", (Object)commOrgId), new QFilter("enable", "!=", (Object)"10")}), "certificationgroup");
        }
    }

    private void setParameter(Long commOrgId, String commOrgName, String billFormId, List<QFilter> filters, String targetKey) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setBillFormId(billFormId);
        showParameter.setCustomParam("commOrgId", (Object)commOrgId);
        showParameter.setCustomParam("commOrgName", (Object)commOrgName);
        showParameter.setCustomParam("hiddenflexpanelap", (Object)"Yes");
        showParameter.getListFilterParameter().setQFilters(filters);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
        if (HRStringUtils.equals((String)"setframejobscm", (String)args.getActionId())) {
            Map returnDataMap = (Map)args.getReturnData();
            if (returnDataMap == null) {
                return;
            }
            Object jobscmIds = returnDataMap.get("jobscmIds");
            Object frameId = returnDataMap.get("frameId");
            DynamicObject commFrameObj = this.commFrameApplicationService.getCommFrameById(frameId)[0];
            commFrameObj.set("framejobscm", jobscmIds);
            this.commFrameApplicationService.update(commFrameObj);
            DynamicObjectCollection framejobscm = (DynamicObjectCollection)jobscmIds;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String frameJobScmIds = CommUtils.appendMulitBaseId((DynamicObjectCollection)framejobscm, (String)";");
            customParams.put("framejobscmId", frameJobScmIds);
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("framejobscmId", frameJobScmIds);
            this.getView().setVisible(Boolean.FALSE, new String[]{"mangerjobscmflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tabap"});
            this.initNewCsk();
        }
    }
}

