/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.BizObjApplycationService;
import kd.tdc.tdcs.bussiness.application.CertGroupApplicationService;
import kd.tdc.tdcs.bussiness.application.CommFrameApplicationService;
import kd.tdc.tdcs.bussiness.application.CommOrgApplicationService;
import kd.tdc.tdcs.bussiness.formservice.comm.CommOrgService;
import kd.tdc.tdcs.common.util.CommUtils;

public class CommOrgListPlugin
extends AbstractListPlugin {
    private final CommOrgApplicationService commOrgApplicationService = (CommOrgApplicationService)ServiceFactory.getService(CommOrgApplicationService.class);
    private final CertGroupApplicationService certGroupApplicationService = (CertGroupApplicationService)ServiceFactory.getService(CertGroupApplicationService.class);
    private final CommFrameApplicationService commFrameApplicationService = (CommFrameApplicationService)ServiceFactory.getService(CommFrameApplicationService.class);
    private static final Log logger = LogFactory.getLog(CommOrgListPlugin.class);
    private final CommOrgService commOrgService = (CommOrgService)ServiceFactory.getService(CommOrgService.class);
    private final List<String> opNameList = Lists.newArrayList((Object[])new String[]{"neworg", "delete", "submit", "unsubmit", "audit", "unaudit", "disable", "enable", "exportbylist"});

    public void setFilter(SetFilterEvent setFilterEvent) {
        HasPermOrgResult result;
        super.setFilter(setFilterEvent);
        IFormView view = this.getView();
        String billFormId = "";
        if (view instanceof ListView) {
            billFormId = ((ListView)this.getView()).getBillFormId();
        }
        if (!(result = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)BizObjApplycationService.queryBizAppIdByBizObj((String)billFormId, (String)"23I=0+6+0DLX"), (String)"tdcs_commorg", (String)"47150e89000000ac")).hasAllOrgPerm()) {
            setFilterEvent.getCustomQFilters().add(new QFilter("commframe.mainorg", "in", (Object)result.getHasPermOrgs()));
        }
        setFilterEvent.setOrderBy("index asc,number asc");
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("bos_listf7".equals(formId)) {
            setFilterEvent.getCustomQFilters().add(new QFilter("bsed", "<=", (Object)new Date()));
        }
    }

    public void beforeBindData(EventObject args) {
        super.beforeBindData(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("customParamMap", SerializationUtils.toJsonString((Object)customParams));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HyperLinkClickEvent hyperLinkClickEvent = args.getHyperLinkClickEvent();
        BillList billList = (BillList)hyperLinkClickEvent.getSource();
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        String billStatus = currentSelectedRowInfo.getBillStatus();
        if (HRStringUtils.equals((String)"A", (String)billStatus)) {
            args.setCancel(true);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long commId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            this.setPrarmByCommId(customParams, commId);
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("tdcs_commorg");
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setPkId(billList.getFocusRowPkId());
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "commorghyperlink"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void setPrarmByCommId(Map<String, Object> customParams, Long commId) {
        DynamicObject dynamicObject = this.commOrgApplicationService.queryOneCommOrg(commId);
        Long commFrameId = dynamicObject.getLong("commframe_id");
        DynamicObject commFrameObj = this.commFrameApplicationService.getCommFrameById((Object)commFrameId)[0];
        customParams.put("id", commFrameId);
        DynamicObjectCollection framejobscm = commFrameObj.getDynamicObjectCollection("framejobscm");
        if (!CollectionUtils.isEmpty((Collection)framejobscm)) {
            customParams.put("framejobscmId", CommUtils.appendMulitBaseId((DynamicObjectCollection)framejobscm, (String)";"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean needCheckCommFrame;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if ("delete".equals(opKey)) {
            ListSelectedRowCollection listSelectedData = ((Delete)args.getSource()).getListSelectedData();
            if (listSelectedData.isEmpty()) {
                return;
            }
            List orgIdList = listSelectedData.stream().map(listSelectedRow -> Long.parseLong(listSelectedRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = this.commOrgApplicationService.queryCommOrgDataByPkId("id,commframe", orgIdList);
            Set commFrameIdSet = Arrays.stream(dynamicObjects).map(d -> d.getLong("commframe.id")).collect(Collectors.toSet());
            if (HRCollUtil.isNotEmpty(commFrameIdSet)) {
                this.getView().getPageCache().put("deleteCommOrgFrameIds", SerializationUtils.serializeToBase64(commFrameIdSet));
            }
        }
        if ((needCheckCommFrame = this.opNameList.stream().anyMatch(e -> e.equals(opKey))) && !this.isSameCommFrameId()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u7684\u201c\u4e13\u59d4\u4f1a\u67b6\u6784\u201d\u6743\u9650\u6216\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CommOrgStdTreeListPlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public boolean isSameCommFrameId() {
        IPageCache pageCache = this.getView().getPageCache();
        String cacheFrameIdList = pageCache.get("commFrameIdList");
        IFormView view = this.getView();
        String billFormId = "";
        if (view instanceof ListView) {
            billFormId = ((ListView)this.getView()).getBillFormId();
        }
        return this.commOrgService.isSameCommFrameId(cacheFrameIdList, billFormId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        IPageCache pageCache = this.getView().getPageCache();
        if ("neworg".equals(opKey)) {
            HashMap<String, String> paramMap = new HashMap<String, String>(3);
            paramMap.put("id", this.getView().getPageCache().get("id"));
            paramMap.put("framejobscmId", this.getView().getPageCache().get("framejobscmId"));
            String orgTypeId = this.getView().getPageCache().get("orgTypeId");
            if (!StringUtils.isEmpty((Object)orgTypeId)) {
                paramMap.put("orgTypeId", orgTypeId);
            }
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setFormId("tdcs_commorg");
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "neworg"));
            baseShowParameter.setCustomParams(paramMap);
            this.getView().showForm((FormShowParameter)baseShowParameter);
        } else if ("refresh".equals(opKey)) {
            BillList billlistap = (BillList)this.getControl("billlistap");
            billlistap.refresh();
            TreeView treeview = (TreeView)this.getControl("treeview");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (treeview != null) {
                if (this.deleteFocusTreeNode()) {
                    return;
                }
                String clickId = pageCache.get("clickId");
                String parentId = pageCache.get("treeParentId");
                if (!"8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(clickId) && (StringUtils.isEmpty((Object)clickId) || StringUtils.isEmpty((Object)parentId))) {
                    treeview.treeNodeClick("", "" + customParams.get("id"));
                } else {
                    treeview.treeNodeClick(parentId, clickId);
                }
            }
        } else if ("delete".equals(opKey)) {
            pageCache.put("deleteRefreshFlag", "true");
            this.getView().invokeOperation("refresh");
            if (args.getOperationResult().isSuccess()) {
                String deleteCommOrgFrameIds = this.getView().getPageCache().get("deleteCommOrgFrameIds");
                if (HRStringUtils.isEmpty((String)deleteCommOrgFrameIds)) {
                    return;
                }
                Set frameIds = (Set)SerializationUtils.deSerializeFromBase64((String)deleteCommOrgFrameIds);
                if (HRCollUtil.isEmpty((Collection)frameIds)) {
                    return;
                }
                frameIds.forEach(id -> {
                    DynamicObject frameObj = this.commFrameApplicationService.getCommFrameById(id)[0];
                    this.commOrgApplicationService.updateCommOrgSize(id, frameObj);
                });
            }
        } else if ("enable".equals(opKey) || "disable".equals(opKey)) {
            boolean success;
            ListSelectedRowCollection listSelectedData = ((StatusConvert)args.getSource()).getListSelectedData();
            if (listSelectedData.isEmpty()) {
                return;
            }
            List<Long> orgIdList = listSelectedData.stream().map(listSelectedRow -> Long.parseLong(listSelectedRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            this.getView().invokeOperation("refresh");
            OperationResult operationResult = args.getOperationResult();
            boolean bl = success = operationResult == null || operationResult.isSuccess();
            if (success) {
                orgIdList.forEach(orgId -> {
                    DynamicObject commOrgDO = this.commOrgApplicationService.getCommOrgDO(orgId);
                    if (commOrgDO != null) {
                        DynamicObject dynamicObject = commOrgDO.getDynamicObject("commframe");
                        this.commOrgApplicationService.updateCommOrgSize(Long.valueOf(dynamicObject.getLong("id")), dynamicObject);
                    }
                });
            }
        } else if ("managementmember".equals(opKey)) {
            ListSelectedRow listFocusRow = ((Donothing)args.getSource()).getListFocusRow();
            Long commOrgId = (Long)listFocusRow.getPrimaryKeyValue();
            this.setParameter(commOrgId, listFocusRow.getName(), "tdcs_commorguser", new QFilter("comm", "=", (Object)commOrgId));
        } else if ("managementgroup".equals(opKey)) {
            ListSelectedRow listFocusRow = ((Donothing)args.getSource()).getListFocusRow();
            Long commOrgId = (Long)listFocusRow.getPrimaryKeyValue();
            this.setParameter(commOrgId, listFocusRow.getName(), "tdcs_certificationgroup", new QFilter("commorg", "=", (Object)commOrgId));
        }
    }

    private boolean deleteFocusTreeNode() {
        IPageCache pageCache = this.getView().getPageCache();
        String deleteRefresh = pageCache.get("deleteRefreshFlag");
        if (!StringUtils.isEmpty((Object)deleteRefresh)) {
            pageCache.put("deleteRefreshFlag", null);
            return this.filterListAndFocusNode(null);
        }
        return false;
    }

    private boolean filterListAndFocusNode(String frameId) {
        IPageCache pageCache = this.getView().getPageCache();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        TreeView treeview = (TreeView)this.getControl("treeview");
        String parentFrameId = "";
        if (StringUtils.isEmpty((Object)frameId)) {
            String string = frameId = pageCache.get("id") != null ? pageCache.get("id") : "" + customParams.get("id");
        }
        if (StringUtils.isEmpty((Object)frameId) || "null".equalsIgnoreCase(frameId)) {
            frameId = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
        } else {
            parentFrameId = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
        }
        treeview.treeNodeClick(parentFrameId, frameId);
        String allTreeListMapStr = this.getView().getPageCache().get("allTreeNodeString");
        if (!StringUtils.isEmpty((Object)allTreeListMapStr)) {
            TreeNode rootTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)allTreeListMapStr, TreeNode.class);
            if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(frameId)) {
                treeview.focusNode(rootTreeNode);
            } else {
                Map<String, TreeNode> treeNodeMap = rootTreeNode.getChildren().stream().collect(Collectors.toMap(k -> k.getId(), v -> v));
                TreeNode treeNode = treeNodeMap.get(frameId);
                if (treeNode != null) {
                    treeview.focusNode(treeNode);
                }
            }
        }
        return true;
    }

    private void setParameter(Long commOrgId, String commOrgName, String billFormId, QFilter filter) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId(billFormId);
        showParameter.setCustomParam("commOrgId", (Object)commOrgId);
        showParameter.setCustomParam("commOrgName", (Object)commOrgName);
        showParameter.getListFilterParameter().setFilter(filter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        Object frameIdObj;
        Map returnDataMap;
        super.closedCallBack(args);
        String actionId = args.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"neworg") || HRStringUtils.equals((String)actionId, (String)"commorghyperlink")) {
            this.getView().invokeOperation("refresh");
        }
        if ((returnDataMap = (Map)args.getReturnData()) != null && (frameIdObj = returnDataMap.get("id")) != null) {
            this.filterListAndFocusNode(frameIdObj.toString());
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new CountDataProvider(this.commOrgApplicationService, this.certGroupApplicationService));
    }

    static class CountDataProvider
    extends ListDataProvider {
        private CommOrgApplicationService commOrgApplicationService;
        private CertGroupApplicationService certGroupApplicationService;

        CountDataProvider(CommOrgApplicationService commOrgApplicationService, CertGroupApplicationService certGroupApplicationService) {
            this.commOrgApplicationService = commOrgApplicationService;
            this.certGroupApplicationService = certGroupApplicationService;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection superList = super.getData(start, limit);
            if (superList.isEmpty()) {
                return superList;
            }
            DynamicObjectType dynamicObjectType = superList.getDynamicObjectType();
            dynamicObjectType.registerProperty("commorgtotal", Integer.class, (Object)0, false);
            dynamicObjectType.registerProperty("certgrouptotal", Integer.class, (Object)0, false);
            List ids = superList.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
            logger.info("commorg list page id is\uff1a" + ids);
            Map commOrgUserSizeMap = this.commOrgApplicationService.getCommOrgUserSizes(ids);
            Map certGroupSizeMap = this.certGroupApplicationService.getCertGroupSizes(ids);
            superList.forEach(dynamicObject -> {
                Long pkId = dynamicObject.getLong("id");
                Integer userCount = commOrgUserSizeMap.get(pkId) == null ? Integer.valueOf(0) : (Integer)commOrgUserSizeMap.get(pkId);
                dynamicObject.set("commorgtotal", (Object)userCount);
                Integer groupCount = certGroupSizeMap.get(pkId) == null ? Integer.valueOf(0) : (Integer)certGroupSizeMap.get(pkId);
                dynamicObject.set("certgrouptotal", (Object)groupCount);
            });
            return superList;
        }
    }
}

